/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.status;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;

public class StatusConsoleListener
implements StatusListener {
    private static final String STATUS_LEVEL = "org.apache.logging.log4j.StatusLevel";
    private Level level = Level.FATAL;
    private String[] filters = null;

    public StatusConsoleListener() {
        String str = System.getProperty(STATUS_LEVEL);
        if (str != null) {
            this.level = Level.toLevel(str, Level.FATAL);
        }
    }

    public StatusConsoleListener(Level level) {
        this.level = level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void log(StatusData data) {
        if (data.getLevel().isAtLeastAsSpecificAs(this.level) && !this.filtered(data)) {
            System.out.println(data.getFormattedStatus());
        }
    }

    public void setFilters(String[] filters) {
        this.filters = filters;
    }

    private boolean filtered(StatusData data) {
        if (this.filters == null) {
            return false;
        }
        String caller = data.getStackTraceElement().getClassName();
        for (String filter : this.filters) {
            if (!caller.startsWith(filter)) continue;
            return true;
        }
        return false;
    }
}

