/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.junit;

import org.apache.logging.log4j.lang.NullMarked;
import org.apache.logging.log4j.lang.Nullable;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.PreconditionViolationException;

@NullMarked
public class ExtensionContextAnchor
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback {
    public static ExtensionContext.Namespace LOG4J2_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"org.apache.logging.log4j.junit"});
    private static final ThreadLocal<@Nullable ExtensionContext> EXTENSION_CONTEXT = new InheritableThreadLocal<ExtensionContext>();

    private static void bind(ExtensionContext context) {
        EXTENSION_CONTEXT.set(context);
    }

    private static void unbind(ExtensionContext context) {
        EXTENSION_CONTEXT.set(context.getParent().orElse(null));
    }

    public static @Nullable ExtensionContext getContext() {
        return EXTENSION_CONTEXT.get();
    }

    public static @Nullable ExtensionContext getContext(@Nullable ExtensionContext context) {
        return context != null ? context : EXTENSION_CONTEXT.get();
    }

    public static ExtensionContext getRequiredContext(@Nullable ExtensionContext context) {
        ExtensionContext actualContext = ExtensionContextAnchor.getContext(context);
        if (actualContext == null) {
            throw new PreconditionViolationException("No ExtensionContext available");
        }
        return actualContext;
    }

    public static ExtensionContext.Store getRequiredStore(@Nullable ExtensionContext context) {
        return ExtensionContextAnchor.getRequiredContext(context).getStore(LOG4J2_NAMESPACE);
    }

    public static <T> @Nullable T getAttribute(Object key, Class<T> clazz, @Nullable ExtensionContext context) {
        return (T)ExtensionContextAnchor.getRequiredStore(context).get(key, clazz);
    }

    public static <T> T getRequiredAttribute(Object key, Class<T> clazz, @Nullable ExtensionContext context) {
        Object attribute = ExtensionContextAnchor.getRequiredStore(context).get(key, clazz);
        if (attribute == null) {
            throw new PreconditionViolationException("Unable to find instance of " + clazz.getCanonicalName());
        }
        return (T)attribute;
    }

    public static void setAttribute(Object key, Object value, @Nullable ExtensionContext context) {
        ExtensionContextAnchor.getRequiredStore(context).put(key, value);
    }

    public static void removeAttribute(Object key, @Nullable ExtensionContext context) {
        ExtensionContext actualContext = ExtensionContextAnchor.getContext(context);
        if (actualContext != null) {
            actualContext.getStore(LOG4J2_NAMESPACE).remove(key);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        ExtensionContextAnchor.unbind(context);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        ExtensionContextAnchor.unbind(context);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        ExtensionContextAnchor.bind(context);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        ExtensionContextAnchor.bind(context);
    }
}

