/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.junit;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

abstract class AbstractFileCleaner
implements BeforeEachCallback {
    private static final int MAX_TRIES = Integer.getInteger("log4j2.junit.fileCleanerMaxTries", 10);
    private static final int SLEEP_PERIOD_MILLIS = Integer.getInteger("log4j2.junit.fileCleanerSleepPeriodMillis", 200);
    private static final int SLEEP_BASE_PERIOD_MILLIS = SLEEP_PERIOD_MILLIS / MAX_TRIES;

    AbstractFileCleaner() {
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.clean(context);
    }

    private void clean(ExtensionContext context) {
        Collection<Path> paths = this.getPathsForTest(context);
        if (paths.isEmpty()) {
            return;
        }
        ConcurrentHashMap<Path, IOException> failures = new ConcurrentHashMap<Path, IOException>();
        block2: for (Path path : paths) {
            if (!Files.exists(path, new LinkOption[0])) continue;
            int i = 0;
            int sleepMillis = SLEEP_BASE_PERIOD_MILLIS;
            while (i < MAX_TRIES) {
                try {
                    if (this.delete(path)) {
                        failures.remove(path);
                        continue block2;
                    }
                }
                catch (IOException e2) {
                    failures.put(path, e2);
                }
                LockSupport.parkNanos(path, TimeUnit.MILLISECONDS.toNanos(sleepMillis));
                if (Thread.interrupted()) {
                    failures.put(path, new InterruptedIOException());
                    Thread.currentThread().interrupt();
                    continue block2;
                }
                ++i;
                sleepMillis <<= 1;
            }
        }
        if (!failures.isEmpty()) {
            String message = failures.entrySet().stream().map(e -> e.getKey() + " failed with " + e.getValue()).collect(Collectors.joining(", "));
            Assertions.fail((String)message);
        }
    }

    abstract Collection<Path> getPathsForTest(ExtensionContext var1);

    abstract boolean delete(Path var1) throws IOException;
}

