/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.filesystem.validator;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.filesystem.conf.WorkSpaceConfiguration;
import org.apache.linkis.filesystem.exception.WorkSpaceException;
import org.apache.linkis.filesystem.util.WorkspaceUtil;
import org.apache.linkis.filesystem.validator.PathValidator$;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.Message$;
import org.apache.linkis.server.package$;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import scala.Function0;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@Aspect
@Component
@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\b\u0011\u0001mAQA\u000b\u0001\u0005\u0002-BQA\f\u0001\u0005\u0002=BQ!\u0011\u0001\u0005\u0002\tCQ!\u0018\u0001\u0005\u0002yCQ!\u0019\u0001\u0005\u0002\tDQa\u001a\u0001\u0005\u0002!DQa\u001b\u0001\u0005\u00021DQ!\u001f\u0001\u0005\u0002i<q!!\n\u0011\u0011\u0003\t9C\u0002\u0004\u0010!!\u0005\u0011\u0011\u0006\u0005\u0007U)!\t!a\u000b\t\u0011EQ!\u0019!C\u0001\u0003[Aq!a\f\u000bA\u0003%A\u0006\u0003\u0004h\u0015\u0011\u0005\u0011\u0011\u0007\u0002\u000e!\u0006$\bNV1mS\u0012\fGo\u001c:\u000b\u0005E\u0011\u0012!\u0003<bY&$\u0017\r^8s\u0015\t\u0019B#\u0001\u0006gS2,7/_:uK6T!!\u0006\f\u0002\r1Lgn[5t\u0015\t9\u0002$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00023\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\b\u0012\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\r\u0005s\u0017PU3g!\t\u0019\u0003&D\u0001%\u0015\t)c%A\u0003vi&d7O\u0003\u0002()\u000511m\\7n_:L!!\u000b\u0013\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001\f\t\u0003[\u0001i\u0011\u0001E\u0001\u0016e\u0016\u001cHOZ;m%\u0016\u001c\bo\u001c8tK\u000e\u000bGo\u001952)\u0005\u0001\u0004CA\u000f2\u0013\t\u0011dD\u0001\u0003V]&$\b\u0006\u0002\u00025}}\u0002\"!\u000e\u001f\u000e\u0003YR!a\u000e\u001d\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002:u\u0005!A.\u00198h\u0015\tY\u0004$A\u0004bgB,7\r\u001e6\n\u0005u2$\u0001\u0003)pS:$8-\u001e;\u0002\u000bY\fG.^3\"\u0003\u0001\u000b\u0011\u0010Q1o]>$\u0018\r^5p]\"z'o\u001a\u0018taJLgn\u001a4sC6,wo\u001c:l]],'M\f2j]\u0012t\u0013M\u001c8pi\u0006$\u0018n\u001c8/%\u0016\fX/Z:u\u001b\u0006\u0004\b/\u001b8hS\u00012c\u0005I<ji\"Lg\u000eK8sO:\n\u0007/Y2iK:b\u0017N\\6jg:2\u0017\u000e\\3tsN$X-\u001c\u0018sKN$h-\u001e7/CBLgFK\u0015\u0002\u000f\u001d,G\u000fU1uQR\u00191I\u0014.\u0011\u0005\u0011[eBA#J!\t1e$D\u0001H\u0015\tA%$\u0001\u0004=e>|GOP\u0005\u0003\u0015z\ta\u0001\u0015:fI\u00164\u0017B\u0001'N\u0005\u0019\u0019FO]5oO*\u0011!J\b\u0005\u0006\u001f\u000e\u0001\r\u0001U\u0001\u0005CJ<7\u000fE\u0002\u001e#NK!A\u0015\u0010\u0003\u000b\u0005\u0013(/Y=\u0011\u0005QCV\"A+\u000b\u0005e2&\"A,\u0002\t)\fg/Y\u0005\u00033V\u0013aa\u00142kK\u000e$\b\"B.\u0004\u0001\u0004a\u0016A\u00039be\u0006lg*Y7fgB\u0019Q$U\"\u0002\u0017\u001d,G/V:fe:\u000bW.\u001a\u000b\u0004\u0007~\u0003\u0007\"B(\u0005\u0001\u0004\u0001\u0006\"B.\u0005\u0001\u0004a\u0016!C2iK\u000e\\\u0007+\u0019;i)\r\u00014-\u001a\u0005\u0006I\u0016\u0001\raQ\u0001\u0005a\u0006$\b\u000eC\u0003g\u000b\u0001\u00071)\u0001\u0005vg\u0016\u0014h.Y7f\u0003!1\u0018\r\\5eCR,Gc\u0001\u0019jU\")qJ\u0002a\u0001!\")1L\u0002a\u00019\u0006\u0019B-Z1m%\u0016\u001c\bo\u001c8tKJ+7\u000f\u001e4vYR\u00111+\u001c\u0005\u0006]\u001e\u0001\ra\\\u0001\u0014aJ|7-Z3eS:<'j\\5o!>Lg\u000e\u001e\t\u0003aFl\u0011\u0001O\u0005\u0003eb\u00121\u0003\u0015:pG\u0016,G-\u001b8h\u0015>Lg\u000eU8j]RDCa\u0002;?oB\u0011Q'^\u0005\u0003mZ\u0012a!\u0011:pk:$\u0017%\u0001=\u0002/I,7\u000f\u001e4vYJ+7\u000f]8og\u0016\u001c\u0015\r^2ic!J\u0013AF4fi\u000e+(O]3oi\"#H\u000f\u001d*fgB|gn]3\u0016\u0003m\u00042\u0001`A\u0004\u001b\u0005i(B\u0001@\u0000\u0003\u0011AG\u000f\u001e9\u000b\t\u0005\u0005\u00111A\u0001\bg\u0016\u0014h\u000f\\3u\u0015\t\t)!A\u0003kCZ\f\u00070C\u0002\u0002\nu\u00141\u0003\u0013;uaN+'O\u001e7fiJ+7\u000f]8og\u0016D3\u0001AA\u0007!\u0011\ty!!\u0007\u000e\u0005\u0005E!\u0002BA\n\u0003+\t!b\u001d;fe\u0016|G/\u001f9f\u0015\r\t9\u0002G\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW&!\u00111DA\t\u0005%\u0019u.\u001c9p]\u0016tG\u000fK\u0002\u0001\u0003?\u00012!NA\u0011\u0013\r\t\u0019C\u000e\u0002\u0007\u0003N\u0004Xm\u0019;\u0002\u001bA\u000bG\u000f\u001b,bY&$\u0017\r^8s!\ti#b\u0005\u0002\u000b9Q\u0011\u0011qE\u000b\u0002Y\u0005Qa/\u00197jI\u0006$xN\u001d\u0011\u0015\u000bA\n\u0019$!\u000e\t\u000b\u0011t\u0001\u0019A\"\t\u000b\u0019t\u0001\u0019A\"")
public class PathValidator
implements Logging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public static PathValidator validator() {
        return PathValidator$.MODULE$.validator();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        PathValidator pathValidator = this;
        synchronized (pathValidator) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.RequestMapping) && within(org.apache.linkis.filesystem.restful.api.*)")
    public void restfulResponseCatch1() {
    }

    public String getPath(Object[] args, String[] paramNames) {
        String path;
        block1: {
            Map map;
            Object object;
            block2: {
                JsonNode jsonNode;
                int index;
                block0: {
                    path = null;
                    index = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])paramNames)).indexOf((Object)"path");
                    if (index == -1) break block0;
                    path = (String)args[index];
                    break block1;
                }
                index = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])paramNames)).indexOf((Object)"json");
                if (index == -1) break block1;
                object = args[index];
                if (!(object instanceof JsonNode) || (jsonNode = (JsonNode)object).get("path") == null) break block2;
                path = jsonNode.get("path").textValue();
                break block1;
            }
            if (!(object instanceof Map) || (map = (Map)object).get("path") == null) break block1;
            path = (String)map.get("path");
        }
        return path;
    }

    public String getUserName(Object[] args, String[] paramNames) {
        String username = null;
        int n = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])paramNames)).indexOf((Object)"req");
        if (-1 == n) {
        } else {
            int n2 = n;
            int proxyUser = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])paramNames)).indexOf((Object)"proxyUser");
            username = proxyUser == -1 || StringUtils.isEmpty((Object)args[proxyUser]) ? ModuleUserUtils.getOperationUser((HttpServletRequest)((HttpServletRequest)args[n2])) : args[proxyUser].toString();
        }
        return username;
    }

    public void checkPath(String path, String username) {
        if (path.contains("hdfs://") || path.contains("oss://") || path.contains("s3://")) {
            return;
        }
        String userLocalRootPath = new StringBuilder(0).append(WorkspaceUtil.suffixTuning((String)WorkSpaceConfiguration.LOCAL_USER_ROOT_PATH.getValue())).append(username).toString();
        String userHdfsRootPath = new StringBuilder(0).append(WorkspaceUtil.suffixTuning((String)WorkSpaceConfiguration.HDFS_USER_ROOT_PATH_PREFIX.getValue())).append(username).append(WorkSpaceConfiguration.HDFS_USER_ROOT_PATH_SUFFIX.getValue()).toString();
        if (!path.contains("file://")) {
            throw new WorkSpaceException(80025, "the path should contain schema");
        }
        userHdfsRootPath = StringUtils.trimTrailingCharacter((String)userHdfsRootPath, (char)File.separatorChar);
        if (path.contains("../")) {
            throw new WorkSpaceException(80026, "Relative path not allowed");
        }
        if (!path.contains(userLocalRootPath) && !path.contains(userHdfsRootPath)) {
            throw new WorkSpaceException(80027, "The path needs to be within the user's own workspace path");
        }
    }

    public void validate(Object[] args, String[] paramNames) {
        String path = this.getPath(args, paramNames);
        String username = this.getUserName(args, paramNames);
        if (!StringUtils.isEmpty((Object)path) && !StringUtils.isEmpty((Object)username)) {
            this.logger().info(String.format("user:%s,path:%s", username, path));
            this.checkPath(path, username);
            return;
        }
    }

    @Around(value="restfulResponseCatch1()")
    public Object dealResponseRestful(ProceedingJoinPoint proceedingJoinPoint) {
        Message resp = package$.MODULE$.catchIt((Function0 & Serializable & scala.Serializable)() -> {
            block0: {
                MethodSignature signature = (MethodSignature)proceedingJoinPoint.getSignature();
                this.logger().info("enter the path validator,the method is {}", new Object[]{signature.getName()});
                if (!Predef$.MODULE$.Boolean2boolean((Boolean)WorkSpaceConfiguration.FILESYSTEM_PATH_CHECK_TRIGGER.getValue())) break block0;
                this.logger().info("path check trigger is open,now check the path");
                this.validate(proceedingJoinPoint.getArgs(), signature.getParameterNames());
            }
            return Message$.MODULE$.ok();
        }, this.logger());
        if (Message$.MODULE$.messageToHttpStatus(resp) != 200) {
            return resp;
        }
        return proceedingJoinPoint.proceed();
    }

    public HttpServletResponse getCurrentHttpResponse() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            HttpServletResponse response = ((ServletRequestAttributes)requestAttributes).getResponse();
            return response;
        }
        return null;
    }

    public PathValidator() {
        Logging.$init$((Logging)this);
    }
}

