/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.filesystem.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.linkis.filesystem.entity.LogLevel;
import org.apache.linkis.filesystem.exception.WorkSpaceException;
import org.apache.linkis.filesystem.exception.WorkspaceExceptionManager;

public class WorkspaceUtil {
    public static String infoReg = "((19|20)[0-9]{2})-(0?[1-9]|1[012])-(0?[1-9]|[12][0-9]|3[01]) ([01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]\\.\\d{3}\\s*INFO(.*)";
    public static String warnReg = "((19|20)[0-9]{2})-(0?[1-9]|1[012])-(0?[1-9]|[12][0-9]|3[01]) ([01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]\\.\\d{3}\\s*WARN(.*)";
    public static String errorReg = "((19|20)[0-9]{2})-(0?[1-9]|1[012])-(0?[1-9]|[12][0-9]|3[01]) ([01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]\\.\\d{3}\\s*ERROR(.*)";
    public static String allReg = "(.*?)";
    public static List<LogLevel.Type> logReg = new ArrayList<LogLevel.Type>();
    public static Function<String, String> suffixTuningFunction = p -> {
        if (p.endsWith(File.separator)) {
            return p;
        }
        return p + File.separator;
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static List<Integer> logMatch(String code, LogLevel logLevel) {
        if (logReg.isEmpty()) {
            Class<WorkspaceUtil> clazz = WorkspaceUtil.class;
            // MONITORENTER : org.apache.linkis.filesystem.util.WorkspaceUtil.class
            if (logReg.isEmpty()) {
                logReg.add(LogLevel.Type.ERROR);
                logReg.add(LogLevel.Type.WARN);
                logReg.add(LogLevel.Type.INFO);
            }
            // MONITOREXIT : clazz
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        Optional<LogLevel.Type> any = logReg.stream().filter(r -> Pattern.matches(r.getReg(), code)).findAny();
        if (any.isPresent()) {
            result.add(any.get().ordinal());
            result.add(LogLevel.Type.ALL.ordinal());
            logLevel.setType(any.get());
            return result;
        }
        result.add(LogLevel.Type.ALL.ordinal());
        if (logLevel.getType() == LogLevel.Type.ALL) return result;
        result.add(logLevel.getType().ordinal());
        return result;
    }

    public static String suffixTuning(String path) {
        return suffixTuningFunction.apply(path);
    }

    public static void fileAndDirNameSpecialCharCheck(String path) throws WorkSpaceException {
        String name = new File(path).getName();
        WorkspaceUtil.charCheckFileName(name);
    }

    public static void charCheckFileName(String fileName) throws WorkSpaceException {
        String specialRegEx;
        Pattern specialPattern;
        int i = fileName.lastIndexOf(".");
        if (i != -1) {
            fileName = fileName.substring(0, i);
        }
        if (!(specialPattern = Pattern.compile(specialRegEx = "^[\\w\\u4e00-\\u9fa5]{1,200}$")).matcher(fileName).find()) {
            WorkspaceExceptionManager.createException(80028, new Object[0]);
        }
    }
}

