/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.filesystem.validator;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.filesystem.conf.WorkSpaceConfiguration;
import org.apache.linkis.filesystem.exception.WorkSpaceException;
import org.apache.linkis.filesystem.util.WorkspaceUtil;
import org.apache.linkis.filesystem.validator.PathValidator$;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.Message$;
import org.apache.linkis.server.package$;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.apache.linkis.storage.utils.StorageUtils$;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Aspect
@Component
@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u00015\u0011Q\u0002U1uQZ\u000bG.\u001b3bi>\u0014(BA\u0002\u0005\u0003%1\u0018\r\\5eCR|'O\u0003\u0002\u0006\r\u0005Qa-\u001b7fgf\u001cH/Z7\u000b\u0005\u001dA\u0011A\u00027j].L7O\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u001655\taC\u0003\u0002\u00181\u0005)Q\u000f^5mg*\u0011\u0011DB\u0001\u0007G>lWn\u001c8\n\u0005m1\"a\u0002'pO\u001eLgn\u001a\u0005\u0006;\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003\tAQA\t\u0001\u0005\u0002\r\nQC]3ti\u001a,HNU3ta>t7/Z\"bi\u000eD\u0017\u0007F\u0001%!\tyQ%\u0003\u0002'!\t!QK\\5uQ\u0011\t\u0003FM\u001a\u0011\u0005%\u0002T\"\u0001\u0016\u000b\u0005-b\u0013AC1o]>$\u0018\r^5p]*\u0011QFL\u0001\u0005Y\u0006twM\u0003\u00020\u0015\u00059\u0011m\u001d9fGRT\u0017BA\u0019+\u0005!\u0001v.\u001b8uGV$\u0018!\u0002<bYV,\u0017%\u0001\u001b\u0002s\u0002\u000bgN\\8uCRLwN\u001c\u0015pe\u001et3\u000f\u001d:j]\u001e4'/Y7fo>\u00148NL<fE:\u0012\u0017N\u001c3/C:tw\u000e^1uS>tgFU3rk\u0016\u001cH/T1qa&tw-\u000b\u0011'M\u0001:\u0018\u000e\u001e5j]\"z'o\u001a\u0018ba\u0006\u001c\u0007.\u001a\u0018mS:\\\u0017n\u001d\u0018gS2,7/_:uK6t#/Z:uMVdg&\u00199j])J\u0003\"\u0002\u001c\u0001\t\u00039\u0014aB4fiB\u000bG\u000f\u001b\u000b\u0004q}Z\u0005CA\u001d=\u001d\ty!(\u0003\u0002<!\u00051\u0001K]3eK\u001aL!!\u0010 \u0003\rM#(/\u001b8h\u0015\tY\u0004\u0003C\u0003Ak\u0001\u0007\u0011)\u0001\u0003be\u001e\u001c\bcA\bC\t&\u00111\t\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u000b&k\u0011A\u0012\u0006\u0003[\u001dS\u0011\u0001S\u0001\u0005U\u00064\u0018-\u0003\u0002K\r\n1qJ\u00196fGRDQ\u0001T\u001bA\u00025\u000b!\u0002]1sC6t\u0015-\\3t!\ry!\t\u000f\u0005\u0006\u001f\u0002!\t\u0001U\u0001\fO\u0016$Xk]3s\u001d\u0006lW\rF\u00029#JCQ\u0001\u0011(A\u0002\u0005CQ\u0001\u0014(A\u00025CQ\u0001\u0016\u0001\u0005\u0002U\u000b\u0011b\u00195fG.\u0004\u0016\r\u001e5\u0015\u0007\u00112\u0006\fC\u0003X'\u0002\u0007\u0001(\u0001\u0003qCRD\u0007\"B-T\u0001\u0004A\u0014\u0001C;tKJt\u0017-\\3\t\u000bm\u0003A\u0011\u0001/\u0002\u0011Y\fG.\u001b3bi\u0016$2\u0001J/_\u0011\u0015\u0001%\f1\u0001B\u0011\u0015a%\f1\u0001N\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0003M!W-\u00197SKN\u0004xN\\:f%\u0016\u001cHOZ;m)\t!%\rC\u0003d?\u0002\u0007A-A\nqe>\u001cW-\u001a3j]\u001eTu.\u001b8Q_&tG\u000f\u0005\u0002fM6\tA&\u0003\u0002hY\t\u0019\u0002K]8dK\u0016$\u0017N\\4K_&t\u0007k\\5oi\"\"q,\u001b\u001am!\tI#.\u0003\u0002lU\t1\u0011I]8v]\u0012\f\u0013!\\\u0001\u0018e\u0016\u001cHOZ;m%\u0016\u001c\bo\u001c8tK\u000e\u000bGo\u001952Q%BQa\u001c\u0001\u0005\u0002A\facZ3u\u0007V\u0014(/\u001a8u\u0011R$\bOU3ta>t7/Z\u000b\u0002cB\u0011!/_\u0007\u0002g*\u0011A/^\u0001\u0005QR$\bO\u0003\u0002wo\u000691/\u001a:wY\u0016$(\"\u0001=\u0002\u000b)\fg/\u0019=\n\u0005i\u001c(a\u0005%uiB\u001cVM\u001d<mKR\u0014Vm\u001d9p]N,\u0007F\u0001\u0001}!\ri\u0018QA\u0007\u0002}*\u0019q0!\u0001\u0002\u0015M$XM]3pif\u0004XMC\u0002\u0002\u0004)\tqb\u001d9sS:<gM]1nK^|'o[\u0005\u0004\u0003\u000fq(!C\"p[B|g.\u001a8uQ\r\u0001\u00111\u0002\t\u0004S\u00055\u0011bAA\bU\t1\u0011i\u001d9fGR<q!a\u0005\u0003\u0011\u0003\t)\"A\u0007QCRDg+\u00197jI\u0006$xN\u001d\t\u0004A\u0005]aAB\u0001\u0003\u0011\u0003\tIbE\u0002\u0002\u00189Aq!HA\f\t\u0003\ti\u0002\u0006\u0002\u0002\u0016!I1!a\u0006C\u0002\u0013\u0005\u0011\u0011E\u000b\u0002?!A\u0011QEA\fA\u0003%q$\u0001\u0006wC2LG-\u0019;pe\u0002BqaWA\f\t\u0003\tI\u0003F\u0003%\u0003W\ti\u0003\u0003\u0004X\u0003O\u0001\r\u0001\u000f\u0005\u00073\u0006\u001d\u0002\u0019\u0001\u001d")
public class PathValidator
implements Logging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static PathValidator validator() {
        return PathValidator$.MODULE$.validator();
    }

    private Logger logger$lzycompute() {
        PathValidator pathValidator = this;
        synchronized (pathValidator) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.RequestMapping) && within(org.apache.linkis.filesystem.restful.api.*)")
    public void restfulResponseCatch1() {
    }

    /*
     * WARNING - void declaration
     */
    public String getPath(Object[] args, String[] paramNames) {
        void var3_3;
        String path = null;
        int index = Predef$.MODULE$.refArrayOps((Object[])paramNames).indexOf((Object)"path");
        if (index != -1) {
            path = (String)args[index];
        } else {
            index = Predef$.MODULE$.refArrayOps((Object[])paramNames).indexOf((Object)"json");
            if (index != -1) {
                Map map;
                JsonNode jsonNode;
                Object object = args[index];
                if (object instanceof JsonNode && (jsonNode = (JsonNode)object).get("path") != null) {
                    path = jsonNode.get("path").textValue();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (object instanceof Map && (map = (Map)object).get("path") != null) {
                    path = (String)map.get("path");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public String getUserName(Object[] args, String[] paramNames) {
        void var3_3;
        String username = null;
        int n = Predef$.MODULE$.refArrayOps((Object[])paramNames).indexOf((Object)"req");
        if (-1 == n) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            int n2 = n;
            int proxyUser = Predef$.MODULE$.refArrayOps((Object[])paramNames).indexOf((Object)"proxyUser");
            if (proxyUser == -1 || StringUtils.isEmpty((Object)args[proxyUser])) {
                username = ModuleUserUtils.getOperationUser((HttpServletRequest)((HttpServletRequest)args[n2]));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                username = args[proxyUser].toString();
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
        return var3_3;
    }

    public void checkPath(String path, String username) {
        String userLocalRootPath = new StringBuilder().append((Object)WorkspaceUtil.suffixTuning((String)WorkSpaceConfiguration.LOCAL_USER_ROOT_PATH.getValue())).append((Object)username).toString();
        String userHdfsRootPath = new StringBuilder().append((Object)WorkspaceUtil.suffixTuning((String)WorkSpaceConfiguration.HDFS_USER_ROOT_PATH_PREFIX.getValue())).append((Object)username).append(WorkSpaceConfiguration.HDFS_USER_ROOT_PATH_SUFFIX.getValue()).toString();
        if (path.contains(StorageUtils$.MODULE$.FILE_SCHEMA()) || path.contains(StorageUtils$.MODULE$.HDFS_SCHEMA())) {
            userHdfsRootPath = StringUtils.trimTrailingCharacter((String)userHdfsRootPath, (char)File.separatorChar);
            if (path.contains("../")) {
                throw new WorkSpaceException(80026, "Relative path not allowed");
            }
            if (path.contains(userLocalRootPath) || path.contains(userHdfsRootPath)) {
                return;
            }
            throw new WorkSpaceException(80027, "The path needs to be within the user's own workspace path");
        }
        throw new WorkSpaceException(80025, "the path should contain schema");
    }

    public void validate(Object[] args, String[] paramNames) {
        String path = this.getPath(args, paramNames);
        String username = this.getUserName(args, paramNames);
        if (!StringUtils.isEmpty((Object)path) && !StringUtils.isEmpty((Object)username)) {
            this.logger().info(String.format("user:%s,path:%s", username, path));
            this.checkPath(path, username);
        }
    }

    @Around(value="restfulResponseCatch1()")
    public Object dealResponseRestful(ProceedingJoinPoint proceedingJoinPoint) {
        Message resp = package$.MODULE$.catchIt((Function0)new Serializable(this, proceedingJoinPoint){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValidator $outer;
            private final ProceedingJoinPoint proceedingJoinPoint$1;

            public final Message apply() {
                MethodSignature signature = (MethodSignature)this.proceedingJoinPoint$1.getSignature();
                this.$outer.logger().info("enter the path validator,the method is {}", new Object[]{signature.getName()});
                if (Predef$.MODULE$.Boolean2boolean((Boolean)WorkSpaceConfiguration.FILESYSTEM_PATH_CHECK_TRIGGER.getValue())) {
                    this.$outer.logger().info("path check trigger is open,now check the path");
                    this.$outer.validate(this.proceedingJoinPoint$1.getArgs(), signature.getParameterNames());
                }
                return Message$.MODULE$.ok();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.proceedingJoinPoint$1 = proceedingJoinPoint$1;
            }
        }, this.logger());
        return Message$.MODULE$.messageToHttpStatus(resp) != 200 ? resp : proceedingJoinPoint.proceed();
    }

    public HttpServletResponse getCurrentHttpResponse() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            HttpServletResponse response = ((ServletRequestAttributes)requestAttributes).getResponse();
            return response;
        }
        return null;
    }

    public PathValidator() {
        Logging.class.$init$((Logging)this);
    }
}

