/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.filesystem.service;

import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.filesystem.cache.FsCache$;
import org.apache.linkis.filesystem.conf.WorkSpaceConfiguration;
import org.apache.linkis.filesystem.entity.FSInfo;
import org.apache.linkis.filesystem.exception.WorkSpaceException;
import org.apache.linkis.filesystem.exception.WorkspaceExceptionManager;
import org.apache.linkis.filesystem.service.FsService$;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.fs.FileSystem;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IndexedSeqOptimized;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ResizableArray;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@Service
@ScalaSignature(bytes="\u0006\u0001\u00054A!\u0001\u0002\u0001\u001b\tIai]*feZL7-\u001a\u0006\u0003\u0007\u0011\tqa]3sm&\u001cWM\u0003\u0002\u0006\r\u0005Qa-\u001b7fgf\u001cH/Z7\u000b\u0005\u001dA\u0011A\u00027j].L7O\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u001655\taC\u0003\u0002\u00181\u0005)Q\u000f^5mg*\u0011\u0011DB\u0001\u0007G>lWn\u001c8\n\u0005m1\"a\u0002'pO\u001eLgn\u001a\u0005\u0006;\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003\tAQA\t\u0001\u0005\u0002\r\n!cZ3u\r&dWmU=ti\u0016l7)Y2iKR\u0019A\u0005L\u001b\u0011\u0005\u0015RS\"\u0001\u0014\u000b\u0005\u001dB\u0013A\u00014t\u0015\tIc!A\u0004ti>\u0014\u0018mZ3\n\u0005-2#A\u0003$jY\u0016\u001c\u0016p\u001d;f[\")Q&\ta\u0001]\u0005!Qo]3s!\ty#G\u0004\u0002\u0010a%\u0011\u0011\u0007E\u0001\u0007!J,G-\u001a4\n\u0005M\"$AB*ue&twM\u0003\u00022!!)a'\ta\u0001o\u00051am\u001d)bi\"\u0004\"\u0001O\u001e\u000e\u0003eR!A\u000f\r\u0002\u0005%|\u0017B\u0001\u001f:\u0005\u001915\u000fU1uQ\")a\b\u0001C\u0001\u007f\u0005iq-\u001a;GS2,7+_:uK6$2\u0001\n!B\u0011\u0015iS\b1\u0001/\u0011\u00151T\b1\u00018Q\ri4\t\u0014\t\u0004\u001f\u00113\u0015BA#\u0011\u0005\u0019!\bN]8xgB\u0011qIS\u0007\u0002\u0011*\u0011\u0011\nB\u0001\nKb\u001cW\r\u001d;j_:L!a\u0013%\u0003%]{'o[*qC\u000e,W\t_2faRLwN\\\u0012\u0002\r\")a\n\u0001C\u0001\u001f\u0006i\u0001O]8ek\u000e,giU%oM>$2\u0001\u0015,X!\t\tF+D\u0001S\u0015\t\u0019F!\u0001\u0004f]RLG/_\u0005\u0003+J\u0013aAR*J]\u001a|\u0007\"B\u0017N\u0001\u0004q\u0003\"\u0002\u001cN\u0001\u00049\u0004F\u0001\u0001Z!\tQv,D\u0001\\\u0015\taV,\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016T!A\u0018\u0006\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.L!\u0001Y.\u0003\u000fM+'O^5dK\u0002")
public class FsService
implements Logging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        FsService fsService = this;
        synchronized (fsService) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public FileSystem getFileSystemCache(String user, FsPath fsPath) {
        ArrayBuffer arrayBuffer;
        BoxedUnit boxedUnit;
        if (FsCache$.MODULE$.fsInfo().get(user) == null) {
            HashMap<String, ArrayBuffer<FSInfo>> hashMap = FsCache$.MODULE$.fsInfo();
            // MONITORENTER : hashMap
            Object object = FsCache$.MODULE$.fsInfo().get(user) == null ? JavaConversions$.MODULE$.mapAsScalaMap(FsCache$.MODULE$.fsInfo()).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)user), (Object)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FSInfo[]{this.produceFSInfo(user, fsPath)})))) : BoxedUnit.UNIT;
            // MONITOREXIT : hashMap
            if (!((IndexedSeqOptimized)((TraversableLike)FsCache$.MODULE$.fsInfo().get(user)).filter((Function1)new Serializable(this, fsPath){
                public static final long serialVersionUID = 0L;
                private final FsPath fsPath$1;

                public final boolean apply(FSInfo x$3) {
                    return x$3.fs().fsName().equals(this.fsPath$1.getFsType());
                }
                {
                    this.fsPath$1 = fsPath$1;
                }
            })).isEmpty()) {
                boxedUnit = BoxedUnit.UNIT;
                return ((FSInfo)((ResizableArray)((TraversableLike)JavaConversions$.MODULE$.mapAsScalaMap(FsCache$.MODULE$.fsInfo()).apply((Object)user)).filter((Function1)new Serializable(this, fsPath){
                    public static final long serialVersionUID = 0L;
                    private final FsPath fsPath$1;

                    public final boolean apply(FSInfo x$5) {
                        return x$5.fs().fsName().equals(this.fsPath$1.getFsType());
                    }
                    {
                        this.fsPath$1 = fsPath$1;
                    }
                })).apply(0)).fs();
            }
            ArrayBuffer<FSInfo> arrayBuffer2 = FsCache$.MODULE$.fsInfo().get(user);
            // MONITORENTER : arrayBuffer2
            BoxedUnit boxedUnit2 = ((IndexedSeqOptimized)((TraversableLike)FsCache$.MODULE$.fsInfo().get(user)).filter((Function1)new Serializable(this, fsPath){
                public static final long serialVersionUID = 0L;
                private final FsPath fsPath$1;

                public final boolean apply(FSInfo x$4) {
                    return x$4.fs().fsName().equals(this.fsPath$1.getFsType());
                }
                {
                    this.fsPath$1 = fsPath$1;
                }
            })).isEmpty() ? FsCache$.MODULE$.fsInfo().get(user).$plus$eq((Object)this.produceFSInfo(user, fsPath)) : BoxedUnit.UNIT;
            // MONITOREXIT : arrayBuffer2
            boxedUnit = boxedUnit2;
            return ((FSInfo)((ResizableArray)((TraversableLike)JavaConversions$.MODULE$.mapAsScalaMap(FsCache$.MODULE$.fsInfo()).apply((Object)user)).filter((Function1)new /* invalid duplicate definition of identical inner class */)).apply(0)).fs();
        }
        ArrayBuffer<FSInfo> arrayBuffer3 = FsCache$.MODULE$.fsInfo().get(user);
        // MONITORENTER : arrayBuffer3
        if (((IndexedSeqOptimized)((TraversableLike)FsCache$.MODULE$.fsInfo().get(user)).filter((Function1)new Serializable(this, fsPath){
            public static final long serialVersionUID = 0L;
            private final FsPath fsPath$1;

            public final boolean apply(FSInfo x$1) {
                return x$1.fs().fsName().equals(this.fsPath$1.getFsType());
            }
            {
                this.fsPath$1 = fsPath$1;
            }
        })).isEmpty()) {
            arrayBuffer = FsCache$.MODULE$.fsInfo().get(user).$plus$eq((Object)this.produceFSInfo(user, fsPath));
        } else {
            ((FSInfo)((ResizableArray)((TraversableLike)FsCache$.MODULE$.fsInfo().get(user)).filter((Function1)new Serializable(this, fsPath){
                public static final long serialVersionUID = 0L;
                private final FsPath fsPath$1;

                public final boolean apply(FSInfo x$2) {
                    return x$2.fs().fsName().equals(this.fsPath$1.getFsType());
                }
                {
                    this.fsPath$1 = fsPath$1;
                }
            })).apply(0)).lastAccessTime_$eq(System.currentTimeMillis());
            arrayBuffer = BoxedUnit.UNIT;
        }
        ArrayBuffer arrayBuffer4 = arrayBuffer;
        // MONITOREXIT : arrayBuffer3
        boxedUnit = arrayBuffer4;
        return ((FSInfo)((ResizableArray)((TraversableLike)JavaConversions$.MODULE$.mapAsScalaMap(FsCache$.MODULE$.fsInfo()).apply((Object)user)).filter((Function1)new /* invalid duplicate definition of identical inner class */)).apply(0)).fs();
        catch (Throwable throwable) {
            // MONITOREXIT : hashMap
            throw throwable;
        }
        catch (Throwable throwable) {
            // MONITOREXIT : arrayBuffer2
            throw throwable;
        }
    }

    public FileSystem getFileSystem(String user, FsPath fsPath) throws WorkSpaceException {
        ObjectRef fs = ObjectRef.create(null);
        long start = System.currentTimeMillis();
        FutureTask<FileSystem> task = new FutureTask<FileSystem>(new Callable<FileSystem>(this, user, fsPath, fs){
            private final /* synthetic */ FsService $outer;
            public final String user$1;
            public final FsPath fsPath$2;
            private final ObjectRef fs$1;

            public FileSystem call() {
                this.fs$1.elem = (FileSystem)Utils$.MODULE$.tryAndError((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    public final FileSystem apply() {
                        return this.$outer.org$apache$linkis$filesystem$service$FsService$$anon$$$outer().getFileSystemCache(this.$outer.user$1, this.$outer.fsPath$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.$outer.logger());
                return (FileSystem)this.fs$1.elem;
            }

            public /* synthetic */ FsService org$apache$linkis$filesystem$service$FsService$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.user$1 = user$1;
                this.fsPath$2 = fsPath$2;
                this.fs$1 = fs$1;
            }
        });
        WorkSpaceConfiguration.executorService.execute(task);
        long timeout = Predef$.MODULE$.Long2long((Long)WorkSpaceConfiguration.FILESYSTEM_GET_TIMEOUT.getValue());
        try {
            FileSystem fileSystem;
            try {
                fileSystem = task.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                this.logger().error("Failed to getFileSystem", (Throwable)timeoutException);
                task.cancel(true);
                fileSystem = null;
            }
            catch (ExecutionException executionException) {
                this.logger().error("Failed to getFileSystem", (Throwable)executionException);
                task.cancel(true);
                fileSystem = null;
            }
            catch (InterruptedException interruptedException) {
                this.logger().error("Failed to getFileSystem", (Throwable)interruptedException);
                task.cancel(true);
                fileSystem = null;
            }
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " gets the ", " type filesystem using a total of ", " milliseconds(", "\u83b7\u53d6", "\u7c7b\u578b\u7684filesystem\u4e00\u5171\u4f7f\u7528\u4e86", "\u6beb\u79d2)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{user, fsPath.getFsType(), BoxesRunTime.boxToLong((long)(end - start)), user, fsPath.getFsType(), BoxesRunTime.boxToLong((long)(end - start))})));
            throw throwable;
        }
        long end = System.currentTimeMillis();
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " gets the ", " type filesystem using a total of ", " milliseconds(", "\u83b7\u53d6", "\u7c7b\u578b\u7684filesystem\u4e00\u5171\u4f7f\u7528\u4e86", "\u6beb\u79d2)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{user, fsPath.getFsType(), BoxesRunTime.boxToLong((long)(end - start)), user, fsPath.getFsType(), BoxesRunTime.boxToLong((long)(end - start))})));
        if ((FileSystem)fs.elem == null) {
            throw WorkspaceExceptionManager.createException(80002, BoxesRunTime.boxToLong((long)timeout), BoxesRunTime.boxToLong((long)timeout));
        }
        return (FileSystem)fs.elem;
    }

    public FSInfo produceFSInfo(String user, FsPath fsPath) {
        try {
            FileSystem fs = (FileSystem)FSFactory$.MODULE$.getFsByProxyUser(fsPath, user);
            fs.init(null);
            return new FSInfo(user, fs, System.currentTimeMillis());
        }
        catch (Exception exception) {
            this.logger().error("Requesting IO-Engine to initialize fileSystem failed", (Throwable)exception);
            throw WorkspaceExceptionManager.createException(80001, new Object[0]);
        }
    }

    public FsService() {
        Logging.class.$init$((Logging)this);
    }
}

