/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.filesystem.restful.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.math3.util.Pair;
import org.apache.http.Consts;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.FsWriter;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.filesystem.conf.WorkSpaceConfiguration;
import org.apache.linkis.filesystem.entity.DirFileTree;
import org.apache.linkis.filesystem.entity.LogLevel;
import org.apache.linkis.filesystem.exception.WorkSpaceException;
import org.apache.linkis.filesystem.exception.WorkspaceExceptionManager;
import org.apache.linkis.filesystem.service.FsService;
import org.apache.linkis.filesystem.util.WorkspaceUtil;
import org.apache.linkis.filesystem.validator.PathValidator$;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.apache.linkis.storage.csv.CSVFsWriter;
import org.apache.linkis.storage.domain.FsPathListWithError;
import org.apache.linkis.storage.excel.ExcelFsWriter;
import org.apache.linkis.storage.excel.ExcelStorageReader;
import org.apache.linkis.storage.excel.StorageMultiExcelWriter;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.script.ScriptFsWriter;
import org.apache.linkis.storage.script.ScriptMetaData;
import org.apache.linkis.storage.script.ScriptRecord;
import org.apache.linkis.storage.script.Variable;
import org.apache.linkis.storage.script.VariableParser;
import org.apache.linkis.storage.source.FileSource;
import org.apache.linkis.storage.source.FileSource$;
import org.apache.linkis.storage.utils.StorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"file system"})
@RestController
@RequestMapping(path={"/filesystem"})
public class FsRestfulApi {
    @Autowired
    private FsService fsService;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    private boolean checkIsUsersDirectory(String requestPath, String userName) {
        boolean ownerCheck = (Boolean)WorkSpaceConfiguration.FILESYSTEM_PATH_CHECK_OWNER.getValue();
        if (!ownerCheck) {
            this.LOGGER.debug("not check filesystem owner.");
            return true;
        }
        requestPath = requestPath.toLowerCase().trim() + "/";
        String hdfsUserRootPathPrefix = WorkspaceUtil.suffixTuning((String)WorkSpaceConfiguration.HDFS_USER_ROOT_PATH_PREFIX.getValue());
        String hdfsUserRootPathSuffix = (String)WorkSpaceConfiguration.HDFS_USER_ROOT_PATH_SUFFIX.getValue();
        String localUserRootPath = WorkspaceUtil.suffixTuning((String)WorkSpaceConfiguration.LOCAL_USER_ROOT_PATH.getValue());
        String workspacePath = hdfsUserRootPathPrefix + userName + hdfsUserRootPathSuffix;
        String enginconnPath = localUserRootPath + userName;
        if (WorkspaceUtil.isLogAdmin(userName)) {
            workspacePath = hdfsUserRootPathPrefix;
            enginconnPath = localUserRootPath;
        }
        this.LOGGER.debug("requestPath:" + requestPath);
        this.LOGGER.debug("workspacePath:" + workspacePath);
        this.LOGGER.debug("enginconnPath:" + enginconnPath);
        this.LOGGER.debug("adminUser:" + (String)WorkSpaceConfiguration.FILESYSTEM_LOG_ADMIN.getValue());
        return requestPath.contains(workspacePath) || requestPath.contains(enginconnPath);
    }

    @ApiOperation(value="getUserRootPath", notes="get user root path", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="pathType", required=false, dataType="String", value="path type")})
    @RequestMapping(path={"/getUserRootPath"}, method={RequestMethod.GET})
    public Message getUserRootPath(HttpServletRequest req, @RequestParam(value="pathType", required=false) String pathType) throws IOException, WorkSpaceException {
        String returnType;
        String path;
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"getUserRootPath");
        String hdfsUserRootPathPrefix = WorkspaceUtil.suffixTuning((String)WorkSpaceConfiguration.HDFS_USER_ROOT_PATH_PREFIX.getValue());
        String hdfsUserRootPathSuffix = (String)WorkSpaceConfiguration.HDFS_USER_ROOT_PATH_SUFFIX.getValue();
        String localUserRootPath = WorkspaceUtil.suffixTuning((String)WorkSpaceConfiguration.LOCAL_USER_ROOT_PATH.getValue());
        if (StorageUtils.HDFS().equalsIgnoreCase(pathType)) {
            path = hdfsUserRootPathPrefix + userName + hdfsUserRootPathSuffix;
            returnType = StorageUtils.HDFS().toUpperCase();
        } else {
            path = localUserRootPath + userName;
            returnType = "Local";
        }
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath);
        if (!fileSystem.exists(fsPath)) {
            if (((Boolean)WorkSpaceConfiguration.FILESYSTEM_PATH_AUTO_CREATE.getValue()).booleanValue()) {
                try {
                    fileSystem.mkdirs(fsPath);
                    return Message.ok().data(String.format("user%sRootPath", returnType), (Object)path);
                }
                catch (IOException e) {
                    this.LOGGER.error(e.getMessage(), (Throwable)e);
                    throw WorkspaceExceptionManager.createException(80030, new Object[0]);
                }
            }
            throw WorkspaceExceptionManager.createException(80003, new Object[0]);
        }
        return Message.ok().data(String.format("user%sRootPath", returnType), (Object)path);
    }

    @ApiOperation(value="createNewDir", notes="create new dir", response=Message.class)
    @ApiOperationSupport(ignoreParameters={"json"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=true, dataType="String", value="Path")})
    @RequestMapping(path={"/createNewDir"}, method={RequestMethod.POST})
    public Message createNewDir(HttpServletRequest req, @RequestBody JsonNode json) throws IOException, WorkSpaceException {
        String path = json.get("path").textValue();
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("createNewDir " + path));
        if (StringUtils.isEmpty((Object)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        if (!this.checkIsUsersDirectory(path, userName)) {
            throw WorkspaceExceptionManager.createException(80010, path);
        }
        WorkspaceUtil.fileAndDirNameSpecialCharCheck(path);
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath);
        if (fileSystem.exists(fsPath)) {
            throw WorkspaceExceptionManager.createException(80005, new Object[0]);
        }
        fileSystem.mkdirs(fsPath);
        return Message.ok();
    }

    @ApiOperation(value="createNewFile", notes="create new file", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=true, dataType="String", value="Path")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/createNewFile"}, method={RequestMethod.POST})
    public Message createNewFile(HttpServletRequest req, @RequestBody JsonNode json) throws IOException, WorkSpaceException {
        String path = json.get("path").textValue();
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("createNewFile " + path));
        if (StringUtils.isEmpty((Object)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        if (!this.checkIsUsersDirectory(path, userName)) {
            throw WorkspaceExceptionManager.createException(80010, path);
        }
        WorkspaceUtil.fileAndDirNameSpecialCharCheck(path);
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath);
        if (fileSystem.exists(fsPath)) {
            throw WorkspaceExceptionManager.createException(80006, new Object[0]);
        }
        fileSystem.createNewFile(fsPath);
        return Message.ok();
    }

    @ApiOperation(value="rename", notes="rename", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="oldDest", required=true, dataType="String", value="old dest"), @ApiImplicitParam(name="newDest", required=true, dataType="String", value="new dest")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/rename"}, method={RequestMethod.POST})
    public Message rename(HttpServletRequest req, @RequestBody JsonNode json) throws IOException, WorkSpaceException {
        String oldDest = json.get("oldDest").textValue();
        String newDest = json.get("newDest").textValue();
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("rename " + newDest));
        if (((Boolean)WorkSpaceConfiguration.FILESYSTEM_PATH_CHECK_TRIGGER.getValue()).booleanValue()) {
            this.LOGGER.info(String.format("path check trigger is open,now check the path,oldDest:%s,newDest:%s", oldDest, newDest));
            PathValidator$.MODULE$.validate(oldDest, userName);
            PathValidator$.MODULE$.validate(newDest, userName);
        }
        if (!this.checkIsUsersDirectory(newDest, userName)) {
            throw WorkspaceExceptionManager.createException(80010, newDest);
        }
        if (StringUtils.isEmpty((Object)oldDest)) {
            throw WorkspaceExceptionManager.createException(80004, oldDest);
        }
        if (StringUtils.isEmpty((Object)newDest)) {
            return Message.ok();
        }
        WorkspaceUtil.fileAndDirNameSpecialCharCheck(newDest);
        FsPath fsPathOld = new FsPath(oldDest);
        FsPath fsPathNew = new FsPath(newDest);
        FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPathOld);
        if (fileSystem.exists(fsPathNew)) {
            throw WorkspaceExceptionManager.createException(80007, new Object[0]);
        }
        fileSystem.renameTo(fsPathOld, fsPathNew);
        return Message.ok();
    }

    @ApiOperation(value="move", notes="move", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="filePath", required=true, dataType="String", value="file path"), @ApiImplicitParam(name="newDest", required=true, dataType="String", value="new dest")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/move"}, method={RequestMethod.POST})
    public Message move(HttpServletRequest req, @RequestBody JsonNode json) throws IOException, WorkSpaceException {
        String filePath = json.get("filePath").textValue();
        String newDir = json.get("newDir").textValue();
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("move " + filePath));
        if (StringUtils.isEmpty((Object)filePath)) {
            return Message.ok();
        }
        if (StringUtils.isEmpty((Object)newDir)) {
            throw WorkspaceExceptionManager.createException(80004, newDir);
        }
        if (((Boolean)WorkSpaceConfiguration.FILESYSTEM_PATH_CHECK_TRIGGER.getValue()).booleanValue()) {
            this.LOGGER.info(String.format("path check trigger is open,now check the path,oldDest:%s,newDest:%s", filePath, newDir));
            PathValidator$.MODULE$.validate(filePath, userName);
            PathValidator$.MODULE$.validate(newDir, userName);
        }
        if (!this.checkIsUsersDirectory(filePath, userName)) {
            throw WorkspaceExceptionManager.createException(80010, filePath);
        }
        FsPath flieOldPath = new FsPath(filePath);
        String name = flieOldPath.getPath().substring(flieOldPath.getPath().lastIndexOf("/") + 1);
        FsPath flieNewPath = new FsPath(newDir + "/" + name);
        FileSystem fileSystem = this.fsService.getFileSystem(userName, flieOldPath);
        WorkspaceUtil.fileAndDirNameSpecialCharCheck(flieOldPath.getPath());
        WorkspaceUtil.fileAndDirNameSpecialCharCheck(flieNewPath.getPath());
        if (!fileSystem.exists(flieOldPath)) {
            throw WorkspaceExceptionManager.createException(80013, new Object[0]);
        }
        fileSystem.renameTo(flieOldPath, flieNewPath);
        return Message.ok();
    }

    @ApiOperation(value="upload", notes="upload", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=true, dataType="String", value="path"), @ApiImplicitParam(name="file", required=true, dataType="List<MultipartFile> ", value="file")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/upload"}, method={RequestMethod.POST})
    public Message upload(HttpServletRequest req, @RequestParam(value="path") String path, @RequestParam(value="file") List<MultipartFile> files) throws IOException, WorkSpaceException {
        if (StringUtils.isEmpty((Object)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("upload " + path));
        if (!this.checkIsUsersDirectory(path, userName)) {
            throw WorkspaceExceptionManager.createException(80010, path);
        }
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath);
        for (MultipartFile p : files) {
            String fileName = p.getOriginalFilename();
            FsPath fsPathNew = new FsPath(fsPath.getPath() + "/" + fileName);
            WorkspaceUtil.fileAndDirNameSpecialCharCheck(fsPathNew.getPath());
            fileSystem.createNewFile(fsPathNew);
            InputStream is = p.getInputStream();
            Throwable throwable = null;
            try {
                OutputStream outputStream = fileSystem.write(fsPathNew, true);
                Throwable throwable2 = null;
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)outputStream);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (outputStream == null) continue;
                    if (throwable2 != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    outputStream.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                is.close();
            }
        }
        return Message.ok();
    }

    @ApiOperation(value="deleteDirOrFile", notes="delete dir or file", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=true, dataType="String", value="path")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/deleteDirOrFile"}, method={RequestMethod.POST})
    public Message deleteDirOrFile(HttpServletRequest req, @RequestBody JsonNode json) throws IOException, WorkSpaceException {
        String path = json.get("path").textValue();
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("deleteDirOrFile " + path));
        if (StringUtils.isEmpty((Object)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        if (!this.checkIsUsersDirectory(path, userName)) {
            throw WorkspaceExceptionManager.createException(80010, path);
        }
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath);
        if (!fileSystem.exists(fsPath)) {
            throw WorkspaceExceptionManager.createException(80008, new Object[0]);
        }
        if (!fileSystem.canWrite(fsPath.getParent()) || !fileSystem.canExecute(fsPath.getParent())) {
            throw WorkspaceExceptionManager.createException(80009, new Object[0]);
        }
        FsRestfulApi.deleteAllFiles(fileSystem, fsPath);
        return Message.ok();
    }

    @ApiOperation(value="getDirFileTrees", notes="get dir file trees", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=false, dataType="String", value="path")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/getDirFileTrees"}, method={RequestMethod.GET})
    public Message getDirFileTrees(HttpServletRequest req, @RequestParam(value="path", required=false) String path) throws IOException, WorkSpaceException {
        if (StringUtils.isEmpty((Object)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("getDirFileTrees " + path));
        if (!this.checkIsUsersDirectory(path, userName)) {
            throw WorkspaceExceptionManager.createException(80010, path);
        }
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath);
        if (!fileSystem.exists(fsPath)) {
            return Message.ok().data("dirFileTrees", null);
        }
        DirFileTree dirFileTree = new DirFileTree();
        dirFileTree.setPath(fsPath.getSchemaPath());
        if (!fileSystem.canExecute(fsPath) || !fileSystem.canRead(fsPath)) {
            throw WorkspaceExceptionManager.createException(80010, new Object[0]);
        }
        dirFileTree.setName(new File(path).getName());
        dirFileTree.setChildren(new ArrayList<DirFileTree>());
        FsPathListWithError fsPathListWithError = fileSystem.listPathWithError(fsPath);
        if (fsPathListWithError != null) {
            for (FsPath children : fsPathListWithError.getFsPaths()) {
                DirFileTree dirFileTreeChildren = new DirFileTree();
                dirFileTreeChildren.setName(new File(children.getPath()).getName());
                dirFileTreeChildren.setPath(fsPath.getFsType() + "://" + children.getPath());
                dirFileTreeChildren.setProperties(new HashMap<String, String>());
                dirFileTreeChildren.setParentPath(fsPath.getSchemaPath());
                if (!children.isdir()) {
                    dirFileTreeChildren.setIsLeaf(true);
                    dirFileTreeChildren.getProperties().put("size", String.valueOf(children.getLength()));
                    dirFileTreeChildren.getProperties().put("modifytime", String.valueOf(children.getModification_time()));
                }
                dirFileTree.getChildren().add(dirFileTreeChildren);
            }
        }
        return Message.ok().data("dirFileTrees", (Object)dirFileTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="download", notes="download", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=true, dataType="String", value="path"), @ApiImplicitParam(name="charset", required=true, dataType="String", value="charset")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/download"}, method={RequestMethod.POST})
    public void download(HttpServletRequest req, HttpServletResponse response, @RequestBody Map<String, String> json) throws IOException, WorkSpaceException {
        PrintWriter writer;
        ServletOutputStream outputStream;
        InputStream inputStream;
        block10: {
            inputStream = null;
            outputStream = null;
            writer = null;
            try {
                String charset = json.get("charset");
                String path = json.get("path");
                String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("download " + path));
                if (StringUtils.isEmpty((Object)path)) {
                    throw WorkspaceExceptionManager.createException(80004, path);
                }
                if (StringUtils.isEmpty((Object)charset)) {
                    charset = Consts.UTF_8.toString();
                }
                if (!this.checkIsUsersDirectory(path, userName)) {
                    throw WorkspaceExceptionManager.createException(80010, path);
                }
                FsPath fsPath = new FsPath(path);
                FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath);
                if (!fileSystem.exists(fsPath)) {
                    throw WorkspaceExceptionManager.createException(8011, new Object[0]);
                }
                inputStream = fileSystem.read(fsPath);
                byte[] buffer = new byte[1024];
                int bytesRead = 0;
                response.setCharacterEncoding(charset);
                Path source = Paths.get(fsPath.getPath(), new String[0]);
                response.addHeader("Content-Type", Files.probeContentType(source));
                response.addHeader("Content-Disposition", "attachment;filename=" + new File(path).getName());
                outputStream = response.getOutputStream();
                while ((bytesRead = inputStream.read(buffer, 0, 1024)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                if (outputStream == null) break block10;
            }
            catch (Exception e) {
                block11: {
                    try {
                        this.LOGGER.error("download failed", (Throwable)e);
                        response.reset();
                        response.setCharacterEncoding(Consts.UTF_8.toString());
                        response.setContentType("text/plain; charset=utf-8");
                        writer = response.getWriter();
                        writer.append("error(\u9519\u8bef):" + e.getMessage());
                        writer.flush();
                        if (outputStream == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (outputStream != null) {
                            outputStream.flush();
                        }
                        IOUtils.closeQuietly(outputStream);
                        IOUtils.closeQuietly(inputStream);
                        IOUtils.closeQuietly(writer);
                        throw throwable;
                    }
                    outputStream.flush();
                }
                IOUtils.closeQuietly(outputStream);
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly((Writer)writer);
            }
            outputStream.flush();
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((Writer)writer);
    }

    @ApiOperation(value="isExist", notes="is exist", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=false, dataType="String", value="path")})
    @RequestMapping(path={"/isExist"}, method={RequestMethod.GET})
    public Message isExist(HttpServletRequest req, @RequestParam(value="path", required=false) String path) throws IOException, WorkSpaceException {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("isExist " + path));
        FsPath fsPath = new FsPath(path);
        if (StringUtils.isEmpty((Object)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        if (!this.checkIsUsersDirectory(path, userName)) {
            throw WorkspaceExceptionManager.createException(80010, path);
        }
        FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath);
        return Message.ok().data("isExist", (Object)fileSystem.exists(fsPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="FileInfo", notes="File_Info", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=false, dataType="String", value="Path"), @ApiImplicitParam(name="pageSize", required=true, dataType="Integer", value="page size", defaultValue="5000")})
    @RequestMapping(path={"/fileInfo"}, method={RequestMethod.GET})
    public Message fileInfo(HttpServletRequest req, @RequestParam(value="path", required=false) String path, @RequestParam(value="pageSize", defaultValue="5000") Integer pageSize) throws IOException, WorkSpaceException {
        Message message;
        FsPath fsPath;
        if (StringUtils.isEmpty((Object)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("fileInfo " + path));
        FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath = new FsPath(path));
        if (!fileSystem.canRead(fsPath)) {
            throw WorkspaceExceptionManager.createException(80012, new Object[0]);
        }
        FileSource fileSource = null;
        try {
            Message message2 = Message.ok();
            fileSource = FileSource$.MODULE$.create(fsPath, (Fs)fileSystem);
            Pair[] fileInfo = fileSource.getFileInfo(pageSize.intValue());
            IOUtils.closeQuietly((Closeable)fileSource);
            if (null != fileInfo && fileInfo.length > 0) {
                message2.data("path", (Object)path);
                message2.data("colNumber", fileInfo[0].getFirst());
                message2.data("rowNumber", fileInfo[0].getSecond());
            } else {
                message2.data("path", (Object)path);
                message2.data("colNumber", (Object)0);
                message2.data("rowNumber", (Object)0);
            }
            message = message2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileSource);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fileSource);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="openFile", notes="open file", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=false, dataType="String", value="Path"), @ApiImplicitParam(name="page", required=true, dataType="Integer", value="page", defaultValue="1"), @ApiImplicitParam(name="pageSize", required=true, dataType="Integer", value="page size", defaultValue="5000"), @ApiImplicitParam(name="charset", required=true, dataType="String", value="charset", defaultValue="utf-8")})
    @RequestMapping(path={"/openFile"}, method={RequestMethod.GET})
    public Message openFile(HttpServletRequest req, @RequestParam(value="path", required=false) String path, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="pageSize", defaultValue="5000") Integer pageSize, @RequestParam(value="charset", defaultValue="utf-8") String charset) throws IOException, WorkSpaceException {
        Message message;
        Message message2 = Message.ok();
        if (StringUtils.isEmpty((Object)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("openFile " + path));
        if (!this.checkIsUsersDirectory(path, userName)) {
            throw WorkspaceExceptionManager.createException(80010, path);
        }
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath);
        if (!fileSystem.canRead(fsPath)) {
            throw WorkspaceExceptionManager.createException(80012, new Object[0]);
        }
        FileSource fileSource = null;
        try {
            fileSource = FileSource$.MODULE$.create(fsPath, (Fs)fileSystem);
            if (FileSource$.MODULE$.isResultSet(fsPath.getPath())) {
                fileSource = fileSource.page(page.intValue(), pageSize.intValue());
            }
            Pair result = fileSource.collect()[0];
            IOUtils.closeQuietly((Closeable)fileSource);
            message2.data("metadata", result.getFirst()).data("fileContent", result.getSecond());
            message2.data("type", (Object)fileSource.getFileSplits()[0].type());
            message2.data("totalLine", (Object)fileSource.getTotalLine());
            message = message2.data("page", (Object)page).data("totalPage", (Object)0);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileSource);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fileSource);
        return message;
    }

    @ApiOperation(value="saveScript", notes="save script", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=true, dataType="String", value="path"), @ApiImplicitParam(name="scriptContent", required=false, dataType="String", value="script content"), @ApiImplicitParam(name="params", required=false, dataType="Object", value="params"), @ApiImplicitParam(name="charset", required=false, dataType="String", value="charset")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/saveScript"}, method={RequestMethod.POST})
    public Message saveScript(HttpServletRequest req, @RequestBody Map<String, Object> json) throws IOException, WorkSpaceException {
        String path = (String)json.get("path");
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("saveScript " + path));
        if (StringUtils.isEmpty((Object)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        String charset = (String)json.get("charset");
        if (StringUtils.isEmpty((Object)charset)) {
            charset = Consts.UTF_8.toString();
        }
        if (!this.checkIsUsersDirectory(path, userName)) {
            throw WorkspaceExceptionManager.createException(80010, path);
        }
        String scriptContent = (String)json.get("scriptContent");
        Object params = json.get("params");
        Map map = (Map)params;
        Variable[] v = VariableParser.getVariables((Map)map);
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath);
        if (!fileSystem.exists(fsPath)) {
            throw WorkspaceExceptionManager.createException(80013, new Object[0]);
        }
        if (!fileSystem.canWrite(fsPath)) {
            throw WorkspaceExceptionManager.createException(80014, new Object[0]);
        }
        try (ScriptFsWriter scriptFsWriter = ScriptFsWriter.getScriptFsWriter((FsPath)fsPath, (String)charset, (OutputStream)fileSystem.write(fsPath, true));){
            scriptFsWriter.addMetaData((MetaData)new ScriptMetaData(v));
            String[] split = scriptContent.split("\\n");
            for (int i = 0; i < split.length; ++i) {
                if ("".equals(split[i]) || i != split.length - 1) {
                    int n = i;
                    split[n] = split[n] + "\n";
                }
                scriptFsWriter.addRecord((Record)new ScriptRecord(split[i]));
            }
            Message message = Message.ok();
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="resultsetToExcel", notes="resultset to excel", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=false, dataType="String", value="path"), @ApiImplicitParam(name="charset", required=true, dataType="String", value="charset", defaultValue="utf-8"), @ApiImplicitParam(name="outputFileType", required=true, dataType="String", value="output file type", defaultValue="csv"), @ApiImplicitParam(name="csvSeperator", required=true, dataType="String", value="csv seperator", defaultValue=","), @ApiImplicitParam(name="quoteRetouchEnable", dataType="boolean", required=false, value="quote retouch enable"), @ApiImplicitParam(name="outputFileName", required=true, dataType="String", value="output file name", defaultValue="downloadResultset"), @ApiImplicitParam(name="sheetName", required=true, dataType="String", value="sheet name", defaultValue="result"), @ApiImplicitParam(name="nullValue", required=true, dataType="String", value="null value", defaultValue="NULL"), @ApiImplicitParam(name="limit", required=true, dataType="Integer", value="limit", defaultValue="0"), @ApiImplicitParam(name="autoFormat", required=false, dataType="Boolean", value="auto format")})
    @RequestMapping(path={"resultsetToExcel"}, method={RequestMethod.GET})
    public void resultsetToExcel(HttpServletRequest req, HttpServletResponse response, @RequestParam(value="path", required=false) String path, @RequestParam(value="charset", defaultValue="utf-8") String charset, @RequestParam(value="outputFileType", defaultValue="csv") String outputFileType, @RequestParam(value="csvSeperator", defaultValue=",") String csvSeperator, @RequestParam(value="quoteRetouchEnable", required=false) boolean quoteRetouchEnable, @RequestParam(value="outputFileName", defaultValue="downloadResultset") String outputFileName, @RequestParam(value="sheetName", defaultValue="result") String sheetName, @RequestParam(value="nullValue", defaultValue="NULL") String nullValue, @RequestParam(value="limit", defaultValue="0") Integer limit, @RequestParam(value="autoFormat", defaultValue="false") Boolean autoFormat) throws WorkSpaceException, IOException {
        FileSource fileSource;
        PrintWriter writer;
        Object fsWriter;
        block18: {
            ServletOutputStream outputStream = null;
            fsWriter = null;
            writer = null;
            fileSource = null;
            try {
                String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("resultsetToExcel " + path));
                FsPath fsPath = new FsPath(path);
                FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath);
                boolean isLimitDownloadSize = (Boolean)WorkSpaceConfiguration.RESULT_SET_DOWNLOAD_IS_LIMIT.getValue();
                Integer csvDownloadSize = (Integer)WorkSpaceConfiguration.RESULT_SET_DOWNLOAD_MAX_SIZE_CSV.getValue();
                Integer excelDownloadSize = (Integer)WorkSpaceConfiguration.RESULT_SET_DOWNLOAD_MAX_SIZE_EXCEL.getValue();
                if (limit > 0) {
                    csvDownloadSize = limit;
                    excelDownloadSize = limit;
                }
                if (StringUtils.isEmpty((Object)path)) {
                    throw WorkspaceExceptionManager.createException(80004, path);
                }
                if (!this.checkIsUsersDirectory(path, userName)) {
                    throw WorkspaceExceptionManager.createException(80010, path);
                }
                response.addHeader("Content-Disposition", "attachment;filename=" + new String(outputFileName.getBytes("UTF-8"), "ISO8859-1") + "." + outputFileType);
                response.setCharacterEncoding(charset);
                outputStream = response.getOutputStream();
                if (nullValue != null && "BLANK".equalsIgnoreCase(nullValue)) {
                    nullValue = "";
                }
                fileSource = FileSource$.MODULE$.create(fsPath, (Fs)fileSystem).addParams("nullValue", nullValue);
                switch (outputFileType) {
                    case "csv": {
                        fsWriter = FileSource$.MODULE$.isTableResultSet(fileSource) ? CSVFsWriter.getCSVFSWriter((String)charset, (String)csvSeperator, (boolean)quoteRetouchEnable, (OutputStream)outputStream) : ScriptFsWriter.getScriptFsWriter((FsPath)new FsPath(outputFileType), (String)charset, (OutputStream)outputStream);
                        response.addHeader("Content-Type", "text/plain");
                        if (!isLimitDownloadSize) break;
                        fileSource = fileSource.page(1, csvDownloadSize.intValue());
                        break;
                    }
                    case "xlsx": {
                        if (!FileSource$.MODULE$.isTableResultSet(fileSource)) {
                            throw WorkspaceExceptionManager.createException(80024, new Object[0]);
                        }
                        fsWriter = ExcelFsWriter.getExcelFsWriter((String)charset, (String)sheetName, (String)"yyyy-MM-dd HH:mm:ss", (OutputStream)outputStream, (boolean)autoFormat);
                        response.addHeader("Content-Type", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                        if (!isLimitDownloadSize) break;
                        fileSource = fileSource.page(1, excelDownloadSize.intValue());
                        break;
                    }
                    default: {
                        WorkspaceExceptionManager.createException(80015, new Object[0]);
                    }
                }
                fileSource.write(fsWriter);
                fsWriter.flush();
                if (outputStream == null) break block18;
            }
            catch (Exception e) {
                block19: {
                    try {
                        this.LOGGER.error("output failed", (Throwable)e);
                        response.reset();
                        response.setCharacterEncoding(Consts.UTF_8.toString());
                        response.setContentType("text/plain; charset=utf-8");
                        writer = response.getWriter();
                        writer.append("error(\u9519\u8bef):" + e.getMessage());
                        writer.flush();
                        if (outputStream == null) break block19;
                    }
                    catch (Throwable throwable) {
                        if (outputStream != null) {
                            outputStream.flush();
                        }
                        IOUtils.closeQuietly(fsWriter);
                        IOUtils.closeQuietly(fileSource);
                        IOUtils.closeQuietly(writer);
                        throw throwable;
                    }
                    outputStream.flush();
                }
                IOUtils.closeQuietly(fsWriter);
                IOUtils.closeQuietly(fileSource);
                IOUtils.closeQuietly((Writer)writer);
            }
            outputStream.flush();
        }
        IOUtils.closeQuietly((Closeable)fsWriter);
        IOUtils.closeQuietly((Closeable)fileSource);
        IOUtils.closeQuietly((Writer)writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="resultsetToExcel", notes="resultset to excel", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=false, dataType="String", value="path"), @ApiImplicitParam(name="outputFileName", required=true, dataType="String", value="output file name", defaultValue="downloadResultset"), @ApiImplicitParam(name="nullValue", required=true, dataType="String", value="null value", defaultValue="NULL"), @ApiImplicitParam(name="limit", required=true, dataType="Integer", value="limit", defaultValue="0"), @ApiImplicitParam(name="autoFormat", required=false, dataType="Boolean", value="auto format")})
    @RequestMapping(path={"resultsetsToExcel"}, method={RequestMethod.GET})
    public void resultsetsToExcel(HttpServletRequest req, HttpServletResponse response, @RequestParam(value="path", required=false) String path, @RequestParam(value="outputFileName", defaultValue="downloadResultset") String outputFileName, @RequestParam(value="nullValue", defaultValue="NULL") String nullValue, @RequestParam(value="limit", defaultValue="0") Integer limit, @RequestParam(value="autoFormat", defaultValue="false") Boolean autoFormat) throws WorkSpaceException, IOException {
        FileSource fileSource;
        PrintWriter writer;
        StorageMultiExcelWriter fsWriter;
        block12: {
            ServletOutputStream outputStream = null;
            fsWriter = null;
            writer = null;
            fileSource = null;
            try {
                String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("resultsetsToExcel " + path));
                FsPath fsPath = new FsPath(path);
                FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath);
                if (StringUtils.isEmpty((Object)path)) {
                    throw WorkspaceExceptionManager.createException(80004, path);
                }
                if (!this.checkIsUsersDirectory(path, userName)) {
                    throw WorkspaceExceptionManager.createException(80010, path);
                }
                FsPathListWithError fsPathListWithError = fileSystem.listPathWithError(fsPath);
                if (fsPathListWithError == null) {
                    throw WorkspaceExceptionManager.createException(80029, new Object[0]);
                }
                FsPath[] fsPaths = fsPathListWithError.getFsPaths().toArray(new FsPath[0]);
                boolean isLimitDownloadSize = (Boolean)WorkSpaceConfiguration.RESULT_SET_DOWNLOAD_IS_LIMIT.getValue();
                Integer excelDownloadSize = (Integer)WorkSpaceConfiguration.RESULT_SET_DOWNLOAD_MAX_SIZE_EXCEL.getValue();
                if (limit > 0) {
                    excelDownloadSize = limit;
                }
                response.addHeader("Content-Disposition", "attachment;filename=" + new String(outputFileName.getBytes(StandardCharsets.UTF_8), "ISO8859-1") + ".xlsx");
                response.setCharacterEncoding(StandardCharsets.UTF_8.name());
                outputStream = response.getOutputStream();
                if (nullValue != null && "BLANK".equalsIgnoreCase(nullValue)) {
                    nullValue = "";
                }
                if (!FileSource$.MODULE$.isTableResultSet(fileSource = FileSource$.MODULE$.create(fsPaths, (Fs)fileSystem).addParams("nullValue", nullValue))) {
                    throw WorkspaceExceptionManager.createException(80024, new Object[0]);
                }
                fsWriter = new StorageMultiExcelWriter((OutputStream)outputStream, autoFormat.booleanValue());
                response.addHeader("Content-Type", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                if (isLimitDownloadSize) {
                    fileSource = fileSource.page(1, excelDownloadSize.intValue());
                }
                fileSource.write((FsWriter)fsWriter);
                fsWriter.flush();
                if (outputStream == null) break block12;
            }
            catch (Exception e) {
                block13: {
                    try {
                        this.LOGGER.error("output failed", (Throwable)e);
                        response.reset();
                        response.setCharacterEncoding(Consts.UTF_8.toString());
                        response.setContentType("text/plain; charset=utf-8");
                        writer = response.getWriter();
                        writer.append("error(\u9519\u8bef):" + e.getMessage());
                        writer.flush();
                        if (outputStream == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (outputStream != null) {
                            outputStream.flush();
                        }
                        IOUtils.closeQuietly(fsWriter);
                        IOUtils.closeQuietly(fileSource);
                        IOUtils.closeQuietly(writer);
                        throw throwable;
                    }
                    outputStream.flush();
                }
                IOUtils.closeQuietly(fsWriter);
                IOUtils.closeQuietly(fileSource);
                IOUtils.closeQuietly((Writer)writer);
            }
            outputStream.flush();
        }
        IOUtils.closeQuietly((Closeable)fsWriter);
        IOUtils.closeQuietly((Closeable)fileSource);
        IOUtils.closeQuietly((Writer)writer);
    }

    @ApiOperation(value="formate", notes="formate", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=false, dataType="String", value="Path"), @ApiImplicitParam(name="encoding", required=true, dataType="String", value="encoding", defaultValue="utf-8"), @ApiImplicitParam(name="fieldDelimiter", required=true, dataType="String", value="field delimiter", defaultValue=","), @ApiImplicitParam(name="hasHeader", required=true, defaultValue="false", value="has header", dataType="Boolean"), @ApiImplicitParam(name="quote", required=true, dataType="String", value="quote", defaultValue="\""), @ApiImplicitParam(name="escapeQuotes", required=true, dataType="Boolean", value="escape quotes", defaultValue="false")})
    @RequestMapping(path={"formate"}, method={RequestMethod.GET})
    public Message formate(HttpServletRequest req, @RequestParam(value="path", required=false) String path, @RequestParam(value="encoding", defaultValue="utf-8") String encoding, @RequestParam(value="fieldDelimiter", defaultValue=",") String fieldDelimiter, @RequestParam(value="hasHeader", defaultValue="false") Boolean hasHeader, @RequestParam(value="quote", defaultValue="\"") String quote, @RequestParam(value="escapeQuotes", defaultValue="false") Boolean escapeQuotes) throws Exception {
        if (StringUtils.isEmpty((Object)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("formate " + path));
        if (!this.checkIsUsersDirectory(path, userName)) {
            throw WorkspaceExceptionManager.createException(80010, path);
        }
        String suffix = path.substring(path.lastIndexOf("."));
        FsPath fsPath = new FsPath(path);
        HashMap<String, Object> res = new HashMap<String, Object>();
        FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath);
        try (InputStream in = fileSystem.read(fsPath);){
            if (".xlsx".equalsIgnoreCase(suffix) || ".xls".equalsIgnoreCase(suffix)) {
                List info = ExcelStorageReader.getExcelTitle((InputStream)in, null, (Boolean)hasHeader, (String)suffix);
                res.put("columnName", info.get(1));
                res.put("columnType", info.get(2));
                res.put("sheetName", info.get(0));
            } else {
                String[][] column = null;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, encoding));
                String header = reader.readLine();
                if (StringUtils.isEmpty((Object)header)) {
                    throw WorkspaceExceptionManager.createException(80016, new Object[0]);
                }
                String[] line = header.split(fieldDelimiter, -1);
                int colNum = line.length;
                column = new String[2][colNum];
                if (hasHeader.booleanValue()) {
                    for (int i = 0; i < colNum; ++i) {
                        column[0][i] = line[i];
                        if (escapeQuotes.booleanValue()) {
                            try {
                                column[0][i] = column[0][i].substring(1, column[0][i].length() - 1);
                            }
                            catch (StringIndexOutOfBoundsException e) {
                                throw WorkspaceExceptionManager.createException(80017, new Object[0]);
                            }
                        }
                        column[1][i] = "string";
                    }
                } else {
                    for (int i = 0; i < colNum; ++i) {
                        column[0][i] = "col_" + (i + 1);
                        column[1][i] = "string";
                    }
                }
                res.put("columnName", column[0]);
                res.put("columnType", column[1]);
            }
            Message message = Message.ok().data("formate", res);
            return message;
        }
    }

    @ApiOperation(value="openLog", notes="open log", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", required=false, dataType="String", value="path"), @ApiImplicitParam(name="proxyUser", required=false, dataType="String", value="proxy user")})
    @RequestMapping(path={"/openLog"}, method={RequestMethod.GET})
    public Message openLog(HttpServletRequest req, @RequestParam(value="path", required=false) String path, @RequestParam(value="proxyUser", required=false) String proxyUser) throws IOException, WorkSpaceException {
        if (StringUtils.isEmpty((Object)path)) {
            throw WorkspaceExceptionManager.createException(80004, path);
        }
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("openLog " + path));
        if (proxyUser != null && WorkspaceUtil.isLogAdmin(userName)) {
            userName = proxyUser;
        }
        if (!this.checkIsUsersDirectory(path, userName)) {
            throw WorkspaceExceptionManager.createException(80010, path);
        }
        FsPath fsPath = new FsPath(path);
        FileSystem fileSystem = this.fsService.getFileSystem(userName, fsPath);
        if (!fileSystem.canRead(fsPath)) {
            throw WorkspaceExceptionManager.createException(80018, new Object[0]);
        }
        try (FileSource fileSource = FileSource$.MODULE$.create(fsPath, (Fs)fileSystem).addParams("ifMerge", "false");){
            Pair collect = fileSource.collect()[0];
            StringBuilder[] log = (StringBuilder[])Arrays.stream(new StringBuilder[4]).map(f -> new StringBuilder()).toArray(StringBuilder[]::new);
            ArrayList snd = (ArrayList)collect.getSecond();
            LogLevel start = new LogLevel(LogLevel.Type.ALL);
            snd.stream().map(f -> f[0]).forEach(s -> WorkspaceUtil.logMatch(s, start).forEach(i -> log[i].append((String)s).append("\n")));
            Message message = Message.ok().data("log", Arrays.stream(log).map(StringBuilder::toString).toArray(String[]::new));
            return message;
        }
    }

    private static void deleteAllFiles(FileSystem fileSystem, FsPath fsPath) throws IOException {
        fileSystem.delete(fsPath);
        List list = null;
        if (fileSystem.exists(fsPath)) {
            list = fileSystem.list(fsPath);
        }
        if (list == null) {
            return;
        }
        for (FsPath path : list) {
            FsRestfulApi.deleteAllFiles(fileSystem, path);
        }
        fileSystem.delete(fsPath);
    }
}

