/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.filesystem.restful.api;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.google.gson.Gson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.math3.util.Pair;
import org.apache.http.Consts;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.MetaData;
import org.apache.linkis.common.io.Record;
import org.apache.linkis.filesystem.bml.BMLHelper;
import org.apache.linkis.filesystem.exception.WorkSpaceException;
import org.apache.linkis.filesystem.exception.WorkspaceExceptionManager;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.apache.linkis.storage.script.ScriptFsWriter;
import org.apache.linkis.storage.script.ScriptMetaData;
import org.apache.linkis.storage.script.ScriptRecord;
import org.apache.linkis.storage.script.Variable;
import org.apache.linkis.storage.script.VariableParser;
import org.apache.linkis.storage.script.writer.StorageScriptFsWriter;
import org.apache.linkis.storage.source.FileSource;
import org.apache.linkis.storage.source.FileSource$;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"BML FS management"})
@RestController
@RequestMapping(path={"/filesystem"})
public class BMLFsRestfulApi {
    @Autowired
    BMLHelper bmlHelper;

    @ApiOperation(value="openScriptFromBML", notes="open script from BML", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceId", required=false, dataType="String", value="resource id"), @ApiImplicitParam(name="version", required=false, dataType="String", value="version"), @ApiImplicitParam(name="creator", required=false, dataType="String", value="creator"), @ApiImplicitParam(name="projectName", required=false, dataType="String", value="project name"), @ApiImplicitParam(name="fileName", required=true, dataType="String", value="file name")})
    @RequestMapping(path={"/openScriptFromBML"}, method={RequestMethod.GET})
    public Message openScriptFromBML(HttpServletRequest req, @RequestParam(value="resourceId", required=false) String resourceId, @RequestParam(value="version", required=false) String version, @RequestParam(value="creator", required=false) String creator, @RequestParam(value="projectName", required=false) String projectName, @RequestParam(value="fileName", defaultValue="test.sql") String fileName) throws IOException, WorkSpaceException {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"openScriptFromBML");
        Map<String, Object> query = this.bmlHelper.query(userName, resourceId, version);
        InputStream inputStream = (InputStream)query.get("stream");
        try (FileSource fileSource = FileSource$.MODULE$.create(new FsPath(fileName), inputStream);){
            Message message;
            Pair collect = fileSource.collect()[0];
            try {
                message = (Message)new Gson().fromJson(((String[])((ArrayList)collect.getSecond()).get(0))[0], Message.class);
                if (message == null) {
                    throw WorkspaceExceptionManager.createException(80019, new Object[0]);
                }
            }
            catch (Exception e) {
                Message message2 = Message.ok().data("scriptContent", (Object)((String[])((ArrayList)collect.getSecond()).get(0))[0]).data("metadata", collect.getFirst());
                if (fileSource != null) {
                    if (var11_11 != null) {
                        try {
                            fileSource.close();
                        }
                        catch (Throwable throwable) {
                            var11_11.addSuppressed(throwable);
                        }
                    } else {
                        fileSource.close();
                    }
                }
                return message2;
            }
            if (message.getStatus() != 0) {
                throw new WorkSpaceException(80020, message.getMessage());
            }
            Message message3 = Message.ok().data("scriptContent", (Object)((String[])((ArrayList)collect.getSecond()).get(0))[0]).data("metadata", collect.getFirst());
            return message3;
        }
    }

    @ApiOperation(value="openScriptFromProductBML", notes="open script from product BML", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceId", required=false, dataType="String", value="resource id"), @ApiImplicitParam(name="version", required=false, dataType="String", value="version"), @ApiImplicitParam(name="creator", required=false, dataType="String", value="creator"), @ApiImplicitParam(name="fileName", required=true, dataType="String", value="file name")})
    @RequestMapping(path={"/product/openScriptFromBML"}, method={RequestMethod.GET})
    public Message openScriptFromProductBML(HttpServletRequest req, @RequestParam(value="resourceId", required=false) String resourceId, @RequestParam(value="version", required=false) String version, @RequestParam(value="creator", required=false) String creator, @RequestParam(value="fileName", defaultValue="test.sql") String fileName) throws IOException, WorkSpaceException {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"openScriptFromBML");
        if (!StringUtils.isEmpty((Object)creator)) {
            userName = creator;
        }
        Map<String, Object> query = this.bmlHelper.query(userName, resourceId, version);
        InputStream inputStream = (InputStream)query.get("stream");
        try (FileSource fileSource = FileSource$.MODULE$.create(new FsPath(fileName), inputStream);){
            Message message;
            Pair collect = fileSource.collect()[0];
            try {
                message = (Message)new Gson().fromJson(((String[])((ArrayList)collect.getSecond()).get(0))[0], Message.class);
                if (message == null) {
                    throw WorkspaceExceptionManager.createException(80019, new Object[0]);
                }
            }
            catch (Exception e) {
                Message message2 = Message.ok().data("scriptContent", (Object)((String[])((ArrayList)collect.getSecond()).get(0))[0]).data("metadata", collect.getFirst());
                if (fileSource != null) {
                    if (var10_10 != null) {
                        try {
                            fileSource.close();
                        }
                        catch (Throwable throwable) {
                            var10_10.addSuppressed(throwable);
                        }
                    } else {
                        fileSource.close();
                    }
                }
                return message2;
            }
            if (message.getStatus() != 0) {
                throw new WorkSpaceException(80020, message.getMessage());
            }
            Message message3 = Message.ok().data("scriptContent", (Object)((String[])((ArrayList)collect.getSecond()).get(0))[0]).data("metadata", collect.getFirst());
            return message3;
        }
    }

    @ApiOperation(value="saveScriptToBML", notes="save script to BML", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="scriptContent", required=true, dataType="String", value="script content"), @ApiImplicitParam(name="resourceId", required=false, dataType="String", value="resource id"), @ApiImplicitParam(name="creator", required=false, dataType="String", value="creator"), @ApiImplicitParam(name="fileName", required=false, dataType="String", value="fileName"), @ApiImplicitParam(name="projectName", required=false, dataType="String", value="project name"), @ApiImplicitParam(name="metadata", required=false, dataType="String", value="metadata")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/saveScriptToBML"}, method={RequestMethod.POST})
    public Message saveScriptToBML(HttpServletRequest req, @RequestBody Map<String, Object> json) throws IOException {
        String scriptContent = (String)json.get("scriptContent");
        Map params = (Map)json.get("metadata");
        String fileName = (String)json.get("fileName");
        String resourceId = (String)json.get("resourceId");
        String creator = (String)json.get("creator");
        String projectName = (String)json.get("projectName");
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("saveScriptToBML" + fileName));
        ScriptFsWriter writer = StorageScriptFsWriter.getScriptFsWriter((FsPath)new FsPath(fileName), (String)Consts.UTF_8.toString(), null);
        Variable[] v = VariableParser.getVariables((Map)params);
        List<Variable> variableList = Arrays.stream(v).filter(var -> !StringUtils.isEmpty((Object)var.value())).collect(Collectors.toList());
        writer.addMetaData((MetaData)new ScriptMetaData(variableList.toArray(new Variable[0])));
        writer.addRecord((Record)new ScriptRecord(scriptContent));
        try (InputStream inputStream = writer.getInputStream();){
            String version;
            Map<Object, Object> bmlResponse;
            if (resourceId == null) {
                bmlResponse = new HashMap();
                bmlResponse = !StringUtils.isEmpty((Object)projectName) ? this.bmlHelper.upload(userName, inputStream, fileName, projectName) : this.bmlHelper.upload(userName, inputStream, fileName);
                resourceId = bmlResponse.get("resourceId").toString();
                version = bmlResponse.get("version").toString();
            } else {
                bmlResponse = this.bmlHelper.update(userName, resourceId, inputStream);
                resourceId = bmlResponse.get("resourceId").toString();
                version = bmlResponse.get("version").toString();
            }
            Message message = Message.ok().data("resourceId", (Object)resourceId).data("version", (Object)version);
            return message;
        }
    }
}

