/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.filesystem.bml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.linkis.bml.client.BmlClient;
import org.apache.linkis.bml.client.BmlClientFactory;
import org.apache.linkis.bml.protocol.BmlDownloadResponse;
import org.apache.linkis.bml.protocol.BmlUpdateResponse;
import org.apache.linkis.bml.protocol.BmlUploadResponse;
import org.apache.linkis.filesystem.exception.WorkspaceExceptionManager;
import org.springframework.stereotype.Component;
import scala.Predef;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u001b\tI!)\u0014'IK2\u0004XM\u001d\u0006\u0003\u0007\u0011\t1AY7m\u0015\t)a!\u0001\u0006gS2,7/_:uK6T!a\u0002\u0005\u0002\r1Lgn[5t\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e\u0001\t\u0003Y\u0012AB;qY>\fG\r\u0006\u0003\u001dcM*\u0004\u0003B\u000f#I-j\u0011A\b\u0006\u0003?\u0001\nA!\u001e;jY*\t\u0011%\u0001\u0003kCZ\f\u0017BA\u0012\u001f\u0005\ri\u0015\r\u001d\t\u0003K!r!a\u0004\u0014\n\u0005\u001d\u0002\u0012A\u0002)sK\u0012,g-\u0003\u0002*U\t11\u000b\u001e:j]\u001eT!a\n\t\u0011\u00051zS\"A\u0017\u000b\u00059\u0002\u0013\u0001\u00027b]\u001eL!\u0001M\u0017\u0003\r=\u0013'.Z2u\u0011\u0015\u0011\u0014\u00041\u0001%\u0003!)8/\u001a:OC6,\u0007\"\u0002\u001b\u001a\u0001\u0004!\u0013aB2p]R,g\u000e\u001e\u0005\u0006me\u0001\r\u0001J\u0001\tM&dWMT1nK\")!\u0004\u0001C\u0001qQ)A$\u000f\u001eC\u0007\")!g\u000ea\u0001I!)1h\u000ea\u0001y\u0005Y\u0011N\u001c9viN#(/Z1n!\ti\u0004)D\u0001?\u0015\ty\u0004%\u0001\u0002j_&\u0011\u0011I\u0010\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u00037o\u0001\u0007A\u0005C\u0003Eo\u0001\u0007A%A\u0006qe>TWm\u0019;OC6,\u0007\"\u0002\u000e\u0001\t\u00031E\u0003\u0002\u000fH\u0011&CQAM#A\u0002\u0011BQaO#A\u0002qBQAN#A\u0002\u0011BQa\u0013\u0001\u0005\u00021\u000ba!\u001e9eCR,G\u0003\u0002\u000fN\u001dBCQA\r&A\u0002\u0011BQa\u0014&A\u0002\u0011\n!B]3t_V\u00148-Z%e\u0011\u0015Y$\n1\u0001=\u0011\u0015Y\u0005\u0001\"\u0001S)\u0011a2\u000bV+\t\u000bI\n\u0006\u0019\u0001\u0013\t\u000b=\u000b\u0006\u0019\u0001\u0013\t\u000bQ\n\u0006\u0019\u0001\u0013\t\u000b]\u0003A\u0011\u0001-\u0002\u000bE,XM]=\u0015\tqI&l\u0017\u0005\u0006eY\u0003\r\u0001\n\u0005\u0006\u001fZ\u0003\r\u0001\n\u0005\u00069Z\u0003\r\u0001J\u0001\bm\u0016\u00148/[8o\u0011\u0015q\u0006\u0001\"\u0003`\u0003IIg\u000e];ugR\u0014X-\u001c+p'R\u0014\u0018N\\4\u0015\u0005\u0011\u0002\u0007\"B\u001e^\u0001\u0004a\u0004\"\u00022\u0001\t\u0013\u0019\u0017aD2sK\u0006$XMQ'M\u00072LWM\u001c;\u0015\u0005\u0011\\\u0007CA3j\u001b\u00051'BA4i\u0003\u0019\u0019G.[3oi*\u00111AB\u0005\u0003U\u001a\u0014\u0011BQ7m\u00072LWM\u001c;\t\u000bI\n\u0007\u0019\u0001\u0013)\u0005\u0001i\u0007C\u00018t\u001b\u0005y'B\u00019r\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0003e*\tqb\u001d9sS:<gM]1nK^|'o[\u0005\u0003i>\u0014\u0011bQ8na>tWM\u001c;")
public class BMLHelper {
    public Map<String, Object> upload(String userName, String content, String fileName) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes("utf-8"));
        BmlClient client = this.createBMLClient(userName);
        BmlUploadResponse resource = client.uploadResource(userName, fileName, (InputStream)inputStream);
        if (resource.isSuccess()) {
            HashMap map = new HashMap();
            JavaConversions$.MODULE$.mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resourceId"), (Object)resource.resourceId()));
            return JavaConversions$.MODULE$.mutableMapAsJavaMap((scala.collection.mutable.Map)JavaConversions$.MODULE$.mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)resource.version())));
        }
        throw WorkspaceExceptionManager.createException(80021, new Object[0]);
    }

    public Map<String, Object> upload(String userName, InputStream inputStream, String fileName, String projectName) {
        BmlClient client = this.createBMLClient(userName);
        BmlUploadResponse resource = client.uploadShareResource(userName, projectName, fileName, inputStream);
        if (resource.isSuccess()) {
            HashMap map = new HashMap();
            JavaConversions$.MODULE$.mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resourceId"), (Object)resource.resourceId()));
            return JavaConversions$.MODULE$.mutableMapAsJavaMap((scala.collection.mutable.Map)JavaConversions$.MODULE$.mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)resource.version())));
        }
        throw WorkspaceExceptionManager.createException(80021, new Object[0]);
    }

    public Map<String, Object> upload(String userName, InputStream inputStream, String fileName) {
        BmlClient client = this.createBMLClient(userName);
        BmlUploadResponse resource = client.uploadResource(userName, fileName, inputStream);
        if (resource.isSuccess()) {
            HashMap map = new HashMap();
            JavaConversions$.MODULE$.mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resourceId"), (Object)resource.resourceId()));
            return JavaConversions$.MODULE$.mutableMapAsJavaMap((scala.collection.mutable.Map)JavaConversions$.MODULE$.mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)resource.version())));
        }
        throw WorkspaceExceptionManager.createException(80021, new Object[0]);
    }

    public Map<String, Object> update(String userName, String resourceId, InputStream inputStream) {
        BmlClient client = this.createBMLClient(userName);
        BmlUpdateResponse resource = client.updateShareResource(userName, resourceId, "", inputStream);
        if (resource.isSuccess()) {
            HashMap map = new HashMap();
            JavaConversions$.MODULE$.mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resourceId"), (Object)resource.resourceId()));
            return JavaConversions$.MODULE$.mutableMapAsJavaMap((scala.collection.mutable.Map)JavaConversions$.MODULE$.mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)resource.version())));
        }
        throw WorkspaceExceptionManager.createException(80022, new Object[0]);
    }

    public Map<String, Object> update(String userName, String resourceId, String content) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes("utf-8"));
        BmlClient client = this.createBMLClient(userName);
        BmlUpdateResponse resource = client.updateShareResource(userName, resourceId, new StringBuilder().append((Object)UUID.randomUUID().toString()).append((Object)".json").toString(), (InputStream)inputStream);
        if (resource.isSuccess()) {
            HashMap map = new HashMap();
            JavaConversions$.MODULE$.mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"resourceId"), (Object)resource.resourceId()));
            return JavaConversions$.MODULE$.mutableMapAsJavaMap((scala.collection.mutable.Map)JavaConversions$.MODULE$.mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)resource.version())));
        }
        throw WorkspaceExceptionManager.createException(80022, new Object[0]);
    }

    public Map<String, Object> query(String userName, String resourceId, String version) {
        BmlClient client = this.createBMLClient(userName);
        BmlDownloadResponse resource = null;
        resource = version == null ? client.downloadShareResource(userName, resourceId, null) : client.downloadShareResource(userName, resourceId, version);
        if (resource.isSuccess()) {
            HashMap map = new HashMap();
            JavaConversions$.MODULE$.mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)resource.fullFilePath()));
            return JavaConversions$.MODULE$.mutableMapAsJavaMap((scala.collection.mutable.Map)JavaConversions$.MODULE$.mapAsScalaMap(map).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stream"), (Object)resource.inputStream())));
        }
        throw WorkspaceExceptionManager.createException(80023, new Object[0]);
    }

    private String inputstremToString(InputStream inputStream) {
        return Source$.MODULE$.fromInputStream(inputStream, Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    private BmlClient createBMLClient(String userName) {
        return userName == null ? BmlClientFactory.createBmlClient() : BmlClientFactory.createBmlClient((String)userName);
    }
}

