/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.linkis.bml.client.BmlClient;
import org.apache.linkis.bml.client.BmlClientFactory;
import org.apache.linkis.bml.protocol.BmlDownloadResponse;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.datasourcemanager.common.util.json.Json;
import org.apache.linkis.metadata.query.common.domain.MetaColumnInfo;
import org.apache.linkis.metadata.query.common.domain.MetaPartitionInfo;
import org.apache.linkis.metadata.query.common.exception.MetaRuntimeException;
import org.apache.linkis.metadata.query.common.service.AbstractDbMetaService;
import org.apache.linkis.metadata.query.common.service.MetadataConnection;
import org.apache.linkis.metadata.query.service.HiveConnection;
import org.apache.linkis.metadata.query.service.HiveParamsMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaService
extends AbstractDbMetaService<HiveConnection> {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMetaService.class);
    private static final CommonVars<String> TMP_FILE_STORE_LOCATION = CommonVars.apply((String)"wds.linkis.server.mdm.service.temp.location", (Object)"/tmp/keytab");
    private BmlClient client = BmlClientFactory.createBmlClient();
    private static final String PARTITION_PART_SEPARATOR = ",";
    private static final String PARTITION_KV_SEPARATOR = "=";
    private static final String PARTITION_CV_SEPARATOR = "/";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MetadataConnection<HiveConnection> getConnection(String operator, Map<String, Object> params) throws Exception {
        String uris = String.valueOf(params.getOrDefault(HiveParamsMapper.PARAM_HIVE_URIS.getValue(), ""));
        String principle = String.valueOf(params.getOrDefault(HiveParamsMapper.PARAM_HIVE_PRINCIPLE.getValue(), ""));
        HiveConnection conn = null;
        if (StringUtils.isNotBlank((CharSequence)principle)) {
            LOG.info("Try to connect Hive MetaStore in kerberos with principle:[" + principle + "]");
            String keytabResourceId = String.valueOf(params.getOrDefault(HiveParamsMapper.PARAM_HIVE_KEYTAB.getValue(), ""));
            if (!StringUtils.isNotBlank((CharSequence)keytabResourceId)) throw new MetaRuntimeException("Cannot find the keytab file in connect parameters", null);
            FileUtils.forceMkdir((File)new File((String)TMP_FILE_STORE_LOCATION.getValue()));
            LOG.info("Start to download resource id:[" + keytabResourceId + "]");
            String keytabFilePath = (String)TMP_FILE_STORE_LOCATION.getValue() + PARTITION_CV_SEPARATOR + UUID.randomUUID().toString().replace("-", "") + ".keytab";
            if (!this.downloadResource(keytabResourceId, operator, keytabFilePath)) {
                throw new MetaRuntimeException("Fail to download resource i:[" + keytabResourceId + "]", null);
            }
            conn = new HiveConnection(uris, principle, keytabFilePath, this.getExtraHadoopConf(params));
            return new MetadataConnection((Object)conn, true);
        } else {
            conn = new HiveConnection(uris, this.getExtraHadoopConf(params));
        }
        return new MetadataConnection((Object)conn, true);
    }

    private boolean downloadResource(String resourceId, String user, String absolutePath) throws IOException {
        LOG.info("Try to download resource resourceId:[" + resourceId + "],user=[" + user + "], will store in path:" + absolutePath);
        BmlDownloadResponse downloadResponse = this.client.downloadResource(user, resourceId);
        if (downloadResponse.isSuccess()) {
            IOUtils.copy((InputStream)downloadResponse.inputStream(), (OutputStream)new FileOutputStream(absolutePath));
            return true;
        }
        return false;
    }

    public List<String> queryDatabases(HiveConnection connection) {
        try {
            return connection.getClient().getAllDatabases();
        }
        catch (HiveException e) {
            throw new RuntimeException("Fail to get Hive databases(\u83b7\u53d6\u6570\u636e\u5e93\u5217\u8868\u5931\u8d25)", e);
        }
    }

    public List<String> queryTables(HiveConnection connection, String database) {
        try {
            return connection.getClient().getAllTables(database);
        }
        catch (HiveException e) {
            throw new RuntimeException("Fail to get Hive tables(\u83b7\u53d6\u8868\u5217\u8868\u5931\u8d25)", e);
        }
    }

    public MetaPartitionInfo queryPartitions(HiveConnection connection, String database, String table, boolean traverse) {
        List partitions;
        Table rawTable;
        try {
            rawTable = connection.getClient().getTable(database, table);
            partitions = traverse ? connection.getClient().getPartitions(rawTable) : Collections.emptyList();
        }
        catch (HiveException e2) {
            throw new RuntimeException("Fail to get Hive partitions(\u83b7\u53d6\u5206\u533a\u4fe1\u606f\u5931\u8d25)", e2);
        }
        MetaPartitionInfo info = new MetaPartitionInfo();
        List partitionKeys = rawTable.getPartitionKeys();
        ArrayList partKeys = new ArrayList();
        partitionKeys.forEach(e -> partKeys.add(e.getName()));
        info.setPartKeys(partKeys);
        if (traverse) {
            HashMap<String, MetaPartitionInfo.PartitionNode> pMap = new HashMap<String, MetaPartitionInfo.PartitionNode>(20);
            MetaPartitionInfo.PartitionNode root = new MetaPartitionInfo.PartitionNode();
            info.setRoot(root);
            long t = System.currentTimeMillis();
            for (Partition p : partitions) {
                try {
                    List values = p.getValues();
                    if (partitionKeys.isEmpty()) continue;
                    String parentNameValue = "";
                    for (int i = 0; i < values.size(); ++i) {
                        FieldSchema fieldSchema = (FieldSchema)partitionKeys.get(i);
                        String name = fieldSchema.getName();
                        String value = (String)values.get(i);
                        String nameValue = name + PARTITION_KV_SEPARATOR + value;
                        MetaPartitionInfo.PartitionNode node = new MetaPartitionInfo.PartitionNode();
                        if (i > 0) {
                            MetaPartitionInfo.PartitionNode parent = (MetaPartitionInfo.PartitionNode)pMap.get(parentNameValue);
                            parent.setName(name);
                            parent.getPartitions().putIfAbsent(value, node);
                        } else {
                            root.setName(name);
                            root.getPartitions().putIfAbsent(value, node);
                        }
                        parentNameValue = parentNameValue + PARTITION_CV_SEPARATOR + nameValue;
                        pMap.putIfAbsent(parentNameValue, node);
                    }
                }
                catch (Exception e3) {
                    LOG.warn(e3.getMessage(), (Throwable)e3);
                }
            }
        }
        return info;
    }

    public List<MetaColumnInfo> queryColumns(HiveConnection connection, String database, String table) {
        Table tb;
        ArrayList<MetaColumnInfo> columns = new ArrayList<MetaColumnInfo>();
        try {
            tb = connection.getClient().getTable(database, table);
        }
        catch (HiveException e) {
            throw new RuntimeException("Fail to get Hive columns(\u83b7\u5f97\u8868\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25)", e);
        }
        tb.getFields().forEach(field -> {
            MetaColumnInfo metaColumnInfo = new MetaColumnInfo();
            metaColumnInfo.setIndex(field.getFieldID());
            metaColumnInfo.setName(field.getFieldName());
            metaColumnInfo.setType(field.getFieldObjectInspector().getTypeName());
            columns.add(metaColumnInfo);
        });
        return columns;
    }

    public Map<String, String> queryTableProps(HiveConnection connection, String database, String table) {
        try {
            Table rawTable = connection.getClient().getTable(database, table);
            return new HashMap<Object, Object>(rawTable.getMetadata());
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to get Hive table properties(\u83b7\u53d6\u8868\u53c2\u6570\u4fe1\u606f\u5931\u8d25)", e);
        }
    }

    public Map<String, String> queryPartitionProps(HiveConnection connection, String database, String table, String partition) {
        HashMap<String, String> properties = new HashMap<String, String>();
        Hive client = connection.getClient();
        if (Objects.nonNull(client) && StringUtils.isNotBlank((CharSequence)partition)) {
            try {
                Map<String, String> partitionParts = Arrays.stream(partition.split(partition.contains(PARTITION_CV_SEPARATOR) ? PARTITION_CV_SEPARATOR : PARTITION_PART_SEPARATOR)).map(part -> part.split(PARTITION_KV_SEPARATOR)).collect(Collectors.toMap(kv -> kv[0], kv -> ((String[])kv).length > 1 ? kv[1] : ""));
                Table rawTable = client.getTable(database, table);
                Partition rawPartition = client.getPartition(rawTable, partitionParts, false);
                if (Objects.nonNull(rawPartition)) {
                    Properties metadataProps = rawPartition.getMetadataFromPartitionSchema();
                    Enumeration<?> propertyNames = metadataProps.propertyNames();
                    while (propertyNames.hasMoreElements()) {
                        String propName = String.valueOf(propertyNames.nextElement());
                        Optional.ofNullable(metadataProps.getProperty(propName, null)).ifPresent(value -> properties.put(propName, (String)value));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Fail to get partition's properties(\u83b7\u53d6\u5206\u533a\u53c2\u6570\u4fe1\u606f\u5931\u8d25)", e);
            }
        }
        return properties;
    }

    private Map<String, String> getExtraHadoopConf(Map<String, Object> connectParams) {
        Map<String, String> extraHadoopConf = new HashMap<String, String>();
        Object extraHadoopConfObj = connectParams.get(HiveParamsMapper.PARAM_HADOOP_CONF.getValue());
        if (Objects.nonNull(extraHadoopConfObj)) {
            try {
                extraHadoopConf = !(extraHadoopConfObj instanceof Map) ? (Map)Json.fromJson((String)String.valueOf(extraHadoopConfObj), Map.class, (Class[])new Class[]{String.class, String.class}) : (Map)extraHadoopConfObj;
            }
            catch (Exception e) {
                throw new MetaRuntimeException("Cannot parse the param:[" + (String)HiveParamsMapper.PARAM_HADOOP_CONF.getValue() + "]", (Throwable)e);
            }
        }
        return extraHadoopConf;
    }
}

