/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.service;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.linkis.common.conf.CommonVars;

public class HiveConnection
implements Closeable {
    private Hive hiveClient;
    private IMetaStoreClient metaStoreClient;
    private static final CommonVars<String> KERBEROS_DEFAULT_PRINCIPLE = CommonVars.apply((String)"wds.linkis.server.mdm.service.kerberos.principle", (Object)"hadoop/_HOST@EXAMPLE.COM");
    private static final CommonVars<String> DEFAULT_SERVICE_USER = CommonVars.apply((String)"wds.linkis.server.mdm.service.user", (Object)"hadoop");
    private static final CommonVars<String> KERBEROS_KRB5_CONF_PATH = CommonVars.apply((String)"wds.linkis.server.mdm.service.kerberos.krb5.path", (Object)"");

    public HiveConnection(String uris, String principle, String keytabFilePath, Map<String, String> hadoopConf) throws Exception {
        HiveConf conf = new HiveConf();
        conf.setVar(HiveConf.ConfVars.METASTOREURIS, uris);
        conf.setVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL, "true");
        conf.setVar(HiveConf.ConfVars.METASTORE_KERBEROS_PRINCIPAL, (String)KERBEROS_DEFAULT_PRINCIPLE.getValue());
        conf.setBoolean(String.format("fs.%s.impl.disable.cache", URI.create(conf.get("fs.defaultFS", "")).getScheme()), true);
        conf.set("hadoop.security.authentication", "kerberos");
        hadoopConf.forEach((arg_0, arg_1) -> ((HiveConf)conf).set(arg_0, arg_1));
        principle = principle.substring(0, principle.indexOf("@"));
        UserGroupInformation ugi = UserGroupInformationWrapper.loginUserFromKeytab((Configuration)conf, principle, keytabFilePath);
        this.hiveClient = this.getHive(ugi, conf);
    }

    public HiveConnection(String uris, Map<String, String> hadoopConf) throws Exception {
        HiveConf conf = new HiveConf();
        conf.setVar(HiveConf.ConfVars.METASTOREURIS, uris);
        hadoopConf.forEach((arg_0, arg_1) -> ((HiveConf)conf).set(arg_0, arg_1));
        conf.setBoolean(String.format("fs.%s.impl.disable.cache", URI.create(conf.get("fs.defaultFS", "")).getScheme()), true);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)((String)DEFAULT_SERVICE_USER.getValue()));
        this.hiveClient = this.getHive(ugi, conf);
    }

    public Hive getClient() {
        return this.hiveClient;
    }

    private Hive getHive(UserGroupInformation ugi, HiveConf conf) throws IOException, InterruptedException {
        return (Hive)ugi.doAs(() -> {
            Hive hive = Hive.get((HiveConf)conf);
            this.metaStoreClient = hive.getMSC();
            Hive.set(null);
            return hive;
        });
    }

    @Override
    public void close() throws IOException {
        this.metaStoreClient.close();
    }

    static {
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)KERBEROS_KRB5_CONF_PATH.getValue()))) {
            System.setProperty("java.security.krb5.conf", (String)KERBEROS_KRB5_CONF_PATH.getValue());
        }
    }

    private static class UserGroupInformationWrapper {
        private static ReentrantLock globalLock = new ReentrantLock();

        private UserGroupInformationWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static UserGroupInformation loginUserFromKeytab(Configuration conf, String user, String path) throws Exception {
            globalLock.lock();
            try {
                UserGroupInformation.setConfiguration((Configuration)conf);
                UserGroupInformation userGroupInformation = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)user, (String)path);
                return userGroupInformation;
            }
            finally {
                globalLock.unlock();
            }
        }

        public static UserGroupInformation createProxyUser(Configuration conf, String user) throws Exception {
            globalLock.lock();
            try {
                UserGroupInformation.setLoginUser(null);
                UserGroupInformation.setConfiguration((Configuration)conf);
                UserGroupInformation userGroupInformation = UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser());
                return userGroupInformation;
            }
            finally {
                globalLock.unlock();
            }
        }

        public static UserGroupInformation getLoginUser() throws Exception {
            globalLock.lock();
            try {
                UserGroupInformation.setLoginUser(null);
                UserGroupInformation userGroupInformation = UserGroupInformation.getLoginUser();
                return userGroupInformation;
            }
            finally {
                globalLock.unlock();
            }
        }
    }
}

