/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.errorcode.client.synchronizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.common.utils.Utils;
import org.apache.linkis.errorcode.client.ErrorCodeClientBuilder;
import org.apache.linkis.errorcode.client.LinkisErrorCodeClient;
import org.apache.linkis.errorcode.common.LinkisErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkisErrorCodeSynchronizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkisErrorCodeSynchronizer.class);
    private LinkisErrorCode errorCode = new LinkisErrorCode("60001", "\u4f1a\u8bdd\u521b\u5efa\u5931\u8d25\uff0c%s\u961f\u5217\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u961f\u5217\u8bbe\u7f6e\u662f\u5426\u6b63\u786e", "queue (\\S+) is not exists in YARN", 0);
    private List<LinkisErrorCode> linkisErrorCodeList = Arrays.asList(this.errorCode);
    private final Object lock = new Object();
    private static final long PERIOD = (Long)CommonVars.apply((String)"wds.linkis.errorcode.period.time", (Object)1L).getValue();
    private static LinkisErrorCodeSynchronizer linkisErrorCodeSynchronizer;
    private final LinkisErrorCodeClient errorCodeClient = new ErrorCodeClientBuilder().setVersion("v1").build();

    private LinkisErrorCodeSynchronizer() {
        this.init();
    }

    private void init() {
        LOGGER.info("start to get errorcodes from linkis server");
        Utils.defaultScheduler().scheduleAtFixedRate(() -> {
            LOGGER.info("start to get errorcodes from linkis server");
            Object object = this.lock;
            synchronized (object) {
                ArrayList<LinkisErrorCode> copyErrorCodes = new ArrayList<LinkisErrorCode>(this.linkisErrorCodeList);
                try {
                    List<LinkisErrorCode> tmpList = this.errorCodeClient.getErrorCodesFromServer();
                    if (null != tmpList && !tmpList.isEmpty()) {
                        this.linkisErrorCodeList = tmpList;
                    } else {
                        LOGGER.warn("Got empty errorCodeList.");
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("Failed to get ErrorCodes from linkis server", t);
                    this.linkisErrorCodeList = copyErrorCodes;
                }
            }
        }, 0L, 1L, TimeUnit.HOURS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LinkisErrorCodeSynchronizer getInstance() {
        if (linkisErrorCodeSynchronizer != null) return linkisErrorCodeSynchronizer;
        Class<LinkisErrorCodeSynchronizer> clazz = LinkisErrorCodeSynchronizer.class;
        synchronized (LinkisErrorCodeSynchronizer.class) {
            if (linkisErrorCodeSynchronizer != null) return linkisErrorCodeSynchronizer;
            linkisErrorCodeSynchronizer = new LinkisErrorCodeSynchronizer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return linkisErrorCodeSynchronizer;
        }
    }

    public List<LinkisErrorCode> synchronizeErrorCodes() {
        return this.linkisErrorCodeList;
    }
}

