/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.errorcode.client.handler;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.errorcode.client.ClientConfiguration;
import org.apache.linkis.errorcode.client.handler.ExceptionErrorCodeHandler;
import org.apache.linkis.errorcode.client.handler.LogErrorCodeHandler;
import org.apache.linkis.errorcode.client.handler.LogFileErrorCodeHandler;
import org.apache.linkis.errorcode.client.manager.LinkisErrorCodeManager;
import org.apache.linkis.errorcode.client.utils.ErrorCodeMatcher;
import org.apache.linkis.errorcode.common.ErrorCode;
import org.apache.linkis.errorcode.common.LinkisErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Tuple2;

public class LinkisErrorCodeHandler
implements LogErrorCodeHandler,
LogFileErrorCodeHandler,
ExceptionErrorCodeHandler {
    private static LinkisErrorCodeHandler linkisErrorCodeHandler;
    private final LinkisErrorCodeManager linkisErrorCodeManager = LinkisErrorCodeManager.getInstance();
    private static final Logger LOGGER;
    private final long futureTimeOut = (Long)ClientConfiguration.FUTURE_TIME_OUT.getValue();
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("linkis-errorcode-handler-%d").build();
    private final ExecutorService threadPool = new ThreadPoolExecutor(5, 200, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), this.threadFactory, new ThreadPoolExecutor.AbortPolicy());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LinkisErrorCodeHandler getInstance() {
        if (null != linkisErrorCodeHandler) return linkisErrorCodeHandler;
        Class<LinkisErrorCodeHandler> clazz = LinkisErrorCodeHandler.class;
        synchronized (LinkisErrorCodeHandler.class) {
            if (null != linkisErrorCodeHandler) return linkisErrorCodeHandler;
            linkisErrorCodeHandler = new LinkisErrorCodeHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return linkisErrorCodeHandler;
        }
    }

    private LinkisErrorCodeHandler() {
    }

    @Override
    public List<ErrorCode> handle(String log) {
        HashSet errorCodeSet = new HashSet();
        Runnable runnable = () -> {
            List<LinkisErrorCode> errorCodes = this.linkisErrorCodeManager.getLinkisErrorCodes();
            Arrays.stream(log.split("\n")).forEach(singleLog -> {
                Option<Tuple2<String, String>> match = ErrorCodeMatcher.errorMatch(errorCodes, singleLog);
                if (match.isDefined()) {
                    errorCodeSet.add(new LinkisErrorCode((String)((Tuple2)match.get())._1, (String)((Tuple2)match.get())._2));
                }
            });
        };
        Future<?> future = this.threadPool.submit(runnable);
        try {
            future.get(this.futureTimeOut, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOGGER.error("Failed to parse log in {} ms", (Object)this.futureTimeOut, (Object)e);
        }
        return new ArrayList<ErrorCode>(errorCodeSet);
    }

    @Override
    public void handle(List<String> logFilePaths) {
        LOGGER.info("begin to handle logfile list");
        for (String s : logFilePaths) {
            this.handle(s, 0);
        }
    }

    @Override
    public void handle(String logFilePath, int type) {
        LOGGER.info("begin to handle logFilePath {}", (Object)logFilePath);
        try {
            this.writeToFile(logFilePath, "\u6b63\u5728\u6839\u636e\u60a8\u4efb\u52a1\u7684\u9519\u8bef\u4fe1\u606f\u4e3a\u60a8\u8bca\u65ad\u5e76\u751f\u6210\u9519\u8bef\u7801,\u5927\u7ea6\u9700\u8981\u51e0\u79d2\u949f,\u8bf7\u60a8\u7a0d\u7b49...");
        }
        catch (Exception e) {
            LOGGER.error("Failed to append error code to log file {}", (Object)logFilePath, (Object)e);
            return;
        }
        Runnable runnable = () -> {
            HashSet<LinkisErrorCode> errorCodeSet = new HashSet<LinkisErrorCode>();
            LOGGER.info("start to parse error codes for {}", (Object)logFilePath);
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(logFilePath));){
                List<LinkisErrorCode> errorCodes = this.linkisErrorCodeManager.getLinkisErrorCodes();
                String log = null;
                while ((log = bufferedReader.readLine()) != null) {
                    Option<Tuple2<String, String>> match = ErrorCodeMatcher.errorMatch(errorCodes, log);
                    if (!match.isDefined()) continue;
                    errorCodeSet.add(new LinkisErrorCode((String)((Tuple2)match.get())._1, (String)((Tuple2)match.get())._2));
                }
            }
            catch (IOException e) {
                LOGGER.error("failed to handle log file {} ", (Object)logFilePath, (Object)e);
                return;
            }
            try {
                if (errorCodeSet.size() == 0) {
                    this.writeToFile(logFilePath, "\u60a8\u597d,\u5f88\u62b1\u6b49,\u672a\u80fd\u4e3a\u60a8\u8bca\u65ad\u51fa\u9519\u8bef\u4fe1\u606f,\u6211\u4eec\u4f1a\u5b8c\u5584\u6211\u4eec\u7684\u9519\u8bef\u7801\u5e93");
                } else {
                    this.writeToFile(logFilePath, "\u60a8\u597d,\u6210\u529f\u4e3a\u60a8\u8bca\u65ad\u51fa\u4efb\u52a1\u7684\u9519\u8bef\u4fe1\u606f,\u8bf7\u60a8\u67e5\u770b");
                    ArrayList retErrorCodes = new ArrayList(errorCodeSet);
                    this.writeToFile(logFilePath, ((Object)retErrorCodes).toString());
                }
            }
            catch (Exception e) {
                LOGGER.error("failed to write to errorcodes to {} ", (Object)logFilePath, (Object)e);
            }
        };
        this.threadPool.submit(runnable);
        LOGGER.info("put handle into threadPool");
    }

    private void writeToFile(String filePath, String content) throws Exception {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filePath, true)));
        bufferedWriter.write(content);
        bufferedWriter.write(NEW_LINE);
        bufferedWriter.close();
    }

    private String readLastRows(String filename, Charset charset, int rows) throws IOException {
        charset = charset == null ? Charset.defaultCharset() : charset;
        String lineSeparator = NEW_LINE;
        try (RandomAccessFile rf = new RandomAccessFile(filename, "r");){
            byte[] c = new byte[lineSeparator.getBytes().length];
            long pointer = rf.length();
            long lineSeparatorNum = 0L;
            while (pointer >= 0L && lineSeparatorNum < (long)rows) {
                rf.seek(pointer--);
                int readLength = rf.read(c);
                if (readLength != -1 && new String(c, 0, readLength).equals(lineSeparator)) {
                    ++lineSeparatorNum;
                }
                if (pointer != -1L || lineSeparatorNum >= (long)rows) continue;
                rf.seek(0L);
            }
            byte[] tempbytes = new byte[(int)(rf.length() - rf.getFilePointer())];
            rf.readFully(tempbytes);
            String string = new String(tempbytes, charset);
            return string;
        }
    }

    @Override
    public List<ErrorCode> handleFileLines(String logFilePath, int line) {
        if (line <= 0) {
            line = 1000;
        }
        String todoLog = null;
        try {
            todoLog = this.readLastRows(logFilePath, Charsets.UTF_8, line);
        }
        catch (Exception e) {
            LOGGER.error("failed to read last {} lines in file {}", new Object[]{line, logFilePath, e});
        }
        if (StringUtils.isNotEmpty((String)todoLog)) {
            return this.handle(todoLog);
        }
        return new ArrayList<ErrorCode>();
    }

    @Override
    public ErrorCode handle(Throwable t) {
        return null;
    }

    @Override
    public void close() throws IOException {
        this.threadPool.shutdown();
    }

    static {
        LOGGER = LoggerFactory.getLogger(LinkisErrorCodeHandler.class);
        LinkisErrorCodeHandler.getInstance();
    }
}

