/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.errorcode.client;

import org.apache.linkis.common.conf.CommonVars;

public class ClientConfiguration {
    public static final CommonVars<String> LINKIS_GATEWAY_URL = CommonVars.apply((String)"wds.linkis.gateway.url", (Object)"http://127.0.0.1:9001");
    public static final CommonVars<String> ERRORCODE_URL_PREFIX = CommonVars.apply((String)"wds.linkis.errorcode.url.prefix", (Object)"/api/rest_j/v1/");
    public static final CommonVars<String> ERRORCODE_GET_URL = CommonVars.apply((String)"wds.linkis.errorcode.get.url", (Object)"getErrorCodes");
    public static final CommonVars<Long> DEFAULT_CONNECT_TIME_OUT = CommonVars.apply((String)"wds.linkis.errorcode.timeout", (Object)600000L);
    public static final CommonVars<Long> DEFAULT_READ_TIME_OUT = CommonVars.apply((String)"wds.linkis.errorcode.read.timeout", (Object)600000L);
    public static final CommonVars<String> AUTH_TOKEN_VALUE = CommonVars.apply((String)"wds.linkis.errorcode.auth.token", (Object)"BML-AUTH");
    public static final CommonVars<Long> FUTURE_TIME_OUT = CommonVars.apply((String)"wds.linkis.errorcode.future.timeout", (Object)2000L);

    public static String getGatewayUrl() {
        return (String)LINKIS_GATEWAY_URL.getValue();
    }

    public static long getConnectTimeOut() {
        return (Long)DEFAULT_CONNECT_TIME_OUT.getValue();
    }

    public static long getReadTimeOut() {
        return (Long)DEFAULT_READ_TIME_OUT.getValue();
    }

    public static String getErrorCodeUrl() {
        return (String)LINKIS_GATEWAY_URL.getValue() + (String)ERRORCODE_URL_PREFIX.getValue() + (String)ERRORCODE_GET_URL.getValue();
    }

    public static String getAuthKey() {
        return "Validation-Code";
    }

    public static String getAuthValue() {
        return (String)AUTH_TOKEN_VALUE.getValue();
    }

    public static String getVersion() {
        return "v1";
    }
}

