/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.python.utils;

import org.apache.commons.lang3.StringUtils;

public abstract class Kind {
    public static final String RESTART_CODE = "@restart";
    public static final String[] APPLICATION_START_COMMAND = new String[]{"\\s*@restart\\s*", "\\s*[@|%][a-zA-Z]{1,12}\\s*", "^\\s*@set\\s*spark\\..+\\s*", "^\\s*#.+\\s*", "^\\s*//.+\\s*", "^\\s*--.+\\s*", "\\s*"};

    public static boolean needToRestart(String code) {
        return code.startsWith(RESTART_CODE);
    }

    private static int getIndex(String _code, int start) {
        int index1 = _code.indexOf("\n", start);
        int index2 = _code.indexOf("\\n", start);
        if (index1 > -1 && index2 > -1) {
            return Math.min(index1, index2);
        }
        return Math.max(index1, index2);
    }

    public static String getKindString(String code) {
        int index;
        code = StringUtils.strip((String)code);
        int start = 0;
        if (code.startsWith(RESTART_CODE)) {
            start = Kind.getIndex(code, 0) + 1;
        }
        if ((index = Kind.getIndex(code, start)) == -1) {
            index = code.length();
        }
        return StringUtils.strip((String)code.substring(start, index));
    }

    public static String getKind(String code) {
        String kindStr = Kind.getKindString(code);
        if (kindStr.matches("[%|@][a-zA-Z]{1,12}")) {
            return kindStr.substring(1);
        }
        throw new IllegalArgumentException("Unknown kind " + kindStr);
    }

    public static String getRealCode(String code) {
        String kindStr = Kind.getKindString(code = StringUtils.strip((String)code));
        if (kindStr.matches("[%|@][a-zA-Z]{1,12}")) {
            return StringUtils.strip((String)code.substring(code.indexOf(kindStr) + kindStr.length()));
        }
        if (code.startsWith(RESTART_CODE)) {
            return StringUtils.strip((String)code.substring(RESTART_CODE.length()));
        }
        return code;
    }
}

