/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.python.hook;

import java.util.HashMap;
import org.apache.linkis.engineconn.common.creation.EngineCreationContext;
import org.apache.linkis.engineconn.common.engineconn.EngineConn;
import org.apache.linkis.engineconn.common.hook.EngineConnHook;
import org.apache.linkis.manager.engineplugin.python.conf.PythonEngineConfiguration;
import org.apache.linkis.manager.engineplugin.python.executor.PythonSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonVersionEngineHook
implements EngineConnHook {
    private static final Logger logger = LoggerFactory.getLogger(PythonVersionEngineHook.class);
    private String pythonVersion = "python3";
    private String pythonExtraPackage = "file:///mnt/bdap/test/test/test.zip";

    public void beforeCreateEngineConn(EngineCreationContext engineCreationContext) {
        HashMap params = new HashMap();
        if (engineCreationContext.getOptions() != null) {
            params.putAll(engineCreationContext.getOptions());
        }
        this.pythonVersion = params.getOrDefault("python.version", "python3");
        this.pythonExtraPackage = params.getOrDefault("python.application.pyFiles", "file:///mnt/bdap/test/test/test.zip");
        logger.info("python version => {}", (Object)this.pythonVersion);
        logger.info("python application pyFiles => {}", (Object)this.pythonExtraPackage);
    }

    public void beforeExecutionExecute(EngineCreationContext engineCreationContext, EngineConn engineConn) {
        logger.info("use python execute print cmd hello");
        if (engineConn.getEngineConnSession() instanceof PythonSession) {
            PythonSession pythonSession = (PythonSession)engineConn.getEngineConnSession();
            pythonSession.execute("print(1/2)");
            logger.info("print python version => {}", PythonEngineConfiguration.PYTHON_VERSION.getValue());
        } else {
            logger.error("Invalid pythonSession : {}", (Object)engineConn.getEngineConnSession().getClass().getName());
        }
    }

    public void afterExecutionExecute(EngineCreationContext engineCreationContext, EngineConn engineConn) {
    }

    public void afterEngineServerStartFailed(EngineCreationContext engineCreationContext, Throwable throwable) {
    }

    public void afterEngineServerStartSuccess(EngineCreationContext engineCreationContext, EngineConn engineConn) {
    }
}

