/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.python.executor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.linkis.engineconn.computation.executor.execute.ComputationExecutor;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineconn.core.EngineConnObject;
import org.apache.linkis.engineconn.launch.EngineConnServer;
import org.apache.linkis.governance.common.paser.CodeParser;
import org.apache.linkis.governance.common.paser.PythonCodeParser;
import org.apache.linkis.manager.common.entity.resource.CommonNodeResource;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.engineplugin.common.util.NodeResourceUtils;
import org.apache.linkis.manager.engineplugin.python.conf.PythonEngineConfiguration;
import org.apache.linkis.manager.engineplugin.python.executor.PythonSession;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.protocol.engine.JobProgressInfo;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.SuccessExecuteResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonEngineConnExecutor
extends ComputationExecutor {
    private static final Logger logger = LoggerFactory.getLogger(PythonEngineConnExecutor.class);
    private EngineExecutionContext engineExecutionContext;
    private List<Label<?>> executorLabels = new ArrayList();
    private int id;
    private PythonSession pythonSession;
    private int outputPrintLimit;

    public PythonEngineConnExecutor(int id, PythonSession pythonSession, int outputPrintLimit) {
        super(outputPrintLimit);
        this.id = id;
        this.pythonSession = pythonSession;
        this.outputPrintLimit = outputPrintLimit;
    }

    public void init() {
        logger.info("Ready to change engine state!");
        this.setCodeParser((CodeParser)new PythonCodeParser());
        super.init();
    }

    private String getPyVersion() {
        if (null != EngineConnServer.getEngineCreationContext().getOptions()) {
            return EngineConnServer.getEngineCreationContext().getOptions().getOrDefault("python.version", "python");
        }
        return (String)PythonEngineConfiguration.PYTHON_VERSION.getValue();
    }

    public ExecuteResponse executeLine(EngineExecutionContext engineExecutionContext, String code) {
        String pythonVersion = engineExecutionContext.getProperties().getOrDefault("python.version", this.getPyVersion()).toString().toLowerCase();
        logger.info("EngineExecutionContext user python.version = > {}" + pythonVersion);
        System.getProperties().put("python.version", pythonVersion);
        logger.info("System getProperties python.version = > {}" + System.getProperties().getProperty("python.version"));
        this.pythonSession.lazyInitGateway();
        if (engineExecutionContext != this.engineExecutionContext) {
            this.engineExecutionContext = engineExecutionContext;
            this.pythonSession.setEngineExecutionContext(engineExecutionContext);
            logger.info("Python executor reset new engineExecutorContext!");
        }
        engineExecutionContext.appendStdout(this.getId() + " >> " + code.trim());
        this.pythonSession.execute(code);
        return new SuccessExecuteResponse();
    }

    public ExecuteResponse executeCompletely(EngineExecutionContext engineExecutionContext, String code, String completedLine) {
        String newcode = completedLine + code;
        logger.debug("newcode is {}", (Object)newcode);
        return this.executeLine(engineExecutionContext, newcode);
    }

    public float progress(String taskID) {
        if (null != this.engineExecutionContext) {
            return this.engineExecutionContext.getCurrentParagraph() / this.engineExecutionContext.getTotalParagraph();
        }
        return 0.0f;
    }

    public JobProgressInfo[] getProgressInfo(String taskID) {
        String jobId;
        ArrayList<JobProgressInfo> jobProgressInfo = new ArrayList<JobProgressInfo>();
        if (null == this.engineExecutionContext) {
            return jobProgressInfo.toArray(new JobProgressInfo[0]);
        }
        String string = jobId = this.engineExecutionContext.getJobId().isDefined() ? (String)this.engineExecutionContext.getJobId().get() : "";
        if (0.0f == this.progress(taskID)) {
            jobProgressInfo.add(new JobProgressInfo(jobId, 1, 1, 0, 0));
        } else {
            jobProgressInfo.add(new JobProgressInfo(jobId, 1, 0, 0, 1));
        }
        return jobProgressInfo.toArray(new JobProgressInfo[0]);
    }

    public boolean supportCallBackLogs() {
        return true;
    }

    public NodeResource requestExpectedResource(NodeResource expectedResource) {
        return null;
    }

    public NodeResource getCurrentNodeResource() {
        CommonNodeResource resource = new CommonNodeResource();
        resource.setUsedResource((Resource)NodeResourceUtils.applyAsLoadInstanceResource((Map)EngineConnObject.getEngineCreationContext().getOptions()));
        return resource;
    }

    public List<Label<?>> getExecutorLabels() {
        return this.executorLabels;
    }

    public void setExecutorLabels(List<Label<?>> labels) {
        if (labels != null) {
            this.executorLabels.clear();
            this.executorLabels.addAll(labels);
        }
    }

    public String getId() {
        return Sender.getThisServiceInstance().getInstance() + "_" + this.id;
    }

    public void killTask(String taskID) {
        logger.info("Start to kill python task " + taskID);
        super.killTask(taskID);
        logger.info("To close python cli task " + taskID);
        this.close();
    }

    public void close() {
        this.pythonSession.close();
        logger.info("To delete python executor");
        logger.info("Finished to kill python");
    }
}

