/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.pipeline.executor;

import java.io.File;
import java.util.Map;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.manager.engineplugin.pipeline.errorcode.PopelineErrorCodeSummary;
import org.apache.linkis.manager.engineplugin.pipeline.exception.PipeLineErrorException;
import org.apache.linkis.manager.engineplugin.pipeline.executor.PipeLineExecutor;
import org.apache.linkis.manager.engineplugin.pipeline.executor.PipelineEngineConnExecutor$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;

public final class PipelineExecutorSelector$
implements Logging {
    public static PipelineExecutorSelector$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new PipelineExecutorSelector$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        PipelineExecutorSelector$ pipelineExecutorSelector$ = this;
        synchronized (pipelineExecutorSelector$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public PipeLineExecutor select(String sourcePath, String destPath, Map<String, String> options) throws PipeLineErrorException {
        PipeLineExecutor pipeLineExecutor;
        Object object = new Object();
        try {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])PipelineEngineConnExecutor$.MODULE$.listPipelineExecutors())).foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
                x$1.init(options);
                return BoxedUnit.UNIT;
            });
            pipeLineExecutor = (PipeLineExecutor)Utils$.MODULE$.tryCatch((Function0 & java.io.Serializable & Serializable)() -> {
                if (new File(sourcePath).getName().equals(new File(destPath).getName())) {
                    throw new NonLocalReturnControl(object, (Object)PipelineEngineConnExecutor$.MODULE$.listPipelineExecutors()[0]);
                }
                String string = MODULE$.getSuffix(destPath);
                if (".csv".equals(string)) {
                    return PipelineEngineConnExecutor$.MODULE$.listPipelineExecutors()[1];
                }
                if (".xlsx".equals(string)) {
                    return PipelineEngineConnExecutor$.MODULE$.listPipelineExecutors()[2];
                }
                throw new PipeLineErrorException(PopelineErrorCodeSummary.UNSUPPORT_OUTPUT_TYPE.getErrorCode(), PopelineErrorCodeSummary.UNSUPPORT_OUTPUT_TYPE.getErrorDesc());
            }, (Function1 & java.io.Serializable & Serializable)x0$1 -> {
                Throwable throwable = x0$1;
                if (throwable instanceof Exception) {
                    Exception exception = (Exception)throwable;
                    MODULE$.logger().error("select executor failed", (Throwable)exception);
                    throw new PipeLineErrorException(PopelineErrorCodeSummary.UNSUPPORT_OUTPUT_TYPE.getErrorCode(), PopelineErrorCodeSummary.UNSUPPORT_OUTPUT_TYPE.getErrorDesc());
                }
                throw new MatchError((Object)throwable);
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                pipeLineExecutor = (PipeLineExecutor)ex.value();
            }
            throw ex;
        }
        return pipeLineExecutor;
    }

    public String getSuffix(String str) {
        return str.substring(str.lastIndexOf("."));
    }

    private PipelineExecutorSelector$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

