/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.pipeline.executor;

import java.io.Closeable;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.FsWriter;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.manager.engineplugin.pipeline.conf.PipelineEngineConfiguration$;
import org.apache.linkis.manager.engineplugin.pipeline.constant.PipeLineConstant$;
import org.apache.linkis.manager.engineplugin.pipeline.errorcode.PopelineErrorCodeSummary;
import org.apache.linkis.manager.engineplugin.pipeline.exception.PipeLineErrorException;
import org.apache.linkis.manager.engineplugin.pipeline.executor.CSVExecutor$;
import org.apache.linkis.manager.engineplugin.pipeline.executor.OutputStreamCache$;
import org.apache.linkis.manager.engineplugin.pipeline.executor.PipeLineExecutor;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.storage.FSFactory;
import org.apache.linkis.storage.csv.CSVFsWriter;
import org.apache.linkis.storage.source.FileSource;
import org.apache.linkis.storage.utils.StorageConfiguration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a3AAC\u0006\u00015!)Q\u0005\u0001C\u0001M!)\u0001\u0006\u0001C!S!)Q\n\u0001C!\u001d\u001e)qj\u0003E\u0001!\u001a)!b\u0003E\u0001#\")Q%\u0002C\u0001%\"91+\u0002b\u0001\n\u0003!\u0006BB+\u0006A\u0003%q\u0005C\u0003W\u000b\u0011\u0005qKA\u0006D'Z+\u00050Z2vi>\u0014(B\u0001\u0007\u000e\u0003!)\u00070Z2vi>\u0014(B\u0001\b\u0010\u0003!\u0001\u0018\u000e]3mS:,'B\u0001\t\u0012\u00031)gnZ5oKBdWoZ5o\u0015\t\u00112#A\u0004nC:\fw-\u001a:\u000b\u0005Q)\u0012A\u00027j].L7O\u0003\u0002\u0017/\u00051\u0011\r]1dQ\u0016T\u0011\u0001G\u0001\u0004_J<7\u0001A\n\u0004\u0001m\t\u0003C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"AB!osJ+g\r\u0005\u0002#G5\t1\"\u0003\u0002%\u0017\t\u0001\u0002+\u001b9f\u0019&tW-\u0012=fGV$xN]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u0002\"A\t\u0001\u0002\u000f\u0015DXmY;uKR!!FM B!\tY\u0003'D\u0001-\u0015\tic&\u0001\u0005fq\u0016\u001cW\u000f^3s\u0015\ty3#A\u0005tG\",G-\u001e7fe&\u0011\u0011\u0007\f\u0002\u0010\u000bb,7-\u001e;f%\u0016\u001c\bo\u001c8tK\")1G\u0001a\u0001i\u0005Q1o\\;sG\u0016\u0004\u0016\r\u001e5\u0011\u0005UbdB\u0001\u001c;!\t9T$D\u00019\u0015\tI\u0014$\u0001\u0004=e>|GOP\u0005\u0003wu\ta\u0001\u0015:fI\u00164\u0017BA\u001f?\u0005\u0019\u0019FO]5oO*\u00111(\b\u0005\u0006\u0001\n\u0001\r\u0001N\u0001\tI\u0016\u001cH\u000fU1uQ\")!I\u0001a\u0001\u0007\u00061RM\\4j]\u0016,\u00050Z2vi&|gnQ8oi\u0016DH\u000f\u0005\u0002E\u00176\tQI\u0003\u0002)\r*\u0011Ab\u0012\u0006\u0003\u0011&\u000b1bY8naV$\u0018\r^5p]*\u0011!jE\u0001\u000bK:<\u0017N\\3d_:t\u0017B\u0001'F\u0005Y)enZ5oK\u0016CXmY;uS>t7i\u001c8uKb$\u0018\u0001B&j]\u0012,\u0012\u0001N\u0001\f\u0007N3V\t_3dkR|'\u000f\u0005\u0002#\u000bM\u0011Qa\u0007\u000b\u0002!\u0006Y1m\u001d<Fq\u0016\u001cW\u000f^8s+\u00059\u0013\u0001D2tm\u0016CXmY;u_J\u0004\u0013aC4fi&s7\u000f^1oG\u0016,\u0012!\t")
public class CSVExecutor
implements PipeLineExecutor {
    private Map<String, String> options;

    public static PipeLineExecutor getInstance() {
        return CSVExecutor$.MODULE$.getInstance();
    }

    public static CSVExecutor csvExecutor() {
        return CSVExecutor$.MODULE$.csvExecutor();
    }

    @Override
    public void init(Map<String, String> newOptions) {
        PipeLineExecutor.init$(this, newOptions);
    }

    @Override
    public void cleanOptions() {
        PipeLineExecutor.cleanOptions$(this);
    }

    @Override
    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public void options_$eq(Map<String, String> x$1) {
        this.options = x$1;
    }

    @Override
    public ExecuteResponse execute(String sourcePath, String destPath, EngineExecutionContext engineExecutionContext) {
        if (!sourcePath.contains((CharSequence)StorageConfiguration.STORAGE_RS_FILE_SUFFIX.getValue())) {
            throw new PipeLineErrorException(PopelineErrorCodeSummary.EXPROTING_MULTIPLE.getErrorCode(), PopelineErrorCodeSummary.EXPROTING_MULTIPLE.getErrorDesc());
        }
        if (!FileSource.isResultSet((String)sourcePath)) {
            throw new PipeLineErrorException(PopelineErrorCodeSummary.NOT_A_RESULT_SET_FILE.getErrorCode(), PopelineErrorCodeSummary.NOT_A_RESULT_SET_FILE.getErrorDesc());
        }
        FsPath sourceFsPath = new FsPath(sourcePath);
        FsPath destFsPath = new FsPath(destPath);
        Fs sourceFs = FSFactory.getFs((FsPath)sourceFsPath);
        sourceFs.init(null);
        Fs destFs = FSFactory.getFs((FsPath)destFsPath);
        destFs.init(null);
        FileSource fileSource = FileSource.create((FsPath)sourceFsPath, (Fs)sourceFs);
        if (!FileSource.isTableResultSet((FileSource)fileSource)) {
            throw new PipeLineErrorException(PopelineErrorCodeSummary.ONLY_RESULT_CONVERTED_TO_CSV.getErrorCode(), PopelineErrorCodeSummary.ONLY_RESULT_CONVERTED_TO_CSV.getErrorDesc());
        }
        String nullValue = this.options().getOrDefault(PipeLineConstant$.MODULE$.PIPELINE_OUTPUT_SHUFFLE_NULL_TYPE(), "NULL");
        if (PipeLineConstant$.MODULE$.BLANK().equalsIgnoreCase(nullValue)) {
            nullValue = "";
        }
        OutputStream outputStream = destFs.write(destFsPath, BoxesRunTime.unboxToBoolean((Object)PipelineEngineConfiguration$.MODULE$.PIPELINE_OUTPUT_ISOVERWRITE_SWITCH().getValue(this.options())));
        OutputStreamCache$.MODULE$.osCache().put((String)engineExecutionContext.getJobId().get(), outputStream);
        CSVFsWriter cSVFsWriter = CSVFsWriter.getCSVFSWriter((String)((String)PipelineEngineConfiguration$.MODULE$.PIPELINE_OUTPUT_CHARSET_STR().getValue(this.options())), (String)((String)PipelineEngineConfiguration$.MODULE$.PIPELINE_FIELD_SPLIT_STR().getValue(this.options())), (boolean)BoxesRunTime.unboxToBoolean((Object)PipelineEngineConfiguration$.MODULE$.PIPELINE_FIELD_QUOTE_RETOUCH_ENABLE().getValue(this.options())), (OutputStream)outputStream);
        fileSource.addParams("nullValue", nullValue).write((FsWriter)cSVFsWriter);
        IOUtils.closeQuietly((Closeable)cSVFsWriter);
        IOUtils.closeQuietly((Closeable)fileSource);
        IOUtils.closeQuietly((Closeable)sourceFs);
        IOUtils.closeQuietly((Closeable)destFs);
        return PipeLineExecutor.execute$(this, sourcePath, destPath, engineExecutionContext);
    }

    @Override
    public String Kind() {
        return "csv";
    }

    public CSVExecutor() {
        PipeLineExecutor.$init$(this);
    }
}

