/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.pipeline.executor;

import java.io.Closeable;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.FsWriter;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.manager.engineplugin.pipeline.conf.PipelineEngineConfiguration$;
import org.apache.linkis.manager.engineplugin.pipeline.constant.PipeLineConstant$;
import org.apache.linkis.manager.engineplugin.pipeline.exception.PipeLineErrorException;
import org.apache.linkis.manager.engineplugin.pipeline.executor.ExcelExecutor$;
import org.apache.linkis.manager.engineplugin.pipeline.executor.OutputStreamCache$;
import org.apache.linkis.manager.engineplugin.pipeline.executor.PipeLineExecutor;
import org.apache.linkis.manager.engineplugin.pipeline.executor.PipeLineExecutor$class;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.domain.FsPathListWithError;
import org.apache.linkis.storage.excel.ExcelFsWriter$;
import org.apache.linkis.storage.excel.StorageMultiExcelWriter;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.source.FileSource;
import org.apache.linkis.storage.source.FileSource$;
import scala.Array$;
import scala.Function1;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q3A!\u0001\u0002\u0001#\tiQ\t_2fY\u0016CXmY;u_JT!a\u0001\u0003\u0002\u0011\u0015DXmY;u_JT!!\u0002\u0004\u0002\u0011AL\u0007/\u001a7j]\u0016T!a\u0002\u0005\u0002\u0019\u0015tw-\u001b8fa2,x-\u001b8\u000b\u0005%Q\u0011aB7b]\u0006<WM\u001d\u0006\u0003\u00171\ta\u0001\\5oW&\u001c(BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%a\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007CA\r\u001b\u001b\u0005\u0011\u0011BA\u000e\u0003\u0005A\u0001\u0016\u000e]3MS:,W\t_3dkR|'\u000fC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011\u0011\u0004\u0001\u0005\u0006C\u0001!\tEI\u0001\bKb,7-\u001e;f)\u0011\u00193\u0006\u000e\u001c\u0011\u0005\u0011JS\"A\u0013\u000b\u0005\u0019:\u0013\u0001C3yK\u000e,H/\u001a:\u000b\u0005!R\u0011!C:dQ\u0016$W\u000f\\3s\u0013\tQSEA\bFq\u0016\u001cW\u000f^3SKN\u0004xN\\:f\u0011\u0015a\u0003\u00051\u0001.\u0003)\u0019x.\u001e:dKB\u000bG\u000f\u001b\t\u0003]Er!aE\u0018\n\u0005A\"\u0012A\u0002)sK\u0012,g-\u0003\u00023g\t11\u000b\u001e:j]\u001eT!\u0001\r\u000b\t\u000bU\u0002\u0003\u0019A\u0017\u0002\u0011\u0011,7\u000f\u001e)bi\"DQa\u000e\u0011A\u0002a\nQ#\u001a8hS:,W\t_3dkR|'oQ8oi\u0016DH\u000f\u0005\u0002:\u00016\t!H\u0003\u0002\"w)\u00111\u0001\u0010\u0006\u0003{y\n1bY8naV$\u0018\r^5p]*\u0011qHC\u0001\u000bK:<\u0017N\\3d_:t\u0017BA!;\u0005Y)enZ5oK\u0016CXmY;uS>t7i\u001c8uKb$\b\"B\"\u0001\t\u0003\"\u0015\u0001B&j]\u0012,\u0012!L\u0004\u0006\r\nA\taR\u0001\u000e\u000bb\u001cW\r\\#yK\u000e,Ho\u001c:\u0011\u0005eAe!B\u0001\u0003\u0011\u0003I5C\u0001%\u0013\u0011\u0015i\u0002\n\"\u0001L)\u00059\u0005bB'I\u0005\u0004%\tAT\u0001\u000eKb\u001cW\r\\#yK\u000e,Ho\u001c:\u0016\u0003}Aa\u0001\u0015%!\u0002\u0013y\u0012AD3yG\u0016dW\t_3dkR|'\u000f\t\u0005\u0006%\"#\taU\u0001\fO\u0016$\u0018J\\:uC:\u001cW-F\u0001\u0019\u0001")
public class ExcelExecutor
implements PipeLineExecutor {
    private Map<String, String> options;

    public static PipeLineExecutor getInstance() {
        return ExcelExecutor$.MODULE$.getInstance();
    }

    public static ExcelExecutor excelExecutor() {
        return ExcelExecutor$.MODULE$.excelExecutor();
    }

    @Override
    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public void options_$eq(Map<String, String> x$1) {
        this.options = x$1;
    }

    @Override
    public void init(Map<String, String> newOptions) {
        PipeLineExecutor$class.init(this, newOptions);
    }

    @Override
    public void cleanOptions() {
        PipeLineExecutor$class.cleanOptions(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ExecuteResponse execute(String sourcePath, String destPath, EngineExecutionContext engineExecutorContext) {
        FileSource fileSource = null;
        StorageMultiExcelWriter excelFsWriter = null;
        FsPath sourceFsPath = new FsPath(sourcePath);
        FsPath destFsPath = new FsPath(destPath);
        Fs sourceFs = FSFactory$.MODULE$.getFs(sourceFsPath);
        sourceFs.init(null);
        Fs destFs = FSFactory$.MODULE$.getFs(destFsPath);
        destFs.init(null);
        OutputStream outputStream = destFs.write(destFsPath, BoxesRunTime.unboxToBoolean((Object)PipelineEngineConfiguration$.MODULE$.PIPELINE_OUTPUT_ISOVERWRITE_SWITCH().getValue(this.options())));
        HashMap paramsMap = new HashMap();
        ((IterableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(engineExecutorContext.getProperties()).asScala()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> x$1) {
                return x$1._2() != null;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<String, Object> kv) {
                return new Tuple2(kv._1(), (Object)kv._2().toString());
            }
        }, Map$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, paramsMap){
            public static final long serialVersionUID = 0L;
            private final HashMap paramsMap$1;

            public final String apply(Tuple2<String, String> kv) {
                return (String)this.paramsMap$1.put(kv._1(), kv._2());
            }
            {
                this.paramsMap$1 = paramsMap$1;
            }
        });
        boolean excelAutoFormat = BoxesRunTime.unboxToBoolean((Object)PipelineEngineConfiguration$.MODULE$.EXPORT_EXCEL_AUTO_FORMAT().getValue(paramsMap));
        if (sourcePath.contains(".")) {
            if (!FileSource$.MODULE$.isResultSet(sourcePath)) throw new PipeLineErrorException(70003, "Not a result set file(\u4e0d\u662f\u7ed3\u679c\u96c6\u6587\u4ef6)");
            fileSource = FileSource$.MODULE$.create(sourceFsPath, sourceFs);
            excelFsWriter = ExcelFsWriter$.MODULE$.getExcelFsWriter(PipeLineConstant$.MODULE$.DEFAULTC_HARSET(), PipeLineConstant$.MODULE$.DEFAULT_SHEETNAME(), PipeLineConstant$.MODULE$.DEFAULT_DATEFORMATE(), outputStream, excelAutoFormat);
        } else {
            excelFsWriter = new StorageMultiExcelWriter(outputStream, excelAutoFormat);
            FsPathListWithError fsPathListWithError = ((FileSystem)sourceFs).listPathWithError(sourceFsPath);
            if (fsPathListWithError == null) {
                throw new PipeLineErrorException(70005, "empty dir!");
            }
            fileSource = FileSource$.MODULE$.create((FsPath[])fsPathListWithError.getFsPaths().toArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(FsPath.class))), sourceFs);
        }
        if (!FileSource$.MODULE$.isTableResultSet(fileSource)) throw new PipeLineErrorException(70004, "Only result sets of type Table can be converted to Excel(\u53ea\u6709table\u7c7b\u578b\u7684\u7ed3\u679c\u96c6\u624d\u80fd\u8f6c\u4e3aexcel)");
        String nullValue = this.options().getOrDefault(PipeLineConstant$.MODULE$.PIPELINE_OUTPUT_SHUFFLE_NULL_TYPE(), "NULL");
        if (PipeLineConstant$.MODULE$.BLANK().equalsIgnoreCase(nullValue)) {
            nullValue = "";
        }
        OutputStreamCache$.MODULE$.osCache().put((String)engineExecutorContext.getJobId().get(), outputStream);
        fileSource.addParams("nullValue", nullValue).write((FsWriter)excelFsWriter);
        IOUtils.closeQuietly((Closeable)excelFsWriter);
        IOUtils.closeQuietly((Closeable)fileSource);
        IOUtils.closeQuietly((Closeable)sourceFs);
        IOUtils.closeQuietly((Closeable)destFs);
        return PipeLineExecutor$class.execute(this, sourcePath, destPath, engineExecutorContext);
    }

    @Override
    public String Kind() {
        return "xlsx";
    }

    public ExcelExecutor() {
        PipeLineExecutor$class.$init$(this);
    }
}

