/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.pipeline.executor;

import java.io.Closeable;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.FsWriter;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.manager.engineplugin.pipeline.conf.PipelineEngineConfiguration$;
import org.apache.linkis.manager.engineplugin.pipeline.constant.PipeLineConstant$;
import org.apache.linkis.manager.engineplugin.pipeline.exception.PipeLineErrorException;
import org.apache.linkis.manager.engineplugin.pipeline.executor.CSVExecutor$;
import org.apache.linkis.manager.engineplugin.pipeline.executor.OutputStreamCache$;
import org.apache.linkis.manager.engineplugin.pipeline.executor.PipeLineExecutor;
import org.apache.linkis.manager.engineplugin.pipeline.executor.PipeLineExecutor$class;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.csv.CSVFsWriter;
import org.apache.linkis.storage.csv.CSVFsWriter$;
import org.apache.linkis.storage.source.FileSource;
import org.apache.linkis.storage.source.FileSource$;
import org.apache.linkis.storage.utils.StorageConfiguration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q3A!\u0001\u0002\u0001#\tY1i\u0015,Fq\u0016\u001cW\u000f^8s\u0015\t\u0019A!\u0001\u0005fq\u0016\u001cW\u000f^8s\u0015\t)a!\u0001\u0005qSB,G.\u001b8f\u0015\t9\u0001\"\u0001\u0007f]\u001eLg.\u001a9mk\u001eLgN\u0003\u0002\n\u0015\u00059Q.\u00198bO\u0016\u0014(BA\u0006\r\u0003\u0019a\u0017N\\6jg*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u0019!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fMB\u0011\u0011DG\u0007\u0002\u0005%\u00111D\u0001\u0002\u0011!&\u0004X\rT5oK\u0016CXmY;u_JDQ!\b\u0001\u0005\u0002y\ta\u0001P5oSRtD#A\u0010\u0011\u0005e\u0001\u0001\"B\u0011\u0001\t\u0003\u0012\u0013aB3yK\u000e,H/\u001a\u000b\u0005G-\"d\u0007\u0005\u0002%S5\tQE\u0003\u0002'O\u0005AQ\r_3dkR,'O\u0003\u0002)\u0015\u0005I1o\u00195fIVdWM]\u0005\u0003U\u0015\u0012q\"\u0012=fGV$XMU3ta>t7/\u001a\u0005\u0006Y\u0001\u0002\r!L\u0001\u000bg>,(oY3QCRD\u0007C\u0001\u00182\u001d\t\u0019r&\u0003\u00021)\u00051\u0001K]3eK\u001aL!AM\u001a\u0003\rM#(/\u001b8h\u0015\t\u0001D\u0003C\u00036A\u0001\u0007Q&\u0001\u0005eKN$\b+\u0019;i\u0011\u00159\u0004\u00051\u00019\u0003Y)gnZ5oK\u0016CXmY;uS>t7i\u001c8uKb$\bCA\u001dA\u001b\u0005Q$BA\u0011<\u0015\t\u0019AH\u0003\u0002>}\u0005Y1m\\7qkR\fG/[8o\u0015\ty$\"\u0001\u0006f]\u001eLg.Z2p]:L!!\u0011\u001e\u0003-\u0015sw-\u001b8f\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDQa\u0011\u0001\u0005B\u0011\u000bAaS5oIV\tQfB\u0003G\u0005!\u0005q)A\u0006D'Z+\u00050Z2vi>\u0014\bCA\rI\r\u0015\t!\u0001#\u0001J'\tA%\u0003C\u0003\u001e\u0011\u0012\u00051\nF\u0001H\u0011\u001di\u0005J1A\u0005\u00029\u000b1bY:w\u000bb,7-\u001e;peV\tq\u0004\u0003\u0004Q\u0011\u0002\u0006IaH\u0001\rGN4X\t_3dkR|'\u000f\t\u0005\u0006%\"#\taU\u0001\fO\u0016$\u0018J\\:uC:\u001cW-F\u0001\u0019\u0001")
public class CSVExecutor
implements PipeLineExecutor {
    private Map<String, String> options;

    public static PipeLineExecutor getInstance() {
        return CSVExecutor$.MODULE$.getInstance();
    }

    public static CSVExecutor csvExecutor() {
        return CSVExecutor$.MODULE$.csvExecutor();
    }

    @Override
    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public void options_$eq(Map<String, String> x$1) {
        this.options = x$1;
    }

    @Override
    public void init(Map<String, String> newOptions) {
        PipeLineExecutor$class.init(this, newOptions);
    }

    @Override
    public void cleanOptions() {
        PipeLineExecutor$class.cleanOptions(this);
    }

    @Override
    public ExecuteResponse execute(String sourcePath, String destPath, EngineExecutionContext engineExecutionContext) {
        if (sourcePath.contains((CharSequence)StorageConfiguration$.MODULE$.STORAGE_RS_FILE_SUFFIX().getValue())) {
            if (FileSource$.MODULE$.isResultSet(sourcePath)) {
                FsPath sourceFsPath = new FsPath(sourcePath);
                FsPath destFsPath = new FsPath(destPath);
                Fs sourceFs = FSFactory$.MODULE$.getFs(sourceFsPath);
                sourceFs.init(null);
                Fs destFs = FSFactory$.MODULE$.getFs(destFsPath);
                destFs.init(null);
                FileSource fileSource = FileSource$.MODULE$.create(sourceFsPath, sourceFs);
                if (FileSource$.MODULE$.isTableResultSet(fileSource)) {
                    String nullValue = this.options().getOrDefault(PipeLineConstant$.MODULE$.PIPELINE_OUTPUT_SHUFFLE_NULL_TYPE(), "NULL");
                    if (PipeLineConstant$.MODULE$.BLANK().equalsIgnoreCase(nullValue)) {
                        nullValue = "";
                    }
                    OutputStream outputStream = destFs.write(destFsPath, BoxesRunTime.unboxToBoolean((Object)PipelineEngineConfiguration$.MODULE$.PIPELINE_OUTPUT_ISOVERWRITE_SWITCH().getValue(this.options())));
                    OutputStreamCache$.MODULE$.osCache().put((String)engineExecutionContext.getJobId().get(), outputStream);
                    CSVFsWriter cSVFsWriter = CSVFsWriter$.MODULE$.getCSVFSWriter((String)PipelineEngineConfiguration$.MODULE$.PIPELINE_OUTPUT_CHARSET_STR().getValue(this.options()), (String)PipelineEngineConfiguration$.MODULE$.PIPELINE_FIELD_SPLIT_STR().getValue(this.options()), BoxesRunTime.unboxToBoolean((Object)PipelineEngineConfiguration$.MODULE$.PIPELINE_FIELD_QUOTE_RETOUCH_ENABLE().getValue(this.options())), outputStream);
                    fileSource.addParams("nullValue", nullValue).write((FsWriter)cSVFsWriter);
                    IOUtils.closeQuietly((Closeable)cSVFsWriter);
                    IOUtils.closeQuietly((Closeable)fileSource);
                    IOUtils.closeQuietly((Closeable)sourceFs);
                    IOUtils.closeQuietly((Closeable)destFs);
                    return PipeLineExecutor$class.execute(this, sourcePath, destPath, engineExecutionContext);
                }
                throw new PipeLineErrorException(70002, "Only result sets of type TABLE can be converted to CSV(\u53ea\u6709table\u7c7b\u578b\u7684\u7ed3\u679c\u96c6\u624d\u80fd\u8f6c\u4e3acsv)");
            }
            throw new PipeLineErrorException(70001, "Not a result set file\uff08\u4e0d\u662f\u7ed3\u679c\u96c6\u6587\u4ef6\uff09");
        }
        throw new PipeLineErrorException(70006, "Exporting multiple result sets to CSV is not supported\uff08\u4e0d\u652f\u6301\u591a\u7ed3\u679c\u96c6\u5bfc\u51fa\u4e3aCSV\uff09");
    }

    @Override
    public String Kind() {
        return "csv";
    }

    public CSVExecutor() {
        PipeLineExecutor$class.$init$(this);
    }
}

