/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.ecm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.manager.common.protocol.engine.EngineAskRequest;
import org.apache.linkis.manager.label.entity.engine.ReuseExclusionLabel;
import org.apache.linkis.manager.label.entity.entrance.BindEngineLabel;
import org.apache.linkis.manager.label.entity.entrance.LoadBalanceLabel;
import org.apache.linkis.orchestrator.ecm.ComputationEngineConnManager;
import org.apache.linkis.orchestrator.ecm.LoadBalanceLabelEngineConnManager$;
import org.apache.linkis.orchestrator.ecm.conf.ECMPluginConf$;
import org.apache.linkis.orchestrator.ecm.entity.DefaultMark;
import org.apache.linkis.orchestrator.ecm.entity.LoadBalanceMark;
import org.apache.linkis.orchestrator.ecm.entity.Mark;
import org.apache.linkis.orchestrator.ecm.entity.MarkReq;
import org.apache.linkis.orchestrator.ecm.entity.MarkReq$;
import org.apache.linkis.orchestrator.ecm.entity.Policy;
import org.apache.linkis.orchestrator.ecm.exception.ECMPluginErrorException;
import org.apache.linkis.orchestrator.ecm.service.EngineConnExecutor;
import org.apache.linkis.server.BDPJettyServerHelper$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.BufferLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u0001\u0003\u00015\u0011\u0011\u0005T8bI\n\u000bG.\u00198dK2\u000b'-\u001a7F]\u001eLg.Z\"p]:l\u0015M\\1hKJT!a\u0001\u0003\u0002\u0007\u0015\u001cWN\u0003\u0002\u0006\r\u0005aqN]2iKN$(/\u0019;pe*\u0011q\u0001C\u0001\u0007Y&t7.[:\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001aB\u0005\t\u0003\u001fAi\u0011AA\u0005\u0003#\t\u0011AdQ8naV$\u0018\r^5p]\u0016sw-\u001b8f\u0007>tg.T1oC\u001e,'\u000f\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u0005)Q\u000f^5mg*\u0011qCB\u0001\u0007G>lWn\u001c8\n\u0005e!\"a\u0002'pO\u001eLgn\u001a\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"a\u0004\u0001\t\u000f}\u0001!\u0019!C\u0005A\u0005\u0019R.\u0019:l%\u0016\f\u0018I\u001c3NCJ\\7)Y2iKV\t\u0011\u0005\u0005\u0003#O%zS\"A\u0012\u000b\u0005\u0011*\u0013\u0001B;uS2T\u0011AJ\u0001\u0005U\u00064\u0018-\u0003\u0002)G\t9\u0001*Y:i\u001b\u0006\u0004\bC\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u0003\u0003\u0019)g\u000e^5us&\u0011af\u000b\u0002\b\u001b\u0006\u00148NU3r!\r\u0011\u0003GM\u0005\u0003c\r\u0012A\u0001T5tiB\u0011!fM\u0005\u0003i-\u0012A!T1sW\"1a\u0007\u0001Q\u0001\n\u0005\nA#\\1sWJ+\u0017/\u00118e\u001b\u0006\u00148nQ1dQ\u0016\u0004\u0003b\u0002\u001d\u0001\u0005\u0004%I!O\u0001\u000eS\u0012$v.T1sW\u000e\u000b7\r[3\u0016\u0003i\u0002BAI\u0014<eA\u0011AH\u0011\b\u0003{\u0001k\u0011A\u0010\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011IP\u0001\u0007!J,G-\u001a4\n\u0005\r#%AB*ue&twM\u0003\u0002B}!1a\t\u0001Q\u0001\ni\na\"\u001b3U_6\u000b'o[\"bG\",\u0007\u0005C\u0003I\u0001\u0011%\u0011*\u0001\fhKRl\u0015M]6SKF\fe\u000eZ'be.\u001c\u0015m\u00195f)\u0005Q\u0005\u0003\u0002\u0012LS=J!\u0001T\u0012\u0003\u00075\u000b\u0007\u000fC\u0003O\u0001\u0011%q*\u0001\thKRLE\rV8NCJ\\7)Y2iKR\t\u0001\u000b\u0005\u0003#\u0017n\u0012\u0004b\u0002*\u0001\u0005\u0004%IaU\u0001\u0016\u001b\u0006\u00136j\u0018*F#~\u001b\u0015i\u0011%F?2{5iS#S+\u0005!\u0006CA+Y\u001b\u00051&BA,&\u0003\u0011a\u0017M\\4\n\u0005e3&AB(cU\u0016\u001cG\u000f\u0003\u0004\\\u0001\u0001\u0006I\u0001V\u0001\u0017\u001b\u0006\u00136j\u0018*F#~\u001b\u0015i\u0011%F?2{5iS#SA!)Q\f\u0001C\u0005=\u0006\u0011r-\u001a;NCJ\\g*^7Cs6\u000b'OU3r)\ty&\r\u0005\u0002>A&\u0011\u0011M\u0010\u0002\u0004\u0013:$\b\"B2]\u0001\u0004I\u0013aB7be.\u0014V-\u001d\u0005\u0006K\u0002!\tEZ\u0001\nCB\u0004H._'be.$\"AM4\t\u000b\r$\u0007\u0019A\u0015\t\u000b%\u0004A\u0011\t6\u0002\u0015\r\u0014X-\u0019;f\u001b\u0006\u00148\u000e\u0006\u00023W\")1\r\u001ba\u0001S!)Q\u000e\u0001C\u0005]\u0006\t\u0012\r\u001a3NCJ\\'+Z9B]\u0012l\u0015M]6\u0015\u0007=\u0014H\u000f\u0005\u0002>a&\u0011\u0011O\u0010\u0002\u0005+:LG\u000fC\u0003tY\u0002\u0007\u0011&A\u0002sKFDQ!\u001e7A\u0002Y\fA!\\1sWB\u0011!f^\u0005\u0003q.\u00121\u0002R3gCVdG/T1sW\")!\u0010\u0001C!w\u0006qr-\u001a;Bm\u0006LG.\u00192mK\u0016sw-\u001b8f\u0007>tg.\u0012=fGV$xN\u001d\u000b\u0004y\u0006\u0015\u0001cA?\u0002\u00025\taP\u0003\u0002\u0000\u0005\u000591/\u001a:wS\u000e,\u0017bAA\u0002}\n\u0011RI\\4j]\u0016\u001cuN\u001c8Fq\u0016\u001cW\u000f^8s\u0011\u0015)\u0018\u00101\u00013\u0011\u001d\tI\u0001\u0001C!\u0003\u0017\t\u0011D]3mK\u0006\u001cX-\u00128hS:,7i\u001c8o\u000bb,7-\u001e;peR)q.!\u0004\u0002\u0012!9\u0011qBA\u0004\u0001\u0004a\u0018AE3oO&tWmQ8o]\u0016CXmY;u_JDa!^A\u0004\u0001\u0004\u0011\u0004bBA\u000b\u0001\u0011%\u0011qC\u0001\u001ee\u0016dW-Y:f\u001b\u0006\u00148.\u00118e'\u0016\u0014h/[2f\u0013:\u001cH/\u00198dKR)q.!\u0007\u0002\u001c!1Q/a\u0005A\u0002IB\u0001\"!\b\u0002\u0014\u0001\u0007\u0011qD\u0001\u0010g\u0016\u0014h/[2f\u0013:\u001cH/\u00198dKB!\u0011\u0011EA\u0012\u001b\u00051\u0012bAA\u0013-\ty1+\u001a:wS\u000e,\u0017J\\:uC:\u001cW\rC\u0004\u0002*\u0001!\t\"a\u000b\u0002\u001f\u001d,G/\u00117m\u0013:\u001cH/\u00198dKN$\"!!\f\u0011\tu\nycO\u0005\u0004\u0003cq$!B!se\u0006L\bbBA\u001b\u0001\u0011\u0005\u0013qG\u0001\nO\u0016$\bk\u001c7jGf$\"!!\u000f\u0011\u0007)\nY$C\u0002\u0002>-\u0012a\u0001U8mS\u000eL\b")
public class LoadBalanceLabelEngineConnManager
extends ComputationEngineConnManager {
    private final HashMap<MarkReq, List<Mark>> markReqAndMarkCache = new HashMap();
    private final HashMap<String, Mark> idToMarkCache = new HashMap();
    private final Object MARK_REQ_CACHE_LOCKER = new Object();

    private HashMap<MarkReq, List<Mark>> markReqAndMarkCache() {
        return this.markReqAndMarkCache;
    }

    private HashMap<String, Mark> idToMarkCache() {
        return this.idToMarkCache;
    }

    private Map<MarkReq, List<Mark>> getMarkReqAndMarkCache() {
        return this.markReqAndMarkCache();
    }

    private Map<String, Mark> getIdToMarkCache() {
        return this.idToMarkCache();
    }

    private Object MARK_REQ_CACHE_LOCKER() {
        return this.MARK_REQ_CACHE_LOCKER;
    }

    private int getMarkNumByMarReq(MarkReq markReq) {
        int n;
        if (markReq.getLabels().containsKey("loadBalance")) {
            LoadBalanceLabel loadBalanceLabel = (LoadBalanceLabel)MarkReq$.MODULE$.getLabelBuilderFactory().createLabel("loadBalance", markReq.getLabels().get("loadBalance"));
            n = Predef$.MODULE$.Integer2int(loadBalanceLabel.getCapacity()) > 0 ? Predef$.MODULE$.Integer2int(loadBalanceLabel.getCapacity()) : BoxesRunTime.unboxToInt((Object)ECMPluginConf$.MODULE$.DEFAULT_LOADBALANCE_CAPACITY().getValue());
        } else {
            this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There must be LoadBalanceLabel in markReq : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BDPJettyServerHelper$.MODULE$.gson().toJson((Object)markReq)})));
            n = BoxesRunTime.unboxToInt((Object)ECMPluginConf$.MODULE$.DEFAULT_LOADBALANCE_CAPACITY().getValue());
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Mark applyMark(MarkReq markReq) {
        Mark mark;
        Object object;
        if (markReq == null) {
            return null;
        }
        int markNum = this.getMarkNumByMarReq(markReq);
        int count = 0;
        if (this.getMarkReqAndMarkCache().containsKey(markReq)) {
            count = this.getMarkReqAndMarkCache().get(markReq).size();
        }
        while (count < markNum) {
            this.createMark(markReq);
            count = this.getMarkReqAndMarkCache().get(markReq).size();
        }
        List<Mark> markList = this.getMarkReqAndMarkCache().get(markReq);
        Mark chooseMark = null;
        if (!markReq.getLabels().containsKey("bindEngine")) {
            chooseMark = markList.get(new Random().nextInt(count));
            object = BoxedUnit.UNIT;
            return chooseMark;
        }
        BindEngineLabel bindEngineLabel = (BindEngineLabel)MarkReq$.MODULE$.getLabelBuilderFactory().createLabel("bindEngine", markReq.getLabels().get("bindEngine"));
        if (bindEngineLabel.getIsJobGroupHead()) {
            chooseMark = markList.get(new Random().nextInt(((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(markList).asScala()).length()));
            mark = this.getIdToMarkCache().put(bindEngineLabel.getJobGroupId(), chooseMark);
        } else {
            if (!this.getIdToMarkCache().containsKey(bindEngineLabel.getJobGroupId())) {
                String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find mark", " related to bindEngineLabel : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{chooseMark.getMarkId(), bindEngineLabel.getStringValue()}));
                this.logger().error(msg);
                throw new ECMPluginErrorException(ECMPluginConf$.MODULE$.ECM_MARK_CACHE_ERROR_CODE(), msg);
            }
            chooseMark = this.getIdToMarkCache().get(bindEngineLabel.getJobGroupId());
            List<ServiceInstance> insList = this.getMarkCache().get(chooseMark);
            if (insList == null || insList.size() != 1) {
                String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Engine instance releated to chooseMark : ", " with bindEngineLabel : ", " cannot be null"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BDPJettyServerHelper$.MODULE$.gson().toJson((Object)chooseMark), bindEngineLabel.getStringValue()}));
                this.logger().error(msg);
                throw new ECMPluginErrorException(ECMPluginConf$.MODULE$.ECM_MARK_CACHE_ERROR_CODE(), msg);
            }
            mark = BoxedUnit.UNIT;
        }
        if (!bindEngineLabel.getIsJobGroupEnd()) {
            object = BoxedUnit.UNIT;
            return chooseMark;
        }
        if (this.getIdToMarkCache().containsKey(bindEngineLabel.getJobGroupId())) {
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start to remove mark", " Cache ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{chooseMark.getMarkId(), bindEngineLabel.getStringValue()})));
            object = this.getIdToMarkCache().remove(bindEngineLabel.getJobGroupId());
            return chooseMark;
        }
        this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find mark", " related to bindEngineLabel : ", ", cannot remove it."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{chooseMark.getMarkId(), bindEngineLabel.getStringValue()})));
        object = BoxedUnit.UNIT;
        return chooseMark;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Mark createMark(MarkReq markReq) {
        void var2_2;
        LoadBalanceMark mark = new LoadBalanceMark(this.nextMarkId(), markReq);
        this.addMark(mark, new ArrayList<ServiceInstance>());
        this.addMarkReqAndMark(markReq, mark);
        return var2_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addMarkReqAndMark(MarkReq req, DefaultMark mark) {
        if (req == null) return;
        Object object = this.MARK_REQ_CACHE_LOCKER();
        synchronized (object) {
            Object object2;
            List<Mark> markList = this.getMarkReqAndMarkCache().get(req);
            if (markList == null) {
                ArrayList<DefaultMark> markList2 = new ArrayList<DefaultMark>();
                markList2.add(mark);
                object2 = this.getMarkReqAndMarkCache().put(req, markList2);
            } else {
                Mark mayBeMark = (Mark)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(markList).asScala()).find((Function1)new Serializable(this, mark){
                    public static final long serialVersionUID = 0L;
                    private final DefaultMark mark$1;

                    public final boolean apply(Mark x$1) {
                        return x$1.getMarkId().equals(this.mark$1.getMarkId());
                    }
                    {
                        this.mark$1 = mark$1;
                    }
                }).orNull(Predef$.MODULE$.$conforms());
                object2 = mayBeMark == null ? BoxesRunTime.boxToBoolean((boolean)markList.add(mark)) : BoxedUnit.UNIT;
            }
            return;
        }
    }

    @Override
    public EngineConnExecutor getAvailableEngineConnExecutor(Mark mark) {
        if (mark != null && this.getMarkCache().containsKey(mark)) {
            Option<EngineConnExecutor> option = this.tryReuseEngineConnExecutor(mark);
            if (option instanceof Some) {
                Some some = (Some)option;
                EngineConnExecutor engineConnExecutor = (EngineConnExecutor)some.x();
                this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mark ", " ReuseEngineConnExecutor ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mark.getMarkId(), engineConnExecutor})));
                return engineConnExecutor;
            }
            if (None$.MODULE$.equals(option)) {
                Object object;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mark ", " start to askEngineConnExecutor"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mark.getMarkId()})));
                EngineAskRequest engineConnAskReq = mark.getMarkReq().createEngineConnAskReq();
                String[] existInstances = this.getAllInstances();
                if (existInstances != null && Predef$.MODULE$.refArrayOps((Object[])existInstances).nonEmpty()) {
                    ReuseExclusionLabel reuseExclusionLabel = (ReuseExclusionLabel)MarkReq$.MODULE$.getLabelBuilderFactory().createLabel(ReuseExclusionLabel.class);
                    reuseExclusionLabel.setInstances(Predef$.MODULE$.refArrayOps((Object[])existInstances).mkString(";"));
                    object = engineConnAskReq.getLabels().put("reuseExclusion", reuseExclusionLabel.getValue());
                } else {
                    object = BoxedUnit.UNIT;
                }
                EngineConnExecutor engineConnExecutor = this.askEngineConnExecutor(engineConnAskReq, mark);
                this.saveToMarkCache(mark, engineConnExecutor);
                this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mark ", " Finished to  getAvailableEngineConnExecutor by create"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mark.getMarkId()})));
                return engineConnExecutor;
            }
            throw new MatchError(option);
        }
        throw new ECMPluginErrorException(ECMPluginConf$.MODULE$.ECM_ERROR_CODE(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mark cannot be null"})).s((Seq)Nil$.MODULE$));
    }

    @Override
    public void releaseEngineConnExecutor(EngineConnExecutor engineConnExecutor, Mark mark) {
        if (engineConnExecutor != null && mark != null && this.getMarkCache().containsKey(mark)) {
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start to release EngineConnExecutor mark id ", " engineConnExecutor ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mark.getMarkId(), engineConnExecutor.getServiceInstance()})));
            this.getEngineConnExecutorCache().remove(engineConnExecutor.getServiceInstance());
            engineConnExecutor.close();
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Start to release all mark relation to serviceInstance ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{engineConnExecutor.getServiceInstance()})));
            Predef$.MODULE$.refArrayOps((Object[])this.getMarksByInstance(engineConnExecutor.getServiceInstance())).foreach((Function1)new Serializable(this, engineConnExecutor){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LoadBalanceLabelEngineConnManager $outer;
                private final EngineConnExecutor engineConnExecutor$1;

                public final void apply(Mark x$2) {
                    this.$outer.org$apache$linkis$orchestrator$ecm$LoadBalanceLabelEngineConnManager$$releaseMarkAndServiceInstance(x$2, this.engineConnExecutor$1.getServiceInstance());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.engineConnExecutor$1 = engineConnExecutor$1;
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void org$apache$linkis$orchestrator$ecm$LoadBalanceLabelEngineConnManager$$releaseMarkAndServiceInstance(Mark mark, ServiceInstance serviceInstance) {
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Start to release mark", " relation to serviceInstance ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mark.getMarkId(), serviceInstance})));
        List<ServiceInstance> instances = this.getInstances(mark);
        if (instances != null) {
            instances.remove(serviceInstance);
            if (instances.isEmpty()) {
                this.releaseMark(mark);
            }
        }
        if (this.getMarkCache().containsKey(mark)) return;
        Object object = this.MARK_REQ_CACHE_LOCKER();
        synchronized (object) {
            Buffer newMarks;
            List<Mark> marks = this.getMarkReqAndMarkCache().get(mark.getMarkReq());
            List<Mark> list = marks == null || marks.isEmpty() ? this.getMarkReqAndMarkCache().remove(mark.getMarkReq()) : ((newMarks = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(marks).asScala()).filter((Function1)new Serializable(this, mark){
                public static final long serialVersionUID = 0L;
                private final Mark mark$2;

                public final boolean apply(Mark x$3) {
                    return !x$3.getMarkId().equals(this.mark$2.getMarkId());
                }
                {
                    this.mark$2 = mark$2;
                }
            })) == null || newMarks.isEmpty() ? this.getMarkReqAndMarkCache().remove(mark.getMarkReq()) : this.getMarkReqAndMarkCache().put(mark.getMarkReq(), (List<Mark>)JavaConverters$.MODULE$.bufferAsJavaListConverter(newMarks).asJava()));
            return;
        }
    }

    public String[] getAllInstances() {
        ArrayBuffer instances = new ArrayBuffer();
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.getMarkCache().values()).asScala()).foreach((Function1)new Serializable(this, instances){
            public static final long serialVersionUID = 0L;
            public final ArrayBuffer instances$1;

            public final void apply(List<ServiceInstance> x$4) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$4).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getAllInstances$1 $outer;

                    public final void apply(ServiceInstance s) {
                        this.$outer.instances$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{s.getInstance()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.instances$1 = instances$1;
            }
        });
        return (String[])instances.toArray(ClassTag$.MODULE$.apply(String.class));
    }

    @Override
    public Policy getPolicy() {
        return Policy.Label;
    }
}

