/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.ecm;

import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.exception.LinkisRetryException;
import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf$;
import org.apache.linkis.manager.common.entity.node.EngineNode;
import org.apache.linkis.manager.common.protocol.engine.EngineAskAsyncResponse;
import org.apache.linkis.manager.common.protocol.engine.EngineAskRequest;
import org.apache.linkis.manager.common.protocol.engine.EngineAsyncResponse;
import org.apache.linkis.manager.common.protocol.engine.EngineCreateError;
import org.apache.linkis.manager.common.protocol.engine.EngineCreateSuccess;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.orchestrator.ecm.AbstractEngineConnManager;
import org.apache.linkis.orchestrator.ecm.cache.EngineAsyncResponseCache;
import org.apache.linkis.orchestrator.ecm.cache.EngineAsyncResponseCache$;
import org.apache.linkis.orchestrator.ecm.conf.ECMPluginConf$;
import org.apache.linkis.orchestrator.ecm.entity.DefaultMark;
import org.apache.linkis.orchestrator.ecm.entity.Mark;
import org.apache.linkis.orchestrator.ecm.entity.MarkReq;
import org.apache.linkis.orchestrator.ecm.entity.Policy;
import org.apache.linkis.orchestrator.ecm.exception.ECMPluginErrorException;
import org.apache.linkis.orchestrator.ecm.service.EngineConnExecutor;
import org.apache.linkis.orchestrator.ecm.service.impl.ComputationConcurrentEngineConnExecutor;
import org.apache.linkis.orchestrator.ecm.service.impl.ComputationEngineConnExecutor;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.Sender$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u00015\u0011AdQ8naV$\u0018\r^5p]\u0016sw-\u001b8f\u0007>tg.T1oC\u001e,'O\u0003\u0002\u0004\t\u0005\u0019QmY7\u000b\u0005\u00151\u0011\u0001D8sG\",7\u000f\u001e:bi>\u0014(BA\u0004\t\u0003\u0019a\u0017N\\6jg*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0013!\ty\u0001#D\u0001\u0003\u0013\t\t\"AA\rBEN$(/Y2u\u000b:<\u0017N\\3D_:tW*\u00198bO\u0016\u0014\bCA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0015)H/\u001b7t\u0015\t9b!\u0001\u0004d_6lwN\\\u0005\u00033Q\u0011q\u0001T8hO&tw\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011q\u0002\u0001\u0005\b?\u0001\u0011\r\u0011\"\u0003!\u0003%IGm\u0011:fCR|'/F\u0001\"!\t\u00113&D\u0001$\u0015\t!S%\u0001\u0004bi>l\u0017n\u0019\u0006\u0003M\u001d\n!bY8oGV\u0014(/\u001a8u\u0015\tA\u0013&\u0001\u0003vi&d'\"\u0001\u0016\u0002\t)\fg/Y\u0005\u0003Y\r\u0012Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\bB\u0002\u0018\u0001A\u0003%\u0011%\u0001\u0006jI\u000e\u0013X-\u0019;pe\u0002Bq\u0001\r\u0001C\u0002\u0013%\u0011'\u0001\u0005dC\u000eDW-T1q+\u0005\u0011\u0004CA\u001a7\u001b\u0005!$BA\u001b\u0003\u0003\u0015\u0019\u0017m\u00195f\u0013\t9DG\u0001\rF]\u001eLg.Z!ts:\u001c'+Z:q_:\u001cXmQ1dQ\u0016Da!\u000f\u0001!\u0002\u0013\u0011\u0014!C2bG\",W*\u00199!\u0011\u0015Y\u0004\u0001\"\u0011=\u0003%9W\r\u001e)pY&\u001c\u0017\u0010F\u0001>!\tq\u0014)D\u0001@\u0015\t\u0001%!\u0001\u0004f]RLG/_\u0005\u0003\u0005~\u0012a\u0001U8mS\u000eL\b\"\u0002#\u0001\t\u0003*\u0015!C1qa2LX*\u0019:l)\t1\u0015\n\u0005\u0002?\u000f&\u0011\u0001j\u0010\u0002\u0005\u001b\u0006\u00148\u000eC\u0003K\u0007\u0002\u00071*A\u0004nCJ\\'+Z9\u0011\u0005yb\u0015BA'@\u0005\u001di\u0015M]6SKFDQa\u0014\u0001\u0005BA\u000b!b\u0019:fCR,W*\u0019:l)\t1\u0015\u000bC\u0003K\u001d\u0002\u00071\nC\u0003T\u0001\u0011EA+\u0001\u0006oKb$X*\u0019:l\u0013\u0012$\u0012!\u0016\t\u0003-rs!a\u0016.\u000e\u0003aS\u0011!W\u0001\u0006g\u000e\fG.Y\u0005\u00037b\u000ba\u0001\u0015:fI\u00164\u0017BA/_\u0005\u0019\u0019FO]5oO*\u00111\f\u0017\u0005\u0006A\u0002!\t&Y\u0001\u0016CN\\WI\\4j]\u0016\u001cuN\u001c8Fq\u0016\u001cW\u000f^8s)\r\u0011\u0007.\u001e\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K\n\tqa]3sm&\u001cW-\u0003\u0002hI\n\u0011RI\\4j]\u0016\u001cuN\u001c8Fq\u0016\u001cW\u000f^8s\u0011\u0015Iw\f1\u0001k\u0003A)gnZ5oK\u0006\u001b8NU3rk\u0016\u001cH\u000f\u0005\u0002lg6\tAN\u0003\u0002n]\u00061QM\\4j]\u0016T!a\u001c9\u0002\u0011A\u0014x\u000e^8d_2T!aF9\u000b\u0005I4\u0011aB7b]\u0006<WM]\u0005\u0003i2\u0014\u0001#\u00128hS:,\u0017i]6SKF,Xm\u001d;\t\u000bY|\u0006\u0019\u0001$\u0002\t5\f'o\u001b\u0005\u0006q\u0002!I!_\u0001\u0018O\u0016$XI\\4j]\u0016tu\u000eZ3Bg.l\u0015M\\1hKJ$RA_A\b\u0003#\u0001RaV>~\u0003\u0013I!\u0001 -\u0003\rQ+\b\u000f\\33!\rq\u0018QA\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\u0011qw\u000eZ3\u000b\u0005\u0001\u0003\u0018bAA\u0004\u007f\nQQI\\4j]\u0016tu\u000eZ3\u0011\u0007]\u000bY!C\u0002\u0002\u000ea\u0013qAQ8pY\u0016\fg\u000eC\u0003jo\u0002\u0007!\u000eC\u0003wo\u0002\u0007a\tC\u0004\u0002\u0016\u0001!I!a\u0006\u0002!\u001d,G/T1oC\u001e,'oU3oI\u0016\u0014HCAA\r!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010\r\u0005\u0019!\u000f]2\n\t\u0005\r\u0012Q\u0004\u0002\u0007'\u0016tG-\u001a:")
public class ComputationEngineConnManager
extends AbstractEngineConnManager {
    private final AtomicInteger idCreator = new AtomicInteger();
    private final EngineAsyncResponseCache cacheMap = EngineAsyncResponseCache$.MODULE$.getCache();

    private AtomicInteger idCreator() {
        return this.idCreator;
    }

    private EngineAsyncResponseCache cacheMap() {
        return this.cacheMap;
    }

    @Override
    public Policy getPolicy() {
        return Policy.Process;
    }

    @Override
    public Mark applyMark(MarkReq markReq) {
        if (markReq == null) {
            return null;
        }
        return this.createMark(markReq);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Mark createMark(MarkReq markReq) {
        void var2_2;
        DefaultMark mark = new DefaultMark(this.nextMarkId(), markReq);
        this.addMark(mark, new ArrayList<ServiceInstance>());
        return var2_2;
    }

    public String nextMarkId() {
        return new StringBuilder().append((Object)"mark_").append((Object)BoxesRunTime.boxToInteger((int)this.idCreator().getAndIncrement())).toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EngineConnExecutor askEngineConnExecutor(EngineAskRequest engineAskRequest, Mark mark) {
        int count;
        engineAskRequest.setTimeOut(this.getEngineConnApplyTime());
        LinkisRetryException retryException = null;
        for (count = this.getEngineConnApplyAttempts(); count >= 1; --count) {
            long start = System.currentTimeMillis();
            try {
                ComputationEngineConnExecutor engineConnExecutor;
                Tuple2 tuple2;
                Tuple2<EngineNode, Object> tuple22 = this.getEngineNodeAskManager(engineAskRequest, mark);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                EngineNode engineNode = (EngineNode)tuple22._1();
                boolean reuse = tuple22._2$mcZ$sp();
                Tuple2 tuple23 = tuple2 = new Tuple2((Object)engineNode, (Object)BoxesRunTime.boxToBoolean((boolean)reuse));
                EngineNode engineNode2 = (EngineNode)tuple23._1();
                boolean reuse2 = tuple23._2$mcZ$sp();
                if (engineNode2 == null) continue;
                ComputationEngineConnExecutor computationEngineConnExecutor = engineConnExecutor = engineAskRequest.getLabels() != null && engineAskRequest.getLabels().containsKey("concurrentEngineConn") ? new ComputationConcurrentEngineConnExecutor(engineNode2, this.getParallelism()) : new ComputationEngineConnExecutor(engineNode2);
                if (engineNode2.getLabels() != null) {
                    engineConnExecutor.setLabels((Label[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(engineNode2.getLabels()).asScala()).toList().toArray(ClassTag$.MODULE$.apply(Label.class)));
                }
                engineConnExecutor.setReuse(reuse2);
                return engineConnExecutor;
            }
            catch (Throwable throwable) {
                String taken = ByteTimeUtils.msDurationToString((long)(System.currentTimeMillis() - start));
                this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Failed to askEngineAskRequest time taken (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mark.getMarkId(), taken})));
                throw throwable;
            }
        }
        if (retryException == null) {
            throw new ECMPluginErrorException(ECMPluginConf$.MODULE$.ECM_ERROR_CODE(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Failed to ask engineAskRequest ", " by retry ", "  "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mark.getMarkId(), engineAskRequest, BoxesRunTime.boxToInteger((int)(this.getEngineConnApplyAttempts() - count))})));
        }
        throw retryException;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2<EngineNode, Object> getEngineNodeAskManager(EngineAskRequest engineAskRequest, Mark mark) {
        Object response = Utils$.MODULE$.tryCatch((Function0)new Serializable(this, engineAskRequest){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ComputationEngineConnManager $outer;
            private final EngineAskRequest engineAskRequest$1;

            public final Object apply() {
                return this.$outer.org$apache$linkis$orchestrator$ecm$ComputationEngineConnManager$$getManagerSender().ask((Object)this.engineAskRequest$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.engineAskRequest$1 = engineAskRequest$1;
            }
        }, (Function1)new Serializable(this, mark){
            public static final long serialVersionUID = 0L;
            private final Mark mark$1;

            public final Object apply(Throwable t) {
                String baseMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mark ", "  failed to ask linkis Manager Can be retried "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.mark$1.getMarkId()}));
                Throwable throwable = ExceptionUtils.getRootCause((Throwable)t);
                if (throwable instanceof SocketTimeoutException) {
                    SocketTimeoutException socketTimeoutException = (SocketTimeoutException)throwable;
                    String msg = new StringBuilder().append((Object)baseMsg).append((Object)ExceptionUtils.getMessage((Throwable)socketTimeoutException)).toString();
                    throw new LinkisRetryException(ECMPluginConf$.MODULE$.ECM_ENGNE_CREATION_ERROR_CODE(), msg);
                }
                if (throwable instanceof SocketException) {
                    SocketException socketException = (SocketException)throwable;
                    String msg = new StringBuilder().append((Object)baseMsg).append((Object)ExceptionUtils.getMessage((Throwable)socketException)).toString();
                    throw new LinkisRetryException(ECMPluginConf$.MODULE$.ECM_ENGNE_CREATION_ERROR_CODE(), msg);
                }
                throw t;
            }
            {
                this.mark$1 = mark$1;
            }
        });
        Object object = response;
        if (object instanceof EngineNode) {
            EngineNode engineNode = (EngineNode)object;
            this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Succeed to reuse engineNode ", " mark ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{engineNode, mark.getMarkId()})));
            return new Tuple2((Object)engineNode, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        if (object instanceof EngineAskAsyncResponse) {
            EngineAskAsyncResponse engineAskAsyncResponse = (EngineAskAsyncResponse)object;
            String id = engineAskAsyncResponse.id();
            ServiceInstance serviceInstance = engineAskAsyncResponse.managerInstance();
            this.logger().info("{} received EngineAskAsyncResponse id: {} serviceInstance: {}", new Object[]{mark.getMarkId(), id, serviceInstance});
            EngineAsyncResponse engineAsyncResponse = this.cacheMap().getAndRemove(id, (Duration)Duration$.MODULE$.apply(engineAskRequest.getTimeOut() + 100000L, TimeUnit.MILLISECONDS));
            if (engineAsyncResponse instanceof EngineCreateSuccess) {
                EngineCreateSuccess engineCreateSuccess = (EngineCreateSuccess)engineAsyncResponse;
                String id2 = engineCreateSuccess.id();
                EngineNode engineNode = engineCreateSuccess.engineNode();
                this.logger().info("{} async id: {} success to async get EngineNode {}", new Object[]{mark.getMarkId(), id2, engineNode});
                Tuple2 tuple2 = new Tuple2((Object)engineNode, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                return tuple2;
            }
            if (!(engineAsyncResponse instanceof EngineCreateError)) throw new MatchError((Object)engineAsyncResponse);
            EngineCreateError engineCreateError = (EngineCreateError)engineAsyncResponse;
            String id3 = engineCreateError.id();
            String exception = engineCreateError.exception();
            boolean retry = engineCreateError.retry();
            this.logger().debug("{} async id: {} Failed  to async get EngineNode, {}", (Object[])new String[]{mark.getMarkId(), id3, exception});
            if (!retry) throw new ECMPluginErrorException(ECMPluginConf$.MODULE$.ECM_ENGNE_CREATION_ERROR_CODE(), new StringBuilder().append((Object)id3).append((Object)" Failed  to async get EngineNode ").append((Object)exception).toString());
            throw new LinkisRetryException(ECMPluginConf$.MODULE$.ECM_ENGNE_CREATION_ERROR_CODE(), new StringBuilder().append((Object)id3).append((Object)" Failed  to async get EngineNode ").append((Object)exception).toString());
        }
        this.logger().info("{} Failed to ask engineAskRequest {}, response is not engineNode", (Object)mark.getMarkId(), (Object)engineAskRequest);
        return new Tuple2(null, (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public Sender org$apache$linkis$orchestrator$ecm$ComputationEngineConnManager$$getManagerSender() {
        return Sender$.MODULE$.getSender((String)GovernanceCommonConf$.MODULE$.MANAGER_SERVICE_NAME().getValue());
    }
}

