/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.computation.service;

import javax.annotation.PostConstruct;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.governance.common.entity.ExecutionNodeStatus;
import org.apache.linkis.governance.common.protocol.task.ResponseTaskError;
import org.apache.linkis.governance.common.protocol.task.ResponseTaskLog;
import org.apache.linkis.governance.common.protocol.task.ResponseTaskResultSet;
import org.apache.linkis.governance.common.protocol.task.ResponseTaskResultSize;
import org.apache.linkis.governance.common.protocol.task.ResponseTaskStatus;
import org.apache.linkis.manager.common.protocol.resource.ResponseTaskRunningInfo;
import org.apache.linkis.orchestrator.computation.conf.ComputationOrchestratorConf$;
import org.apache.linkis.orchestrator.computation.execute.CodeExecTaskExecutor;
import org.apache.linkis.orchestrator.computation.execute.CodeExecTaskExecutorManager;
import org.apache.linkis.orchestrator.computation.execute.CodeExecTaskExecutorManager$;
import org.apache.linkis.orchestrator.computation.monitor.EngineConnMonitor$;
import org.apache.linkis.orchestrator.core.ResultSet;
import org.apache.linkis.orchestrator.ecm.service.TaskExecutionReceiver;
import org.apache.linkis.orchestrator.listener.task.TaskErrorResponseEvent;
import org.apache.linkis.orchestrator.listener.task.TaskLogEvent;
import org.apache.linkis.orchestrator.listener.task.TaskResultSetEvent;
import org.apache.linkis.orchestrator.listener.task.TaskResultSetSizeEvent;
import org.apache.linkis.orchestrator.listener.task.TaskRunningInfoEvent;
import org.apache.linkis.orchestrator.listener.task.TaskStatusEvent;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.message.annotation.Receiver;
import org.apache.linkis.rpc.utils.RPCUtils$;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;

@Service
@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u0001=\u0011\u0001eQ8naV$\u0018\r^5p]R\u000b7o[#yK\u000e,H/[8o%\u0016\u001cW-\u001b<fe*\u00111\u0001B\u0001\bg\u0016\u0014h/[2f\u0015\t)a!A\u0006d_6\u0004X\u000f^1uS>t'BA\u0004\t\u00031y'o\u00195fgR\u0014\u0018\r^8s\u0015\tI!\"\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001b#\b\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]YR\"\u0001\r\u000b\u0005\rI\"B\u0001\u000e\u0007\u0003\r)7-\\\u0005\u00039a\u0011Q\u0003V1tW\u0016CXmY;uS>t'+Z2fSZ,'\u000f\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u0005)Q\u000f^5mg*\u0011!\u0005C\u0001\u0007G>lWn\u001c8\n\u0005\u0011z\"a\u0002'pO\u001eLgn\u001a\u0005\u0006M\u0001!\taJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"!\u000b\u0001\u000e\u0003\tAqa\u000b\u0001C\u0002\u0013%A&A\u000ed_\u0012,W\t_3d)\u0006\u001c8.\u0012=fGV$xN]'b]\u0006<WM]\u000b\u0002[A\u0011a&M\u0007\u0002_)\u0011\u0001\u0007B\u0001\bKb,7-\u001e;f\u0013\t\u0011tFA\u000eD_\u0012,W\t_3d)\u0006\u001c8.\u0012=fGV$xN]'b]\u0006<WM\u001d\u0005\u0007i\u0001\u0001\u000b\u0011B\u0017\u00029\r|G-Z#yK\u000e$\u0016m]6Fq\u0016\u001cW\u000f^8s\u001b\u0006t\u0017mZ3sA!)a\u0007\u0001C\u0005o\u0005!\u0011N\\5u)\u0005A\u0004CA\t:\u0013\tQ$C\u0001\u0003V]&$\bFA\u001b=!\ti$)D\u0001?\u0015\ty\u0004)\u0001\u0006b]:|G/\u0019;j_:T\u0011!Q\u0001\u0006U\u00064\u0018\r_\u0005\u0003\u0007z\u0012Q\u0002U8ti\u000e{gn\u001d;sk\u000e$\b\"B#\u0001\t\u00032\u0015a\u0004;bg.dun\u001a*fG\u0016Lg/\u001a:\u0015\u0007a:E\u000bC\u0003I\t\u0002\u0007\u0011*A\u0004uCN\\Gj\\4\u0011\u0005)\u0013V\"A&\u000b\u00051k\u0015\u0001\u0002;bg.T!AT(\u0002\u0011A\u0014x\u000e^8d_2T!A\t)\u000b\u0005EC\u0011AC4pm\u0016\u0014h.\u00198dK&\u00111k\u0013\u0002\u0010%\u0016\u001c\bo\u001c8tKR\u000b7o\u001b'pO\")Q\u000b\u0012a\u0001-\u000611/\u001a8eKJ\u0004\"a\u0016.\u000e\u0003aS!!\u0017\u0005\u0002\u0007I\u00048-\u0003\u0002\\1\n11+\u001a8eKJD#\u0001R/\u0011\u0005y\u0013W\"A0\u000b\u0005}\u0002'BA1Y\u0003\u001diWm]:bO\u0016L!aY0\u0003\u0011I+7-Z5wKJDQ!\u001a\u0001\u0005B\u0019\fA\u0003^1tWB\u0013xn\u001a:fgN\u0014VmY3jm\u0016\u0014Hc\u0001\u001dhg\")\u0001\u000e\u001aa\u0001S\u0006AB/Y:l!J|wM]3tg^KG\u000f\u001b*fg>,(oY3\u0011\u0005)\fX\"A6\u000b\u00051l\u0017\u0001\u0003:fg>,(oY3\u000b\u00059s'B\u0001\u0012p\u0015\t\u0001\b\"A\u0004nC:\fw-\u001a:\n\u0005I\\'a\u0006*fgB|gn]3UCN\\'+\u001e8oS:<\u0017J\u001c4p\u0011\u0015)F\r1\u0001WQ\t!W\fC\u0003w\u0001\u0011\u0005s/\u0001\nuCN\\7\u000b^1ukN\u0014VmY3jm\u0016\u0014Hc\u0001\u001dy{\")\u00110\u001ea\u0001u\u0006QA/Y:l'R\fG/^:\u0011\u0005)[\u0018B\u0001?L\u0005I\u0011Vm\u001d9p]N,G+Y:l'R\fG/^:\t\u000bU+\b\u0019\u0001,)\u0005Ul\u0006bBA\u0001\u0001\u0011\u0005\u00131A\u0001\u0017i\u0006\u001c8NU3tk2$8+\u001b>f%\u0016\u001cW-\u001b<feR)\u0001(!\u0002\u0002\u0010!9\u0011qA@A\u0002\u0005%\u0011A\u0004;bg.\u0014Vm];miNK'0\u001a\t\u0004\u0015\u0006-\u0011bAA\u0007\u0017\n1\"+Z:q_:\u001cX\rV1tWJ+7/\u001e7u'&TX\rC\u0003V\u007f\u0002\u0007a\u000b\u000b\u0002\u0000;\"9\u0011Q\u0003\u0001\u0005B\u0005]\u0011!\u0006;bg.\u0014Vm];miN+GOU3dK&4XM\u001d\u000b\u0006q\u0005e\u00111\u0005\u0005\t\u00037\t\u0019\u00021\u0001\u0002\u001e\u0005iA/Y:l%\u0016\u001cX\u000f\u001c;TKR\u00042ASA\u0010\u0013\r\t\tc\u0013\u0002\u0016%\u0016\u001c\bo\u001c8tKR\u000b7o\u001b*fgVdGoU3u\u0011\u0019)\u00161\u0003a\u0001-\"\u001a\u00111C/\t\u000f\u0005%\u0002\u0001\"\u0011\u0002,\u0005\tB/Y:l\u000bJ\u0014xN\u001d*fG\u0016Lg/\u001a:\u0015\u000ba\ni#a\u000e\t\u0011\u0005=\u0012q\u0005a\u0001\u0003c\t\u0011C]3ta>t7/\u001a+bg.,%O]8s!\rQ\u00151G\u0005\u0004\u0003kY%!\u0005*fgB|gn]3UCN\\WI\u001d:pe\"1Q+a\nA\u0002YC3!a\n^Q\r\u0001\u0011Q\b\t\u0005\u0003\u007f\tI%\u0004\u0002\u0002B)!\u00111IA#\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0004\u0003\u000fb\u0011aD:qe&twM\u001a:b[\u0016<xN]6\n\t\u0005-\u0013\u0011\t\u0002\b'\u0016\u0014h/[2f\u0001")
public class ComputationTaskExecutionReceiver
implements TaskExecutionReceiver,
Logging {
    private final CodeExecTaskExecutorManager codeExecTaskExecutorManager;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ComputationTaskExecutionReceiver computationTaskExecutionReceiver = this;
        synchronized (computationTaskExecutionReceiver) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    private CodeExecTaskExecutorManager codeExecTaskExecutorManager() {
        return this.codeExecTaskExecutorManager;
    }

    @PostConstruct
    private void init() {
        EngineConnMonitor$.MODULE$.addEngineExecutorStatusMonitor(this.codeExecTaskExecutorManager().getAllInstanceToExecutorCache());
    }

    @Override
    @Receiver
    public void taskLogReceiver(ResponseTaskLog taskLog, Sender sender) {
        ServiceInstance serviceInstance = RPCUtils$.MODULE$.getServiceInstanceFromSender(sender);
        this.codeExecTaskExecutorManager().getByEngineConnAndTaskId(serviceInstance, taskLog.execId()).foreach((Function1)new Serializable(this, taskLog){
            public static final long serialVersionUID = 0L;
            private final ResponseTaskLog taskLog$1;

            public final void apply(CodeExecTaskExecutor codeExecutor) {
                TaskLogEvent event = new TaskLogEvent(codeExecutor.getExecTask(), this.taskLog$1.log());
                codeExecutor.getExecTask().getPhysicalContext().pushLog(event);
                codeExecutor.getEngineConnExecutor().updateLastUpdateTime();
            }
            {
                this.taskLog$1 = taskLog$1;
            }
        });
    }

    @Override
    @Receiver
    public void taskProgressReceiver(ResponseTaskRunningInfo taskProgressWithResource, Sender sender) {
        ServiceInstance serviceInstance = RPCUtils$.MODULE$.getServiceInstanceFromSender(sender);
        this.codeExecTaskExecutorManager().getByEngineConnAndTaskId(serviceInstance, taskProgressWithResource.execId()).foreach((Function1)new Serializable(this, taskProgressWithResource){
            public static final long serialVersionUID = 0L;
            private final ResponseTaskRunningInfo taskProgressWithResource$1;

            public final void apply(CodeExecTaskExecutor codeExecutor) {
                TaskRunningInfoEvent event = new TaskRunningInfoEvent(codeExecutor.getExecTask(), this.taskProgressWithResource$1.progress(), this.taskProgressWithResource$1.progressInfo(), this.taskProgressWithResource$1.resourceMap(), this.taskProgressWithResource$1.extraInfoMap());
                codeExecutor.getExecTask().getPhysicalContext().pushProgress(event);
                codeExecutor.getEngineConnExecutor().updateLastUpdateTime();
            }
            {
                this.taskProgressWithResource$1 = taskProgressWithResource$1;
            }
        });
    }

    @Override
    @Receiver
    public void taskStatusReceiver(ResponseTaskStatus taskStatus, Sender sender) {
        ServiceInstance serviceInstance = RPCUtils$.MODULE$.getServiceInstanceFromSender(sender);
        if (!this.postStatus$1(taskStatus, serviceInstance) && ExecutionNodeStatus.isCompleted((ExecutionNodeStatus)taskStatus.status())) {
            this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" from ", " received ", " cannot find execTask to deal"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serviceInstance, taskStatus})));
            Thread.sleep(ComputationOrchestratorConf$.MODULE$.TASK_STATUS_COMPLETE_WAIT_TIMEOUT());
            if (!this.postStatus$1(taskStatus, serviceInstance)) {
                this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" from ", " received ", " cannot find execTask to deal, by retry 2 times"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serviceInstance, taskStatus})));
            }
        }
    }

    @Override
    @Receiver
    public void taskResultSizeReceiver(ResponseTaskResultSize taskResultSize, Sender sender) {
        ServiceInstance serviceInstance = RPCUtils$.MODULE$.getServiceInstanceFromSender(sender);
        BooleanRef isExist = BooleanRef.create((boolean)false);
        this.codeExecTaskExecutorManager().getByEngineConnAndTaskId(serviceInstance, taskResultSize.execId()).foreach((Function1)new Serializable(this, taskResultSize, isExist){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ComputationTaskExecutionReceiver $outer;
            private final ResponseTaskResultSize taskResultSize$1;
            private final BooleanRef isExist$2;

            public final void apply(CodeExecTaskExecutor codeExecutor) {
                TaskResultSetSizeEvent event = new TaskResultSetSizeEvent(codeExecutor.getExecTask(), this.taskResultSize$1.resultSize());
                this.$outer.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"From engineConn receive resultSet size info", ", now post to listenerBus event: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.taskResultSize$1, event})));
                codeExecutor.getExecTask().getPhysicalContext().broadcastSyncEvent((Event)event);
                codeExecutor.getEngineConnExecutor().updateLastUpdateTime();
                this.isExist$2.elem = true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.taskResultSize$1 = taskResultSize$1;
                this.isExist$2 = isExist$2;
            }
        });
        if (!isExist.elem) {
            this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from ", " received ", " cannot find execTask to deal"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serviceInstance, taskResultSize})));
        }
    }

    @Override
    @Receiver
    public void taskResultSetReceiver(ResponseTaskResultSet taskResultSet, Sender sender) {
        ServiceInstance serviceInstance = RPCUtils$.MODULE$.getServiceInstanceFromSender(sender);
        BooleanRef isExist = BooleanRef.create((boolean)false);
        this.codeExecTaskExecutorManager().getByEngineConnAndTaskId(serviceInstance, taskResultSet.execId()).foreach((Function1)new Serializable(this, taskResultSet, isExist){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ComputationTaskExecutionReceiver $outer;
            private final ResponseTaskResultSet taskResultSet$1;
            private final BooleanRef isExist$3;

            public final void apply(CodeExecTaskExecutor codeExecutor) {
                TaskResultSetEvent event = new TaskResultSetEvent(codeExecutor.getExecTask(), new ResultSet(this.taskResultSet$1.output(), this.taskResultSet$1.alias()));
                this.$outer.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"From engineConn receive resultSet  info ", " , now post to listenerBus event: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.taskResultSet$1, event})));
                codeExecutor.getExecTask().getPhysicalContext().broadcastSyncEvent((Event)event);
                codeExecutor.getEngineConnExecutor().updateLastUpdateTime();
                this.isExist$3.elem = true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.taskResultSet$1 = taskResultSet$1;
                this.isExist$3 = isExist$3;
            }
        });
        if (!isExist.elem) {
            this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from ", " received ", " cannot find execTask to deal"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serviceInstance, taskResultSet})));
        }
    }

    @Override
    @Receiver
    public void taskErrorReceiver(ResponseTaskError responseTaskError, Sender sender) {
        BooleanRef isExist = BooleanRef.create((boolean)false);
        ServiceInstance serviceInstance = RPCUtils$.MODULE$.getServiceInstanceFromSender(sender);
        this.codeExecTaskExecutorManager().getByEngineConnAndTaskId(serviceInstance, responseTaskError.execId()).foreach((Function1)new Serializable(this, responseTaskError, isExist){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ComputationTaskExecutionReceiver $outer;
            private final ResponseTaskError responseTaskError$1;
            private final BooleanRef isExist$4;

            public final void apply(CodeExecTaskExecutor codeExecutor) {
                TaskErrorResponseEvent event = new TaskErrorResponseEvent(codeExecutor.getExecTask(), this.responseTaskError$1.errorMsg());
                this.$outer.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"From engineConn receive responseTaskError  info", ", now post to listenerBus event: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.responseTaskError$1.execId(), event.execTask().getIDInfo()})));
                codeExecutor.getExecTask().getPhysicalContext().broadcastSyncEvent((Event)event);
                codeExecutor.getEngineConnExecutor().updateLastUpdateTime();
                this.isExist$4.elem = true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.responseTaskError$1 = responseTaskError$1;
                this.isExist$4 = isExist$4;
            }
        });
        if (!isExist.elem) {
            this.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from ", " received ", " cannot find execTask to deal"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serviceInstance, responseTaskError})));
        }
    }

    private final boolean postStatus$1(ResponseTaskStatus taskStatus$1, ServiceInstance serviceInstance$1) {
        BooleanRef isExist = BooleanRef.create((boolean)false);
        this.codeExecTaskExecutorManager().getByEngineConnAndTaskId(serviceInstance$1, taskStatus$1.execId()).foreach((Function1)new Serializable(this, taskStatus$1, isExist){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ComputationTaskExecutionReceiver $outer;
            private final ResponseTaskStatus taskStatus$1;
            private final BooleanRef isExist$1;

            public final void apply(CodeExecTaskExecutor codeExecutor) {
                TaskStatusEvent event = new TaskStatusEvent(codeExecutor.getExecTask(), this.taskStatus$1.status());
                this.$outer.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"From engineConn receive status info:", ", now post to listenerBus event: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.taskStatus$1, event})));
                codeExecutor.getExecTask().getPhysicalContext().broadcastSyncEvent((Event)event);
                codeExecutor.getEngineConnExecutor().updateLastUpdateTime();
                this.isExist$1.elem = true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.taskStatus$1 = taskStatus$1;
                this.isExist$1 = isExist$1;
            }
        });
        return isExist.elem;
    }

    public ComputationTaskExecutionReceiver() {
        Logging.class.$init$((Logging)this);
        this.codeExecTaskExecutorManager = CodeExecTaskExecutorManager$.MODULE$.getCodeExecTaskExecutorManager();
    }
}

