/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.computation.monitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.conf.TimeType;
import org.apache.linkis.common.listener.Event;
import org.apache.linkis.common.log.LogUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.governance.common.conf.GovernanceCommonConf$;
import org.apache.linkis.governance.common.entity.ExecutionNodeStatus;
import org.apache.linkis.governance.common.entity.NodeExistStatus;
import org.apache.linkis.governance.common.protocol.engineconn.RequestEngineStatusBatch;
import org.apache.linkis.governance.common.protocol.engineconn.ResponseEngineStatusBatch;
import org.apache.linkis.governance.common.utils.GovernanceConstant$;
import org.apache.linkis.manager.common.entity.enumeration.NodeStatus;
import org.apache.linkis.manager.common.protocol.node.RequestNodeStatus;
import org.apache.linkis.manager.common.protocol.node.ResponseNodeStatus;
import org.apache.linkis.orchestrator.computation.conf.ComputationOrchestratorConf$;
import org.apache.linkis.orchestrator.computation.execute.CodeExecTaskExecutor;
import org.apache.linkis.orchestrator.computation.execute.EngineConnTaskInfo;
import org.apache.linkis.orchestrator.computation.monitor.EngineConnMonitor$;
import org.apache.linkis.orchestrator.computation.monitor.EngineConnMonitor$$anonfun$org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$;
import org.apache.linkis.orchestrator.listener.task.TaskErrorResponseEvent;
import org.apache.linkis.orchestrator.listener.task.TaskLogEvent;
import org.apache.linkis.orchestrator.listener.task.TaskStatusEvent;
import org.apache.linkis.orchestrator.plans.physical.ExecTask;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.server.BDPJettyServerHelper$;
import org.apache.linkis.server.package$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ResizableArray;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class EngineConnMonitor$
implements Logging {
    public static final EngineConnMonitor$ MODULE$;
    private final long org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$ENGINECONN_LASTUPDATE_TIMEOUT;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new EngineConnMonitor$();
    }

    private Logger logger$lzycompute() {
        EngineConnMonitor$ engineConnMonitor$ = this;
        synchronized (engineConnMonitor$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    public long org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$ENGINECONN_LASTUPDATE_TIMEOUT() {
        return this.org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$ENGINECONN_LASTUPDATE_TIMEOUT;
    }

    public void addEngineExecutorStatusMonitor(Map<EngineConnTaskInfo, CodeExecTaskExecutor> engineConnExecutorCache) {
        Runnable task = new Runnable(engineConnExecutorCache){
            public final Map engineConnExecutorCache$1;

            public void run() {
                Utils$.MODULE$.tryAndWarn((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        long endTime;
                        long startTime = System.currentTimeMillis();
                        HashMap unActivityExecutors = new HashMap();
                        ArrayBuffer allTaskExecutors = new ArrayBuffer();
                        allTaskExecutors.appendAll((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.$outer.engineConnExecutorCache$1.values()).asScala());
                        ((ResizableArray)allTaskExecutors.filter((Function1)new Serializable(this, startTime){
                            public static final long serialVersionUID = 0L;
                            private final long startTime$1;

                            public final boolean apply(CodeExecTaskExecutor executor) {
                                return this.startTime$1 - executor.getEngineConnExecutor().getLastUpdateTime() > EngineConnMonitor$.MODULE$.org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$ENGINECONN_LASTUPDATE_TIMEOUT();
                            }
                            {
                                this.startTime$1 = startTime$1;
                            }
                        })).foreach((Function1)new Serializable(this, unActivityExecutors){
                            public static final long serialVersionUID = 0L;
                            private final HashMap unActivityExecutors$1;

                            public final void apply(CodeExecTaskExecutor executor) {
                                ArrayBuffer executors = (ArrayBuffer)this.unActivityExecutors$1.getOrElseUpdate((Object)executor.getEngineConnExecutor().getServiceInstance(), (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final ArrayBuffer<CodeExecTaskExecutor> apply() {
                                        return new ArrayBuffer();
                                    }
                                });
                                executors.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CodeExecTaskExecutor[]{executor}));
                            }
                            {
                                this.unActivityExecutors$1 = unActivityExecutors$1;
                            }
                        });
                        if (unActivityExecutors.nonEmpty()) {
                            EngineConnMonitor$.MODULE$.logger().info("There are {} unActivity engineConn.", (Object)BoxesRunTime.boxToInteger((int)unActivityExecutors.size()));
                            if (unActivityExecutors.size() > GovernanceConstant$.MODULE$.REQUEST_ENGINE_STATUS_BATCH_LIMIT()) {
                                EngineConnMonitor$.MODULE$.org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$queryEngineStatusAndHandle((HashMap<ServiceInstance, ArrayBuffer<CodeExecTaskExecutor>>)unActivityExecutors, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)unActivityExecutors.keys().toList()).asJava());
                            } else {
                                ArrayList<ServiceInstance> engineList = new ArrayList<ServiceInstance>();
                                unActivityExecutors.keys().foreach((Function1)new Serializable(this, unActivityExecutors, engineList){
                                    public static final long serialVersionUID = 0L;
                                    private final HashMap unActivityExecutors$1;
                                    private final ArrayList engineList$1;

                                    public final void apply(ServiceInstance serviceInstance) {
                                        this.engineList$1.add(serviceInstance);
                                        if (this.engineList$1.size() >= GovernanceConstant$.MODULE$.REQUEST_ENGINE_STATUS_BATCH_LIMIT()) {
                                            EngineConnMonitor$.MODULE$.org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$queryEngineStatusAndHandle((HashMap<ServiceInstance, ArrayBuffer<CodeExecTaskExecutor>>)this.unActivityExecutors$1, this.engineList$1);
                                            this.engineList$1.clear();
                                        }
                                    }
                                    {
                                        this.unActivityExecutors$1 = unActivityExecutors$1;
                                        this.engineList$1 = engineList$1;
                                    }
                                });
                                if (!engineList.isEmpty()) {
                                    EngineConnMonitor$.MODULE$.org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$queryEngineStatusAndHandle((HashMap<ServiceInstance, ArrayBuffer<CodeExecTaskExecutor>>)unActivityExecutors, engineList);
                                    engineList.clear();
                                }
                            }
                        }
                        if ((endTime = System.currentTimeMillis()) - startTime >= ((TimeType)ComputationOrchestratorConf$.MODULE$.ENGINECONN_ACTIVITY_MONITOR_INTERVAL().getValue()).toLong()) {
                            EngineConnMonitor$.MODULE$.logger().warn("Query engines status costs longer time than query task interval, you should increase interval.");
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, EngineConnMonitor$.MODULE$.logger());
            }
            {
                this.engineConnExecutorCache$1 = engineConnExecutorCache$1;
            }
        };
        Utils$.MODULE$.defaultScheduler().scheduleWithFixedDelay(task, 10000L, ((TimeType)ComputationOrchestratorConf$.MODULE$.ENGINECONN_ACTIVITY_MONITOR_INTERVAL().getValue()).toLong(), TimeUnit.MILLISECONDS);
        this.logger().info("Entrance engineStatusMonitor inited.");
    }

    public void org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$queryEngineStatusAndHandle(HashMap<ServiceInstance, ArrayBuffer<CodeExecTaskExecutor>> unActivityExecutors, List<ServiceInstance> engineList) {
        RequestEngineStatusBatch requestEngineStatus = new RequestEngineStatusBatch(engineList);
        Utils$.MODULE$.tryAndError((Function0)new Serializable(unActivityExecutors, requestEngineStatus){
            public static final long serialVersionUID = 0L;
            public final HashMap unActivityExecutors$2;
            private final RequestEngineStatusBatch requestEngineStatus$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Object object = Sender$.MODULE$.getSender((String)GovernanceCommonConf$.MODULE$.MANAGER_SERVICE_NAME().getValue()).ask((Object)this.requestEngineStatus$1);
                if (object instanceof ResponseEngineStatusBatch) {
                    ResponseEngineStatusBatch responseEngineStatusBatch = (ResponseEngineStatusBatch)object;
                    if (responseEngineStatusBatch.msg() != null) {
                        EngineConnMonitor$.MODULE$.logger().info("ResponseEngineStatusBatch msg: {}", new Object[]{responseEngineStatusBatch.msg()});
                    }
                    if (responseEngineStatusBatch.engineStatus().size() != this.requestEngineStatus$1.engineList().size()) {
                        EngineConnMonitor$.MODULE$.logger().warn("ResponseEngineStatusBatch engines size: {} is not equal request: {}.", (Object)BoxesRunTime.boxToInteger((int)responseEngineStatusBatch.engineStatus().size()), (Object)BoxesRunTime.boxToInteger((int)this.requestEngineStatus$1.engineList().size()));
                        ArrayBuffer unKnownEngines = new ArrayBuffer();
                        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.requestEngineStatus$1.engineList()).asScala()).foreach((Function1)new Serializable(this, unKnownEngines, responseEngineStatusBatch){
                            public static final long serialVersionUID = 0L;
                            private final ArrayBuffer unKnownEngines$1;
                            private final ResponseEngineStatusBatch x2$1;

                            public final Object apply(ServiceInstance instance) {
                                BoxedUnit boxedUnit;
                                if (this.x2$1.engineStatus().containsKey(instance)) {
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    this.x2$1.engineStatus().put(instance, NodeExistStatus.Unknown);
                                    boxedUnit = this.unKnownEngines$1.$plus$eq((Object)instance);
                                }
                                return boxedUnit;
                            }
                            {
                                this.unKnownEngines$1 = unKnownEngines$1;
                                this.x2$1 = x2$1;
                            }
                        });
                        String instances = ((TraversableOnce)unKnownEngines.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(ServiceInstance x$1) {
                                return x$1.getInstance();
                            }
                        }, ArrayBuffer$.MODULE$.canBuildFrom())).mkString(",");
                        EngineConnMonitor$.MODULE$.logger().warn("These engine instances cannot be found in manager : {}", new Object[]{instances});
                    }
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(responseEngineStatusBatch.engineStatus()).asScala()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun$org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$queryEngineStatusAndHandle$1 $outer;

                        public final void apply(Tuple2<ServiceInstance, NodeExistStatus> status) {
                            EngineConnMonitor$.MODULE$.org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$dealWithEngineStatus(status, (HashMap<ServiceInstance, ArrayBuffer<CodeExecTaskExecutor>>)this.$outer.unActivityExecutors$2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    EngineConnMonitor$.MODULE$.logger().warn("Invalid response. request : {}", new Object[]{BDPJettyServerHelper$.MODULE$.gson().toJson((Object)this.requestEngineStatus$1)});
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.unActivityExecutors$2 = unActivityExecutors$2;
                this.requestEngineStatus$1 = requestEngineStatus$1;
            }
        }, this.logger());
    }

    public void org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$dealWithEngineStatus(Tuple2<ServiceInstance, NodeExistStatus> status, HashMap<ServiceInstance, ArrayBuffer<CodeExecTaskExecutor>> unActivityExecutors) {
        NodeExistStatus nodeExistStatus;
        block4: {
            block3: {
                block2: {
                    nodeExistStatus = (NodeExistStatus)status._2();
                    if (!NodeExistStatus.UnExist.equals(nodeExistStatus)) break block2;
                    this.logger().warn("Engine {} is Failed, now go to clear its task.", new Object[]{status._1()});
                    this.org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$killTask((Option<ArrayBuffer<CodeExecTaskExecutor>>)unActivityExecutors.get(status._1()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                boolean bl = NodeExistStatus.Exist.equals(nodeExistStatus) ? true : NodeExistStatus.Unknown.equals(nodeExistStatus);
                if (!bl) break block4;
                ArrayBuffer engineConnExecutor = package$.MODULE$.toJavaMap(unActivityExecutors).getOrDefault(status._1(), null);
                BoxedUnit boxedUnit = engineConnExecutor == null ? BoxedUnit.UNIT : (BoxedUnit)Utils$.MODULE$.tryCatch((Function0)new Serializable(status, unActivityExecutors){
                    public static final long serialVersionUID = 0L;
                    private final Tuple2 status$1;
                    private final HashMap unActivityExecutors$3;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        RequestNodeStatus requestNodeStatus = new RequestNodeStatus();
                        Object object = Sender$.MODULE$.getSender((ServiceInstance)this.status$1._1()).ask((Object)requestNodeStatus);
                        if (object instanceof ResponseNodeStatus) {
                            BoxedUnit boxedUnit;
                            ResponseNodeStatus responseNodeStatus = (ResponseNodeStatus)object;
                            if (Predef$.MODULE$.Boolean2boolean(NodeStatus.isCompleted((NodeStatus)responseNodeStatus.getNodeStatus()))) {
                                EngineConnMonitor$.MODULE$.org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$killTask((Option<ArrayBuffer<CodeExecTaskExecutor>>)this.unActivityExecutors$3.get(this.status$1._1()));
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                if (EngineConnMonitor$.MODULE$.logger().isDebugEnabled()) {
                                    EngineConnMonitor$.MODULE$.logger().debug("Will update engineConnExecutor({}) lastupdated time", new Object[]{this.status$1._1()});
                                }
                                EngineConnMonitor$.MODULE$.org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$updateExecutorActivityTime((ServiceInstance)this.status$1._1(), (HashMap<ServiceInstance, ArrayBuffer<CodeExecTaskExecutor>>)this.unActivityExecutors$3);
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                        } else {
                            EngineConnMonitor$.MODULE$.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown response for request : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BDPJettyServerHelper$.MODULE$.gson().toJson((Object)requestNodeStatus)})));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    {
                        this.status$1 = status$1;
                        this.unActivityExecutors$3 = unActivityExecutors$3;
                    }
                }, (Function1)new Serializable(status, unActivityExecutors){
                    public static final long serialVersionUID = 0L;
                    private final Tuple2 status$1;
                    private final HashMap unActivityExecutors$3;

                    public final void apply(Throwable t) {
                        EngineConnMonitor$.MODULE$.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get status of engineConn : ", ", now end the job. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.status$1._1()})), t);
                        EngineConnMonitor$.MODULE$.org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$killTask((Option<ArrayBuffer<CodeExecTaskExecutor>>)this.unActivityExecutors$3.get(this.status$1._1()));
                    }
                    {
                        this.status$1 = status$1;
                        this.unActivityExecutors$3 = unActivityExecutors$3;
                    }
                });
            }
            return;
        }
        throw new MatchError((Object)nodeExistStatus);
    }

    public void org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$killTask(Option<ArrayBuffer<CodeExecTaskExecutor>> mayExecutors) {
        if (mayExecutors.isEmpty()) {
            this.logger().error("executor is not Defined");
            return;
        }
        ArrayBuffer executors = (ArrayBuffer)mayExecutors.get();
        executors.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(CodeExecTaskExecutor executor) {
                ExecTask execTask = executor.getExecTask();
                Utils$.MODULE$.tryAndError((Function0)new Serializable(this, execTask, executor){
                    public static final long serialVersionUID = 0L;
                    private final ExecTask execTask$1;
                    private final CodeExecTaskExecutor executor$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        EngineConnMonitor$.MODULE$.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Will kill task ", " because the engine ", " quited unexpectedly."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.execTask$1.getIDInfo(), this.executor$1.getEngineConnExecutor().getServiceInstance().toString()})));
                        String errLog = LogUtils$.MODULE$.generateERROR(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Your job : ", " was failed because the engine quitted unexpectedly(\u4efb\u52a1", "\u5931\u8d25\uff0c"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.execTask$1.getIDInfo(), this.execTask$1.getIDInfo()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\u539f\u56e0\u662f\u5f15\u64ce\u610f\u5916\u9000\u51fa,\u53ef\u80fd\u662f\u590d\u6742\u4efb\u52a1\u5bfc\u81f4\u5f15\u64ce\u9000\u51fa\uff0c\u5982OOM)."})).s((Seq)Nil$.MODULE$)).toString());
                        TaskLogEvent logEvent = new TaskLogEvent(this.execTask$1, errLog);
                        this.execTask$1.getPhysicalContext().pushLog(logEvent);
                        TaskErrorResponseEvent errorResponseEvent = new TaskErrorResponseEvent(this.execTask$1, "task failed\uff0cEngine quitted unexpectedly(\u4efb\u52a1\u8fd0\u884c\u5931\u8d25\u539f\u56e0\u662f\u5f15\u64ce\u610f\u5916\u9000\u51fa,\u53ef\u80fd\u662f\u590d\u6742\u4efb\u52a1\u5bfc\u81f4\u5f15\u64ce\u9000\u51fa\uff0c\u5982OOM).");
                        this.execTask$1.getPhysicalContext().broadcastSyncEvent((Event)errorResponseEvent);
                        TaskStatusEvent statusEvent = new TaskStatusEvent(this.execTask$1, ExecutionNodeStatus.Failed);
                        this.execTask$1.getPhysicalContext().broadcastSyncEvent((Event)statusEvent);
                    }
                    {
                        this.execTask$1 = execTask$1;
                        this.executor$1 = executor$1;
                    }
                }, EngineConnMonitor$.MODULE$.logger());
            }
        });
    }

    public void org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$updateExecutorActivityTime(ServiceInstance serviceInstance, HashMap<ServiceInstance, ArrayBuffer<CodeExecTaskExecutor>> engineConnExecutorCache) {
        if (serviceInstance != null) {
            ArrayBuffer executors = package$.MODULE$.toJavaMap(engineConnExecutorCache).getOrDefault(serviceInstance, null);
            if (executors == null) {
                this.logger().warn("EngineConnExecutor {} cannot be found in engineConnExecutorCache", new Object[]{serviceInstance.toString()});
            } else {
                executors.foreach((Function1)new Serializable(serviceInstance){
                    public static final long serialVersionUID = 0L;
                    private final ServiceInstance serviceInstance$1;

                    public final void apply(CodeExecTaskExecutor executor) {
                        if (executor.getEngineConnExecutor().getServiceInstance().equals((Object)this.serviceInstance$1)) {
                            executor.getEngineConnExecutor().updateLastUpdateTime();
                        }
                    }
                    {
                        this.serviceInstance$1 = serviceInstance$1;
                    }
                });
            }
        }
    }

    private EngineConnMonitor$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.org$apache$linkis$orchestrator$computation$monitor$EngineConnMonitor$$ENGINECONN_LASTUPDATE_TIMEOUT = ((TimeType)ComputationOrchestratorConf$.MODULE$.ENGINECONN_LASTUPDATE_TIMEOUT().getValue()).toLong();
    }
}

