/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.computation.execute;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.exception.LinkisRetryException;
import org.apache.linkis.common.log.LogUtils$;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.entrance.BindEngineLabel;
import org.apache.linkis.manager.label.entity.entrance.ExecuteOnceLabel;
import org.apache.linkis.manager.label.entity.entrance.LoadBalanceLabel;
import org.apache.linkis.manager.label.utils.LabelUtil$;
import org.apache.linkis.manager.label.utils.LabelUtils;
import org.apache.linkis.orchestrator.computation.conf.ComputationOrchestratorConf$;
import org.apache.linkis.orchestrator.computation.execute.CodeExecTaskExecutor;
import org.apache.linkis.orchestrator.computation.execute.CodeExecTaskExecutorManager;
import org.apache.linkis.orchestrator.computation.execute.EngineConnTaskInfo;
import org.apache.linkis.orchestrator.computation.physical.CodeLogicalUnitExecTask;
import org.apache.linkis.orchestrator.ecm.EngineConnManager;
import org.apache.linkis.orchestrator.ecm.EngineConnManagerBuilder;
import org.apache.linkis.orchestrator.ecm.EngineConnManagerBuilder$;
import org.apache.linkis.orchestrator.ecm.entity.DefaultMarkReq;
import org.apache.linkis.orchestrator.ecm.entity.LoadBanlanceMarkReq;
import org.apache.linkis.orchestrator.ecm.entity.Mark;
import org.apache.linkis.orchestrator.ecm.entity.MarkReq;
import org.apache.linkis.orchestrator.ecm.entity.Policy;
import org.apache.linkis.orchestrator.ecm.service.EngineConnExecutor;
import org.apache.linkis.orchestrator.exception.OrchestratorErrorCodeSummary$;
import org.apache.linkis.orchestrator.exception.OrchestratorLabelConflictException;
import org.apache.linkis.orchestrator.exception.OrchestratorRetryException;
import org.apache.linkis.orchestrator.listener.task.TaskLogEvent;
import org.apache.linkis.orchestrator.plans.physical.ExecTask;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\tma\u0001B\u0001\u0003\u0001=\u0011!\u0005R3gCVdGoQ8eK\u0016CXm\u0019+bg.,\u00050Z2vi>\u0014X*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003\u001d)\u00070Z2vi\u0016T!!\u0002\u0004\u0002\u0017\r|W\u000e];uCRLwN\u001c\u0006\u0003\u000f!\tAb\u001c:dQ\u0016\u001cHO]1u_JT!!\u0003\u0006\u0002\r1Lgn[5t\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\f\u001b!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u001c\u0007>$W-\u0012=fGR\u000b7o[#yK\u000e,Ho\u001c:NC:\fw-\u001a:\u0011\u0005m\u0001S\"\u0001\u000f\u000b\u0005uq\u0012!B;uS2\u001c(BA\u0010\t\u0003\u0019\u0019w.\\7p]&\u0011\u0011\u0005\b\u0002\b\u0019><w-\u001b8h\u0011\u0015\u0019\u0003\u0001\"\u0001%\u0003\u0019a\u0014N\\5u}Q\tQ\u0005\u0005\u0002\u0018\u0001!9q\u0005\u0001b\u0001\n\u0013A\u0013aE5ogR\fgnY3U_\u0016CXmY;u_J\u001cX#A\u0015\u0011\t)\n4GN\u0007\u0002W)\u0011A&L\u0001\u000bG>t7-\u001e:sK:$(B\u0001\u00180\u0003\u0011)H/\u001b7\u000b\u0003A\nAA[1wC&\u0011!g\u000b\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bCA\f5\u0013\t)$A\u0001\nF]\u001eLg.Z\"p]:$\u0016m]6J]\u001a|\u0007CA\f8\u0013\tA$A\u0001\u000bD_\u0012,W\t_3d)\u0006\u001c8.\u0012=fGV$xN\u001d\u0005\u0007u\u0001\u0001\u000b\u0011B\u0015\u0002)%t7\u000f^1oG\u0016$v.\u0012=fGV$xN]:!\u0011\u001da\u0004A1A\u0005\nu\n!#\u001a=fGR\u000b7o\u001b+p\u000bb,7-\u001e;peV\ta\b\u0005\u0003+c}2\u0004C\u0001!D\u001d\t\t\u0012)\u0003\u0002C%\u00051\u0001K]3eK\u001aL!\u0001R#\u0003\rM#(/\u001b8h\u0015\t\u0011%\u0003\u0003\u0004H\u0001\u0001\u0006IAP\u0001\u0014Kb,7\rV1tWR{W\t_3dkR|'\u000f\t\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003K\u0003a!WMZ1vYR,enZ5oK\u000e{gN\\'b]\u0006<WM]\u000b\u0002\u0017B\u0011AjT\u0007\u0002\u001b*\u0011aJB\u0001\u0004K\u000el\u0017B\u0001)N\u0005E)enZ5oK\u000e{gN\\'b]\u0006<WM\u001d\u0005\u0007%\u0002\u0001\u000b\u0011B&\u00023\u0011,g-Y;mi\u0016sw-\u001b8f\u0007>tg.T1oC\u001e,'\u000f\t\u0005\b)\u0002\u0011\r\u0011\"\u0003K\u0003Ya\u0017MY3m\u000b:<\u0017N\\3D_:tW*\u00198bO\u0016\u0014\bB\u0002,\u0001A\u0003%1*A\fmC\n,G.\u00128hS:,7i\u001c8o\u001b\u0006t\u0017mZ3sA!9\u0001\f\u0001b\u0001\n\u0013I\u0016\u0001C<bSRdunY6\u0016\u0003i\u00032!E.^\u0013\ta&CA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0012=&\u0011qL\u0005\u0002\u0005\u0005f$X\r\u0003\u0004b\u0001\u0001\u0006IAW\u0001\no\u0006LG\u000fT8dW\u0002BQa\u0019\u0001\u0005B\u0011\f1\"Y:l\u000bb,7-\u001e;peR\u0019Q\r\u001b9\u0011\u0007E1g'\u0003\u0002h%\t1q\n\u001d;j_:DQ!\u001b2A\u0002)\f\u0001\"\u001a=fGR\u000b7o\u001b\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[\u0012\t\u0001\u0002\u001d5zg&\u001c\u0017\r\\\u0005\u0003_2\u0014qcQ8eK2{w-[2bYVs\u0017\u000e^#yK\u000e$\u0016m]6\t\u000bE\u0014\u0007\u0019\u0001:\u0002\t]\f\u0017\u000e\u001e\t\u0003g^l\u0011\u0001\u001e\u0006\u0003kZ\f\u0001\u0002Z;sCRLwN\u001c\u0006\u0003YII!\u0001\u001f;\u0003\u0011\u0011+(/\u0019;j_:DQa\u0019\u0001\u0005Bi$\"!Z>\t\u000b%L\b\u0019\u00016\t\u000bu\u0004A\u0011\t@\u0002\u001d\r\u0014X-\u0019;f\u000bb,7-\u001e;peR\u0011ag \u0005\u0006Sr\u0004\rA\u001b\u0005\b\u0003\u0007\u0001A\u0011CA\u0003\u00035\u0019'/Z1uK6\u000b'o\u001b*fcR!\u0011qAA\n!\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007\u001b\u00061QM\u001c;jifLA!!\u0005\u0002\f\t9Q*\u0019:l%\u0016\f\bBB5\u0002\u0002\u0001\u0007!\u000eC\u0004\u0002\u0018\u0001!I!!\u0007\u0002\u0017]\f\u0017\u000e\u001e$pe&#G.\u001a\u000b\u0005\u00037\t\t\u0003E\u0002\u0012\u0003;I1!a\b\u0013\u0005\u0011)f.\u001b;\t\u0011\u0005\r\u0012Q\u0003a\u0001\u0003K\t\u0001b^1jiRKW.\u001a\t\u0004#\u0005\u001d\u0012bAA\u0015%\t!Aj\u001c8h\u0011\u001d\ti\u0003\u0001C!\u0003_\t\u0001dZ3u\u0005f,enZ5oK\u000e{gN\\!oIR\u000b7o[%e)\u0015)\u0017\u0011GA\u001f\u0011!\t\u0019$a\u000bA\u0002\u0005U\u0012aD:feZL7-Z%ogR\fgnY3\u0011\t\u0005]\u0012\u0011H\u0007\u0002=%\u0019\u00111\b\u0010\u0003\u001fM+'O^5dK&s7\u000f^1oG\u0016Dq!a\u0010\u0002,\u0001\u0007q(\u0001\tf]\u001eLg.Z\"p]:$\u0016m]6JI\"9\u00111\t\u0001\u0005B\u0005\u0015\u0013aD4fi\nKX\t_3d)\u0006\u001c8.\u00133\u0015\u0007\u0015\f9\u0005C\u0004\u0002J\u0005\u0005\u0003\u0019A \u0002\u0015\u0015DXm\u0019+bg.LE\rC\u0004\u0002N\u0001!\t%a\u0014\u0002\u0011MDW\u000f\u001e3po:$\"!a\u0007\t\u000f\u0005M\u0003\u0001\"\u0003\u0002V\u0005\t2\r\\3be\u0016CXmY;u_J\u0014\u00150\u00133\u0015\u0011\u0005m\u0011qKA.\u0003#Cq!!\u0017\u0002R\u0001\u0007a'\u0001\u0005fq\u0016\u001cW\u000f^8s\u0011!\ti&!\u0015A\u0002\u0005}\u0013A\u00027bE\u0016d7\u000f\u0005\u0004\u0002b\u0005\r\u0014qM\u0007\u0002[%\u0019\u0011QM\u0017\u0003\t1K7\u000f\u001e\u0019\u0005\u0003S\ny\b\u0005\u0004\u0002l\u0005]\u00141P\u0007\u0003\u0003[RA!!\u0004\u0002p)!\u0011\u0011OA:\u0003\u0015a\u0017MY3m\u0015\r\t)\bC\u0001\b[\u0006t\u0017mZ3s\u0013\u0011\tI(!\u001c\u0003\u000b1\u000b'-\u001a7\u0011\t\u0005u\u0014q\u0010\u0007\u0001\t1\t\t)a\u0017\u0002\u0002\u0003\u0005)\u0011AAB\u0005\ryF%M\t\u0005\u0003\u000b\u000bY\tE\u0002\u0012\u0003\u000fK1!!#\u0013\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!EAG\u0013\r\tyI\u0005\u0002\u0004\u0003:L\bBCAJ\u0003#\u0002\n\u00111\u0001\u0002\u0016\u0006aam\u001c:dKJ+G.Z1tKB\u0019\u0011#a&\n\u0007\u0005e%CA\u0004C_>dW-\u00198\t\u000f\u0005u\u0005\u0001\"\u0003\u0002 \u0006)#/Z7pm\u0016,\u00050Z2vi>\u0014hI]8n\u0013:\u001cH/\u00198dKR{W\t_3dkR|'o\u001d\u000b\u0005\u00037\t\t\u000bC\u0004\u0002Z\u0005m\u0005\u0019\u0001\u001c\t\u000f\u0005\u0015\u0006\u0001\"\u0011\u0002(\u0006)\u0012\r\u001a3F]\u001eLg.Z\"p]:$\u0016m]6J]\u001a|G\u0003BA\u000e\u0003SCq!!\u0017\u0002$\u0002\u0007a\u0007C\u0004\u0002.\u0002!I!a,\u0002)\u001d,G/\u00128hS:,7i\u001c8o\u001b\u0006t\u0017mZ3s)\rY\u0015\u0011\u0017\u0005\t\u0003;\nY\u000b1\u0001\u00024B1\u0011\u0011MA2\u0003k\u0003D!a.\u0002<B1\u00111NA<\u0003s\u0003B!! \u0002<\u0012a\u0011QXAY\u0003\u0003\u0005\tQ!\u0001\u0002\u0004\n\u0019q\f\n\u001a\t\u000f\u0005\u0005\u0007\u0001\"\u0011\u0002D\u0006ir-\u001a;BY2Len\u001d;b]\u000e,Gk\\#yK\u000e,Ho\u001c:DC\u000eDW\r\u0006\u0002\u0002FB1\u0011\u0011MAdgYJ1!!3.\u0005\ri\u0015\r\u001d\u0005\b\u0003\u001b\u0004A\u0011IAh\u0003u9W\r^!mY\u0016CXm\u0019+bg.$v.\u0012=fGV$xN]\"bG\",GCAAi!\u0019\t\t'a2@m!9\u0011Q\u001b\u0001\u0005R\u0005]\u0017\u0001E;o\u0019>\u001c7.\u00128hS:,7i\u001c8o)\u0019\tY\"!7\u0002\\\"1\u0011.a5A\u0002)Dq!!8\u0002T\u0002\u0007a'\u0001\tfq\u0016\u001cG+Y:l\u000bb,7-\u001e;pe\"9\u0011\u0011\u001d\u0001\u0005R\u0005\r\u0018\u0001D7be.,5IR1jY\u0016$GCBA\u000e\u0003K\f9\u000f\u0003\u0004j\u0003?\u0004\rA\u001b\u0005\b\u00033\ny\u000e1\u00017\u0011\u001d\tY\u000f\u0001C)\u0003[\fa\u0001Z3mKR,GCBA\u000e\u0003_\f\t\u0010\u0003\u0004j\u0003S\u0004\rA\u001b\u0005\b\u00033\nI\u000f1\u00017\u0011\u001d\t)\u0010\u0001C!\u0003o\f\u0011#\\1sWR\u000b7o[\"p[BdW\r^3e)!\tY\"!?\u0002|\u0006u\bBB5\u0002t\u0002\u0007!\u000eC\u0004\u0002Z\u0005M\b\u0019\u0001\u001c\t\u0011\u0005}\u00181\u001fa\u0001\u0003+\u000b\u0011\"[:Tk\u000e\u001cW-\u001a3\t\u0013\t\r\u0001!%A\u0005\n\t\u0015\u0011aG2mK\u0006\u0014X\t_3dkR|'OQ=JI\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\b)\"\u0011Q\u0013B\u0005W\t\u0011Y\u0001\u0005\u0003\u0003\u000e\t]QB\u0001B\b\u0015\u0011\u0011\tBa\u0005\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u000b%\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\te!q\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class DefaultCodeExecTaskExecutorManager
implements CodeExecTaskExecutorManager,
Logging {
    private final ConcurrentHashMap<EngineConnTaskInfo, CodeExecTaskExecutor> instanceToExecutors;
    private final ConcurrentHashMap<String, CodeExecTaskExecutor> execTaskToExecutor;
    private final EngineConnManager defaultEngineConnManager;
    private final EngineConnManager labelEngineConnManager;
    private final byte[] waitLock;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        DefaultCodeExecTaskExecutorManager defaultCodeExecTaskExecutorManager = this;
        synchronized (defaultCodeExecTaskExecutorManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    private ConcurrentHashMap<EngineConnTaskInfo, CodeExecTaskExecutor> instanceToExecutors() {
        return this.instanceToExecutors;
    }

    private ConcurrentHashMap<String, CodeExecTaskExecutor> execTaskToExecutor() {
        return this.execTaskToExecutor;
    }

    private EngineConnManager defaultEngineConnManager() {
        return this.defaultEngineConnManager;
    }

    private EngineConnManager labelEngineConnManager() {
        return this.labelEngineConnManager;
    }

    private byte[] waitLock() {
        return this.waitLock;
    }

    @Override
    public Option<CodeExecTaskExecutor> askExecutor(CodeLogicalUnitExecTask execTask, Duration wait) {
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start to askExecutor for execId ", ", wait ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{execTask.getIDInfo(), wait})));
        long startTime = System.currentTimeMillis();
        ObjectRef retryException = ObjectRef.create(null);
        None$ executor = None$.MODULE$;
        while (System.currentTimeMillis() - startTime < wait.toMillis() && executor.isEmpty()) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            Option option = (Option)Utils$.MODULE$.tryCatch((Function0)new Serializable(this, execTask){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DefaultCodeExecTaskExecutorManager $outer;
                private final CodeLogicalUnitExecTask execTask$1;

                public final Option<CodeExecTaskExecutor> apply() {
                    return this.$outer.askExecutor(this.execTask$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.execTask$1 = execTask$1;
                }
            }, (Function1)new Serializable(this, retryException){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DefaultCodeExecTaskExecutorManager $outer;
                private final ObjectRef retryException$1;

                public final Option<CodeExecTaskExecutor> apply(Throwable x0$1) {
                    Throwable throwable = x0$1;
                    if (throwable instanceof LinkisRetryException) {
                        LinkisRetryException linkisRetryException = (LinkisRetryException)throwable;
                        this.$outer.logger().warn("request engine failed!", (Throwable)linkisRetryException);
                        this.retryException$1.elem = linkisRetryException;
                        None$ none$ = None$.MODULE$;
                        return none$;
                    }
                    if (throwable != null) {
                        Throwable throwable2 = throwable;
                        throw throwable2;
                    }
                    throw new MatchError((Object)throwable);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.retryException$1 = retryException$1;
                }
            });
            if (option instanceof Some) {
                Some some = (Some)option;
                CodeExecTaskExecutor e = (CodeExecTaskExecutor)some.x();
                this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished to askExecutor for execId ", ", wait ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{execTask.getIDInfo(), BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime))})));
                executor = Option$.MODULE$.apply((Object)e);
                boxedUnit2 = BoxedUnit.UNIT;
                continue;
            }
            if (System.currentTimeMillis() - startTime < wait.toMillis()) {
                long interval = package$.MODULE$.min(3000L, wait.toMillis() - System.currentTimeMillis() + startTime);
                this.waitForIdle(interval);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            boxedUnit2 = boxedUnit;
        }
        if ((LinkisRetryException)retryException.elem != null && executor.isEmpty()) {
            throw (LinkisRetryException)retryException.elem;
        }
        return executor;
    }

    @Override
    public Option<CodeExecTaskExecutor> askExecutor(CodeLogicalUnitExecTask execTask) {
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start to askExecutor for execId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{execTask.getIDInfo()})));
        CodeExecTaskExecutor executor = this.createExecutor(execTask);
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished to askExecutor for execId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{execTask.getIDInfo()})));
        return Option$.MODULE$.apply((Object)executor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CodeExecTaskExecutor createExecutor(CodeLogicalUnitExecTask execTask) {
        void var3_3;
        EngineConnManager engineConnManager = this.org$apache$linkis$orchestrator$computation$execute$DefaultCodeExecTaskExecutorManager$$getEngineConnManager(execTask.getLabels());
        MarkReq markReq = this.createMarkReq(execTask);
        ExecuteOnceLabel executeOnceLabel = LabelUtil$.MODULE$.getExecuteOnceLabel(execTask.getLabels());
        LoadBalanceLabel loadBalanceLabel = LabelUtil$.MODULE$.getLoadBalanceLabel(execTask.getLabels());
        if (executeOnceLabel == null || loadBalanceLabel == null) {
            Mark mark = engineConnManager.applyMark(markReq);
            markReq.setCreateService(new StringBuilder().append((Object)markReq.getCreateService()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mark_id: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mark.getMarkId()}))).toString());
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create Executor for execId ", " mark id is ", ", user ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{execTask.getIDInfo(), mark.getMarkId(), mark.getMarkReq().getUser()})));
            execTask.getPhysicalContext().pushLog(new TaskLogEvent((ExecTask)execTask, LogUtils$.MODULE$.generateInfo(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Background is starting a new engine for you,execId ", " mark id is ", ", it may take several seconds, please wait"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{execTask.getIDInfo(), mark.getMarkId()})))));
            EngineConnExecutor engineConnExecutor = engineConnManager.getAvailableEngineConnExecutor(mark);
            if (engineConnExecutor == null) {
                return null;
            }
            CodeExecTaskExecutor codeExecTaskExecutor = new CodeExecTaskExecutor(engineConnExecutor, (ExecTask)execTask, mark);
            Object object = codeExecTaskExecutor == null ? BoxedUnit.UNIT : this.execTaskToExecutor().put(execTask.getId(), codeExecTaskExecutor);
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished to create Executor for execId ", " mark id is ", ", user ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{execTask.getIDInfo(), mark.getMarkId(), mark.getMarkReq().getUser()})));
            return codeExecTaskExecutor;
        }
        throw new OrchestratorLabelConflictException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ExecuteOnceLabel : ", " should not come with LoadBalanceLabel : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var3_3.getLabels().get("executeOnce"), var3_3.getLabels().get("loadBalance")})));
    }

    /*
     * WARNING - void declaration
     */
    public MarkReq createMarkReq(CodeLogicalUnitExecTask execTask) {
        void var3_4;
        HashMap<String, String> hashMap;
        DefaultMarkReq defaultMarkReq;
        LoadBalanceLabel loadBalanceLabel = LabelUtil$.MODULE$.getLoadBalanceLabel(execTask.getLabels());
        if (loadBalanceLabel == null) {
            DefaultMarkReq defaultMarkReq2 = new DefaultMarkReq();
            defaultMarkReq2.registerLabelKey("bindEngine");
            defaultMarkReq = defaultMarkReq2;
        } else {
            defaultMarkReq = new LoadBanlanceMarkReq();
        }
        LoadBanlanceMarkReq markReq = defaultMarkReq;
        markReq.setPolicyObj(Policy.Task);
        markReq.setCreateService((String)ComputationOrchestratorConf$.MODULE$.DEFAULT_CREATE_SERVICE().getValue());
        markReq.setEngineConnCount(BoxesRunTime.unboxToInt((Object)ComputationOrchestratorConf$.MODULE$.DEFAULT_MARK_MAX_ENGINE().getValue()));
        if (execTask.getParams().getStartupParams() == null) {
            hashMap = new HashMap<String, String>();
        } else {
            scala.collection.mutable.Map startupMap = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(execTask.getParams().getStartupParams().getConfigurationMap()).asScala();
            HashMap properties = new HashMap();
            startupMap.foreach((Function1)new Serializable(this, properties){
                public static final long serialVersionUID = 0L;
                private final HashMap properties$1;

                public final Object apply(Tuple2<String, Object> x0$2) {
                    Tuple2<String, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        Object v = tuple2._2();
                        BoxedUnit boxedUnit = v != null && StringUtils.isNotEmpty((CharSequence)v.toString()) ? this.properties$1.put(k, v.toString()) : BoxedUnit.UNIT;
                        return boxedUnit;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.properties$1 = properties$1;
                }
            });
            hashMap = properties;
        }
        HashMap<String, String> properties = hashMap;
        markReq.setProperties(properties);
        markReq.setUser(execTask.getExecuteUser());
        if (execTask.getLabels() != null) {
            markReq.setLabels(LabelUtils.labelsToMap(execTask.getLabels()));
        }
        return var3_4;
    }

    private void waitForIdle(long waitTime) {
        byte[] byArray = this.waitLock();
        synchronized (byArray) {
            this.waitLock().wait(waitTime);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Option<CodeExecTaskExecutor> getByEngineConnAndTaskId(ServiceInstance serviceInstance, String engineConnTaskId) {
        None$ none$;
        CodeExecTaskExecutor maybeExecutors = this.instanceToExecutors().get(new EngineConnTaskInfo(serviceInstance, engineConnTaskId));
        if (maybeExecutors != null) {
            String string = maybeExecutors.getEngineConnTaskId();
            String string2 = engineConnTaskId;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                none$ = new Some((Object)maybeExecutors);
                return none$;
            }
        }
        none$ = None$.MODULE$;
        return none$;
    }

    @Override
    public Option<CodeExecTaskExecutor> getByExecTaskId(String execTaskId) {
        CodeExecTaskExecutor executor = this.execTaskToExecutor().get(execTaskId);
        return Option$.MODULE$.apply((Object)executor);
    }

    @Override
    public void shutdown() {
    }

    private void clearExecutorById(CodeExecTaskExecutor executor, List<Label<?>> labels, boolean forceRelease) {
        Object object;
        if (executor == null || executor.getEngineConnExecutor() == null) {
            return;
        }
        LoadBalanceLabel loadBalanceLabel = LabelUtil$.MODULE$.getLoadBalanceLabel(labels);
        if (loadBalanceLabel == null || forceRelease) {
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"To release engine ConnExecutor ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{executor})));
            object = Utils$.MODULE$.tryAndWarn((Function0)new Serializable(this, executor, labels){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DefaultCodeExecTaskExecutorManager $outer;
                private final CodeExecTaskExecutor executor$1;
                private final List labels$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.org$apache$linkis$orchestrator$computation$execute$DefaultCodeExecTaskExecutorManager$$getEngineConnManager(this.labels$1).releaseEngineConnExecutor(this.executor$1.getEngineConnExecutor(), this.executor$1.getMark());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.executor$1 = executor$1;
                    this.labels$1 = labels$1;
                }
            }, this.logger());
        } else {
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Task has loadBalanceLabel, Not need to delete executor ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{executor})));
            object = BoxedUnit.UNIT;
        }
        this.removeExecutorFromInstanceToExecutors(executor);
    }

    private boolean clearExecutorById$default$3() {
        return false;
    }

    private void removeExecutorFromInstanceToExecutors(CodeExecTaskExecutor executor) {
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"To delete codeExecTaskExecutor  ", " from instanceToExecutors"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{executor})));
        EngineConnTaskInfo engineConnTaskInfo = new EngineConnTaskInfo(executor.getEngineConnExecutor().getServiceInstance(), executor.getEngineConnTaskId());
        this.instanceToExecutors().remove(engineConnTaskInfo);
        this.execTaskToExecutor().remove(executor.getExecTaskId());
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"To delete exec task ", " and CodeExecTaskExecutor ", " relation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{executor.getExecTask().getIDInfo(), executor.getEngineConnExecutor().getServiceInstance()})));
    }

    @Override
    public void addEngineConnTaskInfo(CodeExecTaskExecutor executor) {
        if (executor == null || StringUtils.isBlank((CharSequence)executor.getExecTaskId())) {
            throw new OrchestratorRetryException(OrchestratorErrorCodeSummary$.MODULE$.EXECUTION_ERROR_CODE(), "Failed to store task information");
        }
        EngineConnTaskInfo engineConnTaskInfo = new EngineConnTaskInfo(executor.getEngineConnExecutor().getServiceInstance(), executor.getEngineConnTaskId());
        this.instanceToExecutors().put(engineConnTaskInfo, executor);
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished To add codeExecTaskExecutor  ", " to instanceToExecutors"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{executor})));
    }

    public EngineConnManager org$apache$linkis$orchestrator$computation$execute$DefaultCodeExecTaskExecutorManager$$getEngineConnManager(List<Label<?>> labels) {
        if (labels == null || labels.isEmpty()) {
            return this.defaultEngineConnManager();
        }
        if (((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(labels).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Label<?> x$1) {
                return x$1 instanceof LoadBalanceLabel;
            }
        })) {
            return this.labelEngineConnManager();
        }
        return this.defaultEngineConnManager();
    }

    @Override
    public Map<EngineConnTaskInfo, CodeExecTaskExecutor> getAllInstanceToExecutorCache() {
        return this.instanceToExecutors();
    }

    @Override
    public Map<String, CodeExecTaskExecutor> getAllExecTaskToExecutorCache() {
        return this.execTaskToExecutor();
    }

    @Override
    public void unLockEngineConn(CodeLogicalUnitExecTask execTask, CodeExecTaskExecutor execTaskExecutor) {
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " task be killed or failed , Now to delete executor ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{execTask.getIDInfo(), execTaskExecutor.getEngineConnExecutor().getServiceInstance()})));
        this.clearExecutorById(execTaskExecutor, execTask.getLabels(), this.clearExecutorById$default$3());
    }

    @Override
    public void markECFailed(CodeLogicalUnitExecTask execTask, CodeExecTaskExecutor executor) {
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " task  failed because executor exit, Now to delete executor ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{execTask.getIDInfo(), executor.getEngineConnExecutor().getServiceInstance()})));
        this.clearExecutorById(executor, execTask.getLabels(), true);
    }

    @Override
    public void delete(CodeLogicalUnitExecTask execTask, CodeExecTaskExecutor executor) {
        BindEngineLabel jobGroupLabel = LabelUtil$.MODULE$.getBindEngineLabel(execTask.getLabels());
        boolean isEndJob = false;
        String jobGroupId = "";
        if (jobGroupLabel == null) {
            this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"To delete codeExecTaskExecutor  ", "  from execTaskToExecutor."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{executor})));
            this.clearExecutorById(executor, execTask.getLabels(), this.clearExecutorById$default$3());
        } else {
            isEndJob = jobGroupLabel.getIsJobGroupEnd();
            jobGroupId = jobGroupLabel.getJobGroupId();
            if (isEndJob) {
                this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"To delete codeExecTaskExecutor  ", " from execTaskToExecutor for lastjob of jobGroupId : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{executor, jobGroupId})));
                this.clearExecutorById(executor, execTask.getLabels(), this.clearExecutorById$default$3());
            } else {
                this.removeExecutorFromInstanceToExecutors(executor);
                this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Subjob is not end of JobGroup with id : ", ", we will not delete codeExecTaskExecutor with id : ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobGroupId, executor})));
            }
        }
    }

    @Override
    public void markTaskCompleted(CodeLogicalUnitExecTask execTask, CodeExecTaskExecutor executor, boolean isSucceed) {
        Object object;
        if (isSucceed) {
            this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ExecTask(", ") execute  success executor be delete."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{execTask.getIDInfo()})));
            object = Utils$.MODULE$.tryAndWarn((Function0)new Serializable(this, execTask, executor){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DefaultCodeExecTaskExecutorManager $outer;
                private final CodeLogicalUnitExecTask execTask$2;
                private final CodeExecTaskExecutor executor$2;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.delete(this.execTask$2, this.executor$2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.execTask$2 = execTask$2;
                    this.executor$2 = executor$2;
                }
            }, this.logger());
        } else if (StringUtils.isBlank((CharSequence)executor.getEngineConnTaskId())) {
            this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Failed to submit running, now to remove  codeEngineConnExecutor, forceRelease"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{execTask.getIDInfo()})));
            object = Utils$.MODULE$.tryAndWarn((Function0)new Serializable(this, execTask, executor){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DefaultCodeExecTaskExecutorManager $outer;
                private final CodeLogicalUnitExecTask execTask$2;
                private final CodeExecTaskExecutor executor$2;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.markECFailed(this.execTask$2, this.executor$2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.execTask$2 = execTask$2;
                    this.executor$2 = executor$2;
                }
            }, this.logger());
        } else {
            this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ExecTask(", ") execute  failed executor be unLock."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{execTask.getIDInfo()})));
            object = Utils$.MODULE$.tryAndWarn((Function0)new Serializable(this, execTask, executor){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DefaultCodeExecTaskExecutorManager $outer;
                private final CodeLogicalUnitExecTask execTask$2;
                private final CodeExecTaskExecutor executor$2;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.unLockEngineConn(this.execTask$2, this.executor$2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.execTask$2 = execTask$2;
                    this.executor$2 = executor$2;
                }
            }, this.logger());
        }
        if (executor != null && executor.getEngineConnExecutor() != null) {
            executor.getEngineConnExecutor().removeTask(executor.getEngineConnTaskId());
        }
    }

    public DefaultCodeExecTaskExecutorManager() {
        Logging.class.$init$((Logging)this);
        this.instanceToExecutors = new ConcurrentHashMap();
        this.execTaskToExecutor = new ConcurrentHashMap();
        EngineConnManagerBuilder builder = EngineConnManagerBuilder$.MODULE$.builder();
        builder.setPolicy(Policy.Process);
        this.defaultEngineConnManager = builder.build();
        EngineConnManagerBuilder builder2 = EngineConnManagerBuilder$.MODULE$.builder();
        builder2.setPolicy(Policy.Label);
        this.labelEngineConnManager = builder2.build();
        this.waitLock = new byte[0];
    }
}

