/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.orchestrator.computation.operation.progress;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.DoubleBinaryOperator;
import java.util.function.ToDoubleFunction;
import org.apache.linkis.common.listener.EventListener;
import org.apache.linkis.governance.common.constant.job.TaskInfoConstants$;
import org.apache.linkis.orchestrator.OrchestratorSession;
import org.apache.linkis.orchestrator.computation.operation.progress.AbstractProgressOperation;
import org.apache.linkis.orchestrator.computation.operation.progress.DefaultProgressOperation$;
import org.apache.linkis.orchestrator.computation.operation.progress.ProgressConstraints$;
import org.apache.linkis.orchestrator.computation.operation.progress.ProgressProcessor;
import org.apache.linkis.orchestrator.computation.physical.CodeLogicalUnitExecTask;
import org.apache.linkis.orchestrator.computation.utils.TaskTreeUtil;
import org.apache.linkis.orchestrator.listener.task.TaskRunningInfoEvent;
import org.apache.linkis.orchestrator.plans.physical.ExecTask;
import org.apache.linkis.orchestrator.plans.physical.PhysicalContext;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001#\tAB)\u001a4bk2$\bK]8he\u0016\u001c8o\u00149fe\u0006$\u0018n\u001c8\u000b\u0005\r!\u0011\u0001\u00039s_\u001e\u0014Xm]:\u000b\u0005\u00151\u0011!C8qKJ\fG/[8o\u0015\t9\u0001\"A\u0006d_6\u0004X\u000f^1uS>t'BA\u0005\u000b\u00031y'o\u00195fgR\u0014\u0018\r^8s\u0015\tYA\"\u0001\u0004mS:\\\u0017n\u001d\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005e\t%m\u001d;sC\u000e$\bK]8he\u0016\u001c8o\u00149fe\u0006$\u0018n\u001c8\t\u0011]\u0001!\u0011!Q\u0001\na\t1c\u001c:dQ\u0016\u001cHO]1u_J\u001cVm]:j_:\u0004\"!\u0007\u000e\u000e\u0003!I!a\u0007\u0005\u0003'=\u00138\r[3tiJ\fGo\u001c:TKN\u001c\u0018n\u001c8\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\ty\u0002\u0005\u0005\u0002\u0014\u0001!)q\u0003\ba\u00011!9!\u0005\u0001a\u0001\n\u0013\u0019\u0013!D5t\u0013:LG/[1mSj,G-F\u0001%!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u001d\u0011un\u001c7fC:Dqa\u000b\u0001A\u0002\u0013%A&A\tjg&s\u0017\u000e^5bY&TX\rZ0%KF$\"!\f\u0019\u0011\u0005\u0015r\u0013BA\u0018'\u0005\u0011)f.\u001b;\t\u000fER\u0013\u0011!a\u0001I\u0005\u0019\u0001\u0010J\u0019\t\rM\u0002\u0001\u0015)\u0003%\u00039I7/\u00138ji&\fG.\u001b>fI\u0002BQ!\u000e\u0001\u0005\u0002Y\nA!\u001b8jiR\tQ\u0006C\u00039\u0001\u0011\u0005\u0013(A\u0004hKRt\u0015-\\3\u0016\u0003i\u0002\"a\u000f \u000f\u0005\u0015b\u0014BA\u001f'\u0003\u0019\u0001&/\u001a3fM&\u0011q\b\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005u2\u0003\"\u0002\"\u0001\t\u0003\u001a\u0015\u0001D8o!J|wM]3tg>sGCA\u0017E\u0011\u0015)\u0015\t1\u0001G\u0003]y'/\u001b+bg.\u0014VO\u001c8j]\u001eLeNZ8Fm\u0016tG\u000f\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006!A/Y:l\u0015\tY\u0005\"\u0001\u0005mSN$XM\\3s\u0013\ti\u0005J\u0001\u000bUCN\\'+\u001e8oS:<\u0017J\u001c4p\u000bZ,g\u000e\u001e\u0005\u0006\u001f\u0002!I\u0001U\u0001\u0015O\u0016tWM]1uK\u0016CXm\u0019+bg.LeNZ8\u0015\u0005E{\u0006\u0003\u0002*Xuek\u0011a\u0015\u0006\u0003)V\u000bA!\u001e;jY*\ta+\u0001\u0003kCZ\f\u0017B\u0001-T\u0005\u001dA\u0015m\u001d5NCB\u0004\"AW/\u000e\u0003mS!\u0001X+\u0002\t1\fgnZ\u0005\u0003=n\u0013aa\u00142kK\u000e$\b\"B%O\u0001\u0004\u0001\u0007CA1g\u001b\u0005\u0011'BA2e\u0003!\u0001\b._:jG\u0006d'BA3\t\u0003\u0015\u0001H.\u00198t\u0013\t9'M\u0001\u0005Fq\u0016\u001cG+Y:l\u000f\u0015I'\u0001#\u0001k\u0003a!UMZ1vYR\u0004&o\\4sKN\u001cx\n]3sCRLwN\u001c\t\u0003'-4Q!\u0001\u0002\t\u00021\u001c\"a[7\u0011\u0005\u0015r\u0017BA8'\u0005\u0019\te.\u001f*fM\")Qd\u001bC\u0001cR\t!\u000eC\u0004tW\n\u0007I\u0011\u0001;\u0002\u001bA\u0013vj\u0012*F'N{f*Q'F+\u0005)\bC\u0001.w\u0013\ty4\f\u0003\u0004yW\u0002\u0006I!^\u0001\u000f!J{uIU#T'~s\u0015)T#!\u0001")
public class DefaultProgressOperation
extends AbstractProgressOperation {
    private final OrchestratorSession orchestratorSession;
    private boolean isInitialized;

    public static String PROGRESS_NAME() {
        return DefaultProgressOperation$.MODULE$.PROGRESS_NAME();
    }

    private boolean isInitialized() {
        return this.isInitialized;
    }

    private void isInitialized_$eq(boolean x$1) {
        this.isInitialized = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() {
        if (this.isInitialized()) return;
        DefaultProgressOperation defaultProgressOperation = this;
        synchronized (defaultProgressOperation) {
            BoxedUnit boxedUnit;
            if (this.isInitialized()) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.orchestratorSession.getOrchestratorSessionState().getOrchestratorAsyncListenerBus().addListener((EventListener)this);
                this.isInitialized_$eq(true);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public String getName() {
        if (!this.isInitialized()) {
            this.init();
        }
        return DefaultProgressOperation$.MODULE$.PROGRESS_NAME();
    }

    public void onProgressOn(TaskRunningInfoEvent oriTaskRunningInfoEvent) {
        ObjectRef taskRunningInfoEvent = ObjectRef.create(null);
        HashMap<String, Object> execTaskInfo = this.generateExecTaskInfo(oriTaskRunningInfoEvent.execTask());
        if (oriTaskRunningInfoEvent.infoMap() == null) {
            taskRunningInfoEvent.elem = new TaskRunningInfoEvent(oriTaskRunningInfoEvent.execTask(), oriTaskRunningInfoEvent.progress(), oriTaskRunningInfoEvent.progressInfo(), oriTaskRunningInfoEvent.resourceMap(), execTaskInfo);
        } else {
            oriTaskRunningInfoEvent.infoMap().putAll(execTaskInfo);
            taskRunningInfoEvent.elem = new TaskRunningInfoEvent(oriTaskRunningInfoEvent.execTask(), oriTaskRunningInfoEvent.progress(), oriTaskRunningInfoEvent.progressInfo(), oriTaskRunningInfoEvent.resourceMap(), oriTaskRunningInfoEvent.infoMap());
        }
        ExecTask execTask = ((TaskRunningInfoEvent)taskRunningInfoEvent.elem).execTask();
        Option$.MODULE$.apply((Object)execTask).foreach((Function1)new Serializable(this, taskRunningInfoEvent, execTask){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultProgressOperation $outer;
            private final ObjectRef taskRunningInfoEvent$1;
            private final ExecTask execTask$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void apply(ExecTask task) {
                TaskRunningInfoEvent taskRunningInfoEvent;
                PhysicalContext physicalContext = task.getPhysicalContext();
                Option progressInfo = physicalContext.getOption(ProgressConstraints$.MODULE$.PROGRESS_MAP_NAME());
                if (progressInfo.get() == null) {
                    ConcurrentHashMap progressMap = (ConcurrentHashMap)physicalContext.getOrElsePut(ProgressConstraints$.MODULE$.PROGRESS_MAP_NAME(), new ConcurrentHashMap<K, V>());
                    List<CodeLogicalUnitExecTask> codeExecTasks = TaskTreeUtil.getAllTaskRecursive(physicalContext.getRootTask(), CodeLogicalUnitExecTask.class);
                    if (codeExecTasks != null) {
                        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(codeExecTasks).asScala()).foreach((Function1)new Serializable(this, progressMap){
                            public static final long serialVersionUID = 0L;
                            private final ConcurrentHashMap progressMap$1;

                            public final float apply(CodeLogicalUnitExecTask task) {
                                return BoxesRunTime.unboxToFloat((Object)this.progressMap$1.put(task.getId(), BoxesRunTime.boxToFloat((float)0.0f)));
                            }
                            {
                                this.progressMap$1 = progressMap$1;
                            }
                        });
                    }
                    progressMap.put(this.execTask$1.getId(), BoxesRunTime.boxToFloat((float)((TaskRunningInfoEvent)this.taskRunningInfoEvent$1.elem).progress()));
                    taskRunningInfoEvent = (TaskRunningInfoEvent)this.taskRunningInfoEvent$1.elem;
                } else {
                    ConcurrentHashMap progressMap = (ConcurrentHashMap)progressInfo.get();
                    progressMap.put(this.execTask$1.getId(), BoxesRunTime.boxToFloat((float)((TaskRunningInfoEvent)this.taskRunningInfoEvent$1.elem).progress()));
                    ConcurrentHashMap concurrentHashMap = progressMap;
                    synchronized (concurrentHashMap) {
                        double progressValueSum = progressMap.reduceValuesToDouble(1L, new ToDoubleFunction<Object>(this){

                            public double applyAsDouble(float t) {
                                return t;
                            }
                        }, 0.0, new DoubleBinaryOperator(this){

                            public double applyAsDouble(double left, double right) {
                                return left + right;
                            }
                        });
                        TaskRunningInfoEvent taskRunningInfoEvent2 = new TaskRunningInfoEvent(this.execTask$1, (float)progressValueSum / (float)progressMap.size(), ((TaskRunningInfoEvent)this.taskRunningInfoEvent$1.elem).progressInfo(), ((TaskRunningInfoEvent)this.taskRunningInfoEvent$1.elem).resourceMap(), ((TaskRunningInfoEvent)this.taskRunningInfoEvent$1.elem).infoMap());
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl20 : MonitorExitStatement: MONITOREXIT : concurrentHashMap
                        taskRunningInfoEvent = taskRunningInfoEvent2;
                    }
                }
                TaskRunningInfoEvent event = taskRunningInfoEvent;
                Option$.MODULE$.apply((Object)this.$outer.execTaskToProgressProcessor().get(this.execTask$1.getPhysicalContext().getRootTask().getId())).foreach((Function1)new Serializable(this, event){
                    public static final long serialVersionUID = 0L;
                    private final TaskRunningInfoEvent event$1;

                    public final void apply(ProgressProcessor progress) {
                        progress.onProgress(this.event$1.progress(), this.event$1.progressInfo(), this.event$1.resourceMap(), this.event$1.infoMap());
                    }
                    {
                        this.event$1 = event$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.taskRunningInfoEvent$1 = taskRunningInfoEvent$1;
                this.execTask$1 = execTask$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, Object> generateExecTaskInfo(ExecTask task) {
        void var2_2;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (task == null) {
            this.logger().warn("TaskRunningInfoEvent got null execTask.");
            return map;
        }
        map.put(TaskInfoConstants$.MODULE$.EXEC_ID(), task.getId());
        map.put(TaskInfoConstants$.MODULE$.ID_INFO(), task.getIDInfo());
        map.put(TaskInfoConstants$.MODULE$.TASK_CLASSNAME(), task.getClass().getSimpleName());
        map.put(TaskInfoConstants$.MODULE$.TASK_NAME(), task.getName());
        return var2_2;
    }

    public DefaultProgressOperation(OrchestratorSession orchestratorSession) {
        this.orchestratorSession = orchestratorSession;
        super(orchestratorSession);
        this.isInitialized = false;
    }
}

