/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.trino.tpch;

import java.util.Locale;
import java.util.Objects;
import org.apache.kyuubi.shade.io.trino.tpch.GenerateUtils;
import org.apache.kyuubi.shade.io.trino.tpch.TpchEntity;

public class Supplier
implements TpchEntity {
    private final long rowNumber;
    private final long supplierKey;
    private final String name;
    private final String address;
    private final long nationKey;
    private final String phone;
    private final long accountBalance;
    private final String comment;

    public Supplier(long rowNumber, long supplierKey, String name, String address, long nationKey, String phone, long accountBalance, String comment) {
        this.rowNumber = rowNumber;
        this.supplierKey = supplierKey;
        this.name = Objects.requireNonNull(name, "name is null");
        this.address = Objects.requireNonNull(address, "address is null");
        this.nationKey = nationKey;
        this.phone = Objects.requireNonNull(phone, "phone is null");
        this.accountBalance = accountBalance;
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    @Override
    public long getRowNumber() {
        return this.rowNumber;
    }

    public long getSupplierKey() {
        return this.supplierKey;
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public long getNationKey() {
        return this.nationKey;
    }

    public String getPhone() {
        return this.phone;
    }

    public double getAccountBalance() {
        return (double)this.accountBalance / 100.0;
    }

    public long getAccountBalanceInCents() {
        return this.accountBalance;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public String toLine() {
        return String.format(Locale.ENGLISH, "%d|%s|%s|%d|%s|%s|%s|", this.supplierKey, this.name, this.address, this.nationKey, this.phone, GenerateUtils.formatMoney(this.accountBalance), this.comment);
    }
}

