/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.trino.tpch;

import java.util.Iterator;
import java.util.Objects;
import org.apache.kyuubi.shade.com.google.common.collect.AbstractIterator;
import org.apache.kyuubi.shade.io.trino.tpch.Distribution;
import org.apache.kyuubi.shade.io.trino.tpch.Distributions;
import org.apache.kyuubi.shade.io.trino.tpch.RandomText;
import org.apache.kyuubi.shade.io.trino.tpch.Region;
import org.apache.kyuubi.shade.io.trino.tpch.TextPool;

public class RegionGenerator
implements Iterable<Region> {
    private static final int COMMENT_AVERAGE_LENGTH = 72;
    private final Distributions distributions;
    private final TextPool textPool;

    public RegionGenerator() {
        this(Distributions.getDefaultDistributions(), TextPool.getDefaultTestPool());
    }

    public RegionGenerator(Distributions distributions, TextPool textPool) {
        this.distributions = Objects.requireNonNull(distributions, "distributions is null");
        this.textPool = Objects.requireNonNull(textPool, "textPool is null");
    }

    @Override
    public Iterator<Region> iterator() {
        return new RegionGeneratorIterator(this.distributions.getRegions(), this.textPool);
    }

    private static class RegionGeneratorIterator
    extends AbstractIterator<Region> {
        private final Distribution regions;
        private final RandomText commentRandom;
        private int index;

        private RegionGeneratorIterator(Distribution regions, TextPool textPool) {
            this.regions = regions;
            this.commentRandom = new RandomText(1500869201L, textPool, 72.0);
        }

        @Override
        protected Region computeNext() {
            if (this.index >= this.regions.size()) {
                return (Region)this.endOfData();
            }
            Region region = new Region(this.index, this.index, this.regions.getValue(this.index), this.commentRandom.nextValue());
            this.commentRandom.rowFinished();
            ++this.index;
            return region;
        }
    }
}

