/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.trino.tpch;

import java.util.Locale;
import java.util.Objects;
import org.apache.kyuubi.shade.io.trino.tpch.GenerateUtils;
import org.apache.kyuubi.shade.io.trino.tpch.TpchEntity;

public class Part
implements TpchEntity {
    private final long rowNumber;
    private final long partKey;
    private final String name;
    private final String manufacturer;
    private final String brand;
    private final String type;
    private final int size;
    private final String container;
    private final long retailPrice;
    private final String comment;

    public Part(long rowNumber, long partKey, String name, String manufacturer, String brand, String type, int size, String container, long retailPrice, String comment) {
        this.rowNumber = rowNumber;
        this.partKey = partKey;
        this.name = Objects.requireNonNull(name, "name is null");
        this.manufacturer = Objects.requireNonNull(manufacturer, "manufacturer is null");
        this.brand = Objects.requireNonNull(brand, "brand is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.size = size;
        this.container = Objects.requireNonNull(container, "container is null");
        this.retailPrice = retailPrice;
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    @Override
    public long getRowNumber() {
        return this.rowNumber;
    }

    public long getPartKey() {
        return this.partKey;
    }

    public String getName() {
        return this.name;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getBrand() {
        return this.brand;
    }

    public String getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public String getContainer() {
        return this.container;
    }

    public double getRetailPrice() {
        return (double)this.retailPrice / 100.0;
    }

    public long getRetailPriceInCents() {
        return this.retailPrice;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public String toLine() {
        return String.format(Locale.ENGLISH, "%d|%s|%s|%s|%s|%d|%s|%s|%s|", this.partKey, this.name, this.manufacturer, this.brand, this.type, this.size, this.container, GenerateUtils.formatMoney(this.retailPrice), this.comment);
    }
}

