/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.trino.tpch;

import java.util.Iterator;
import java.util.Objects;
import org.apache.kyuubi.shade.com.google.common.base.Preconditions;
import org.apache.kyuubi.shade.com.google.common.collect.AbstractIterator;
import org.apache.kyuubi.shade.io.trino.tpch.Distributions;
import org.apache.kyuubi.shade.io.trino.tpch.GenerateUtils;
import org.apache.kyuubi.shade.io.trino.tpch.LineItem;
import org.apache.kyuubi.shade.io.trino.tpch.OrderGenerator;
import org.apache.kyuubi.shade.io.trino.tpch.PartGenerator;
import org.apache.kyuubi.shade.io.trino.tpch.PartSupplierGenerator;
import org.apache.kyuubi.shade.io.trino.tpch.RandomBoundedInt;
import org.apache.kyuubi.shade.io.trino.tpch.RandomBoundedLong;
import org.apache.kyuubi.shade.io.trino.tpch.RandomString;
import org.apache.kyuubi.shade.io.trino.tpch.RandomText;
import org.apache.kyuubi.shade.io.trino.tpch.TextPool;

public class LineItemGenerator
implements Iterable<LineItem> {
    private static final int QUANTITY_MIN = 1;
    private static final int QUANTITY_MAX = 50;
    private static final int TAX_MIN = 0;
    private static final int TAX_MAX = 8;
    private static final int DISCOUNT_MIN = 0;
    private static final int DISCOUNT_MAX = 10;
    private static final int PART_KEY_MIN = 1;
    private static final int SHIP_DATE_MIN = 1;
    private static final int SHIP_DATE_MAX = 121;
    private static final int COMMIT_DATE_MIN = 30;
    private static final int COMMIT_DATE_MAX = 90;
    private static final int RECEIPT_DATE_MIN = 1;
    private static final int RECEIPT_DATE_MAX = 30;
    static final int ITEM_SHIP_DAYS = 151;
    private static final int COMMENT_AVERAGE_LENGTH = 27;
    private final double scaleFactor;
    private final int part;
    private final int partCount;
    private final Distributions distributions;
    private final TextPool textPool;

    public LineItemGenerator(double scaleFactor, int part, int partCount) {
        this(scaleFactor, part, partCount, Distributions.getDefaultDistributions(), TextPool.getDefaultTestPool());
    }

    public LineItemGenerator(double scaleFactor, int part, int partCount, Distributions distributions, TextPool textPool) {
        Preconditions.checkArgument(scaleFactor > 0.0, "scaleFactor must be greater than 0");
        Preconditions.checkArgument(part >= 1, "part must be at least 1");
        Preconditions.checkArgument(part <= partCount, "part must be less than or equal to part count");
        this.scaleFactor = scaleFactor;
        this.part = part;
        this.partCount = partCount;
        this.distributions = Objects.requireNonNull(distributions, "distributions is null");
        this.textPool = Objects.requireNonNull(textPool, "textPool is null");
    }

    @Override
    public Iterator<LineItem> iterator() {
        return new LineItemGeneratorIterator(this.distributions, this.textPool, this.scaleFactor, GenerateUtils.calculateStartIndex(1500000, this.scaleFactor, this.part, this.partCount), GenerateUtils.calculateRowCount(1500000, this.scaleFactor, this.part, this.partCount));
    }

    static RandomBoundedInt createQuantityRandom() {
        return new RandomBoundedInt(209208115L, 1, 50, 7);
    }

    static RandomBoundedInt createDiscountRandom() {
        return new RandomBoundedInt(554590007L, 0, 10, 7);
    }

    static RandomBoundedInt createTaxRandom() {
        return new RandomBoundedInt(721958466L, 0, 8, 7);
    }

    static RandomBoundedLong createPartKeyRandom(double scaleFactor) {
        return new RandomBoundedLong(1808217256L, scaleFactor >= 30000.0, 1L, (long)(200000.0 * scaleFactor), 7);
    }

    static RandomBoundedInt createShipDateRandom() {
        return new RandomBoundedInt(1769349045L, 1, 121, 7);
    }

    private static class LineItemGeneratorIterator
    extends AbstractIterator<LineItem> {
        private final RandomBoundedInt orderDateRandom = OrderGenerator.createOrderDateRandom();
        private final RandomBoundedInt lineCountRandom = OrderGenerator.createLineCountRandom();
        private final RandomBoundedInt quantityRandom = LineItemGenerator.createQuantityRandom();
        private final RandomBoundedInt discountRandom = LineItemGenerator.createDiscountRandom();
        private final RandomBoundedInt taxRandom = LineItemGenerator.createTaxRandom();
        private final RandomBoundedLong linePartKeyRandom;
        private final RandomBoundedInt supplierNumberRandom = new RandomBoundedInt(2095021727L, 0, 3, 7);
        private final RandomBoundedInt shipDateRandom = LineItemGenerator.createShipDateRandom();
        private final RandomBoundedInt commitDateRandom = new RandomBoundedInt(904914315L, 30, 90, 7);
        private final RandomBoundedInt receiptDateRandom = new RandomBoundedInt(373135028L, 1, 30, 7);
        private final RandomString returnedFlagRandom;
        private final RandomString shipInstructionsRandom;
        private final RandomString shipModeRandom;
        private final RandomText commentRandom;
        private final double scaleFactor;
        private final long startIndex;
        private final long rowCount;
        private long index;
        private int orderDate;
        private int lineCount;
        private int lineNumber;

        private LineItemGeneratorIterator(Distributions distributions, TextPool textPool, double scaleFactor, long startIndex, long rowCount) {
            this.scaleFactor = scaleFactor;
            this.startIndex = startIndex;
            this.rowCount = rowCount;
            this.returnedFlagRandom = new RandomString(717419739L, distributions.getReturnFlags(), 7);
            this.shipInstructionsRandom = new RandomString(1371272478L, distributions.getShipInstructions(), 7);
            this.shipModeRandom = new RandomString(675466456L, distributions.getShipModes(), 7);
            this.commentRandom = new RandomText(1095462486L, textPool, 27.0, 7);
            this.linePartKeyRandom = LineItemGenerator.createPartKeyRandom(scaleFactor);
            this.orderDateRandom.advanceRows(startIndex);
            this.lineCountRandom.advanceRows(startIndex);
            this.quantityRandom.advanceRows(startIndex);
            this.discountRandom.advanceRows(startIndex);
            this.taxRandom.advanceRows(startIndex);
            this.linePartKeyRandom.advanceRows(startIndex);
            this.supplierNumberRandom.advanceRows(startIndex);
            this.shipDateRandom.advanceRows(startIndex);
            this.commitDateRandom.advanceRows(startIndex);
            this.receiptDateRandom.advanceRows(startIndex);
            this.returnedFlagRandom.advanceRows(startIndex);
            this.shipInstructionsRandom.advanceRows(startIndex);
            this.shipModeRandom.advanceRows(startIndex);
            this.commentRandom.advanceRows(startIndex);
            this.orderDate = this.orderDateRandom.nextValue();
            this.lineCount = this.lineCountRandom.nextValue() - 1;
        }

        @Override
        protected LineItem computeNext() {
            if (this.index >= this.rowCount) {
                return (LineItem)this.endOfData();
            }
            LineItem lineitem = this.makeLineitem(this.startIndex + this.index + 1L);
            ++this.lineNumber;
            if (this.lineNumber > this.lineCount) {
                this.orderDateRandom.rowFinished();
                this.lineCountRandom.rowFinished();
                this.quantityRandom.rowFinished();
                this.discountRandom.rowFinished();
                this.taxRandom.rowFinished();
                this.linePartKeyRandom.rowFinished();
                this.supplierNumberRandom.rowFinished();
                this.shipDateRandom.rowFinished();
                this.commitDateRandom.rowFinished();
                this.receiptDateRandom.rowFinished();
                this.returnedFlagRandom.rowFinished();
                this.shipInstructionsRandom.rowFinished();
                this.shipModeRandom.rowFinished();
                this.commentRandom.rowFinished();
                ++this.index;
                this.lineCount = this.lineCountRandom.nextValue() - 1;
                this.orderDate = this.orderDateRandom.nextValue();
                this.lineNumber = 0;
            }
            return lineitem;
        }

        private LineItem makeLineitem(long orderIndex) {
            long orderKey = OrderGenerator.makeOrderKey(orderIndex);
            int quantity = this.quantityRandom.nextValue();
            int discount = this.discountRandom.nextValue();
            int tax = this.taxRandom.nextValue();
            long partKey = this.linePartKeyRandom.nextValue();
            int supplierNumber = this.supplierNumberRandom.nextValue();
            long supplierKey = PartSupplierGenerator.selectPartSupplier(partKey, supplierNumber, this.scaleFactor);
            long partPrice = PartGenerator.calculatePartPrice(partKey);
            long extendedPrice = partPrice * (long)quantity;
            int shipDate = this.shipDateRandom.nextValue();
            int commitDate = this.commitDateRandom.nextValue();
            commitDate += this.orderDate;
            int receiptDate = this.receiptDateRandom.nextValue();
            String returnedFlag = GenerateUtils.isInPast(receiptDate += (shipDate += this.orderDate)) ? this.returnedFlagRandom.nextValue() : "N";
            String status = GenerateUtils.isInPast(shipDate) ? "F" : "O";
            String shipInstructions = this.shipInstructionsRandom.nextValue();
            String shipMode = this.shipModeRandom.nextValue();
            String comment = this.commentRandom.nextValue();
            return new LineItem(orderIndex, orderKey, partKey, supplierKey, this.lineNumber + 1, quantity, extendedPrice, discount, tax, returnedFlag, status, GenerateUtils.toEpochDate(shipDate), GenerateUtils.toEpochDate(commitDate), GenerateUtils.toEpochDate(receiptDate), shipInstructions, shipMode, comment);
        }
    }
}

