/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.trino.tpch;

import org.apache.kyuubi.shade.io.trino.tpch.GenerateUtils;
import org.apache.kyuubi.shade.io.trino.tpch.LineItem;
import org.apache.kyuubi.shade.io.trino.tpch.TpchColumn;
import org.apache.kyuubi.shade.io.trino.tpch.TpchColumnType;
import org.apache.kyuubi.shade.io.trino.tpch.TpchColumnTypes;

public enum LineItemColumn implements TpchColumn<LineItem>
{
    ORDER_KEY("l_orderkey", TpchColumnTypes.IDENTIFIER){

        @Override
        public long getIdentifier(LineItem lineItem) {
            return lineItem.getOrderKey();
        }
    }
    ,
    PART_KEY("l_partkey", TpchColumnTypes.IDENTIFIER){

        @Override
        public long getIdentifier(LineItem lineItem) {
            return lineItem.getPartKey();
        }
    }
    ,
    SUPPLIER_KEY("l_suppkey", TpchColumnTypes.IDENTIFIER){

        @Override
        public long getIdentifier(LineItem lineItem) {
            return lineItem.getSupplierKey();
        }
    }
    ,
    LINE_NUMBER("l_linenumber", TpchColumnTypes.INTEGER){

        @Override
        public int getInteger(LineItem lineItem) {
            return lineItem.getLineNumber();
        }
    }
    ,
    QUANTITY("l_quantity", TpchColumnTypes.DOUBLE){

        @Override
        public double getDouble(LineItem lineItem) {
            return lineItem.getQuantity();
        }

        @Override
        public long getIdentifier(LineItem lineItem) {
            return lineItem.getQuantity() * 100L;
        }
    }
    ,
    EXTENDED_PRICE("l_extendedprice", TpchColumnTypes.DOUBLE){

        @Override
        public double getDouble(LineItem lineItem) {
            return lineItem.getExtendedPrice();
        }

        @Override
        public long getIdentifier(LineItem lineItem) {
            return lineItem.getExtendedPriceInCents();
        }
    }
    ,
    DISCOUNT("l_discount", TpchColumnTypes.DOUBLE){

        @Override
        public double getDouble(LineItem lineItem) {
            return lineItem.getDiscount();
        }

        @Override
        public long getIdentifier(LineItem lineItem) {
            return lineItem.getDiscountPercent();
        }
    }
    ,
    TAX("l_tax", TpchColumnTypes.DOUBLE){

        @Override
        public double getDouble(LineItem lineItem) {
            return lineItem.getTax();
        }

        @Override
        public long getIdentifier(LineItem lineItem) {
            return lineItem.getTaxPercent();
        }
    }
    ,
    RETURN_FLAG("l_returnflag", TpchColumnTypes.varchar(1L)){

        @Override
        public String getString(LineItem lineItem) {
            return lineItem.getReturnFlag();
        }
    }
    ,
    STATUS("l_linestatus", TpchColumnTypes.varchar(1L)){

        @Override
        public String getString(LineItem lineItem) {
            return lineItem.getStatus();
        }
    }
    ,
    SHIP_DATE("l_shipdate", TpchColumnTypes.DATE){

        @Override
        public String getString(LineItem lineItem) {
            return GenerateUtils.formatDate(this.getDate(lineItem));
        }

        @Override
        public int getDate(LineItem lineItem) {
            return lineItem.getShipDate();
        }
    }
    ,
    COMMIT_DATE("l_commitdate", TpchColumnTypes.DATE){

        @Override
        public String getString(LineItem lineItem) {
            return GenerateUtils.formatDate(this.getDate(lineItem));
        }

        @Override
        public int getDate(LineItem lineItem) {
            return lineItem.getCommitDate();
        }
    }
    ,
    RECEIPT_DATE("l_receiptdate", TpchColumnTypes.DATE){

        @Override
        public String getString(LineItem lineItem) {
            return GenerateUtils.formatDate(this.getDate(lineItem));
        }

        @Override
        public int getDate(LineItem lineItem) {
            return lineItem.getReceiptDate();
        }
    }
    ,
    SHIP_INSTRUCTIONS("l_shipinstruct", TpchColumnTypes.varchar(25L)){

        @Override
        public String getString(LineItem lineItem) {
            return lineItem.getShipInstructions();
        }
    }
    ,
    SHIP_MODE("l_shipmode", TpchColumnTypes.varchar(10L)){

        @Override
        public String getString(LineItem lineItem) {
            return lineItem.getShipMode();
        }
    }
    ,
    COMMENT("l_comment", TpchColumnTypes.varchar(44L)){

        @Override
        public String getString(LineItem lineItem) {
            return lineItem.getComment();
        }
    };

    private final String columnName;
    private final TpchColumnType type;

    private LineItemColumn(String columnName, TpchColumnType type) {
        this.columnName = columnName;
        this.type = type;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public TpchColumnType getType() {
        return this.type;
    }

    @Override
    public double getDouble(LineItem lineItem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getIdentifier(LineItem lineItem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInteger(LineItem lineItem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(LineItem lineItem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDate(LineItem entity) {
        throw new UnsupportedOperationException();
    }
}

