/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.trino.tpch;

import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import org.apache.kyuubi.shade.com.google.common.collect.ImmutableList;

public final class GenerateUtils {
    public static final int GENERATED_DATE_EPOCH_OFFSET = 83966;
    public static final int MIN_GENERATE_DATE = 92001;
    private static final int CURRENT_DATE = 95168;
    public static final int TOTAL_DATE_RANGE = 2557;
    private static final int[] MONTH_YEAR_DAY_START = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static final List<String> DATE_STRING_INDEX = GenerateUtils.makeDateStringIndex();

    private GenerateUtils() {
    }

    public static long calculateRowCount(int scaleBase, double scaleFactor, int part, int partCount) {
        long totalRowCount = (long)((double)scaleBase * scaleFactor);
        long rowCount = totalRowCount / (long)partCount;
        if (part == partCount) {
            rowCount += totalRowCount % (long)partCount;
        }
        return rowCount;
    }

    public static long calculateStartIndex(int scaleBase, double scaleFactor, int part, int partCount) {
        long totalRowCount = (long)((double)scaleBase * scaleFactor);
        long rowsPerPart = totalRowCount / (long)partCount;
        return rowsPerPart * (long)(part - 1);
    }

    public static int toEpochDate(int generatedDate) {
        return generatedDate - 83966;
    }

    public static String formatDate(int epochDate) {
        return DATE_STRING_INDEX.get(epochDate - 8035);
    }

    private static List<String> makeDateStringIndex() {
        ImmutableList.Builder dates = ImmutableList.builder();
        for (int i = 0; i < 2557; ++i) {
            dates.add(GenerateUtils.makeDate(i + 1));
        }
        return dates.build();
    }

    private static String makeDate(int index) {
        int y = GenerateUtils.julian(index + 92001 - 1) / 1000;
        int d = GenerateUtils.julian(index + 92001 - 1) % 1000;
        int m = 0;
        while (d > MONTH_YEAR_DAY_START[m] + GenerateUtils.leapYearAdjustment(y, m)) {
            ++m;
        }
        int dy = d - MONTH_YEAR_DAY_START[m - 1] - (GenerateUtils.isLeapYear(y) && m > 2 ? 1 : 0);
        return String.format(Locale.ENGLISH, "19%02d-%02d-%02d", y, m, dy);
    }

    private static int leapYearAdjustment(int year, int month) {
        return GenerateUtils.isLeapYear(year) && month >= 2 ? 1 : 0;
    }

    public static boolean isInPast(int date) {
        return GenerateUtils.julian(date) <= 95168;
    }

    private static int julian(int date) {
        int year;
        int yearEnd;
        int offset = date - 92001;
        int result = 92001;
        while (result + offset > (yearEnd = year * 1000 + 365 + (GenerateUtils.isLeapYear(year = result / 1000) ? 1 : 0))) {
            offset -= yearEnd - result + 1;
            result += 1000;
        }
        return result + offset;
    }

    private static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0;
    }

    public static String formatMoney(long value) {
        return new BigDecimal(value).divide(new BigDecimal(100)).setScale(2).toString();
    }
}

