/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.trino.tpch;

import org.apache.kyuubi.shade.io.trino.tpch.Customer;
import org.apache.kyuubi.shade.io.trino.tpch.TpchColumn;
import org.apache.kyuubi.shade.io.trino.tpch.TpchColumnType;
import org.apache.kyuubi.shade.io.trino.tpch.TpchColumnTypes;

public enum CustomerColumn implements TpchColumn<Customer>
{
    CUSTOMER_KEY("c_custkey", TpchColumnTypes.IDENTIFIER){

        @Override
        public long getIdentifier(Customer customer) {
            return customer.getCustomerKey();
        }
    }
    ,
    NAME("c_name", TpchColumnTypes.varchar(25L)){

        @Override
        public String getString(Customer customer) {
            return customer.getName();
        }
    }
    ,
    ADDRESS("c_address", TpchColumnTypes.varchar(40L)){

        @Override
        public String getString(Customer customer) {
            return customer.getAddress();
        }
    }
    ,
    NATION_KEY("c_nationkey", TpchColumnTypes.IDENTIFIER){

        @Override
        public long getIdentifier(Customer customer) {
            return customer.getNationKey();
        }
    }
    ,
    PHONE("c_phone", TpchColumnTypes.varchar(15L)){

        @Override
        public String getString(Customer customer) {
            return customer.getPhone();
        }
    }
    ,
    ACCOUNT_BALANCE("c_acctbal", TpchColumnTypes.DOUBLE){

        @Override
        public double getDouble(Customer customer) {
            return customer.getAccountBalance();
        }

        @Override
        public long getIdentifier(Customer customer) {
            return customer.getAccountBalanceInCents();
        }
    }
    ,
    MARKET_SEGMENT("c_mktsegment", TpchColumnTypes.varchar(10L)){

        @Override
        public String getString(Customer customer) {
            return customer.getMarketSegment();
        }
    }
    ,
    COMMENT("c_comment", TpchColumnTypes.varchar(117L)){

        @Override
        public String getString(Customer customer) {
            return customer.getComment();
        }
    };

    private final String columnName;
    private final TpchColumnType type;

    private CustomerColumn(String columnName, TpchColumnType type) {
        this.columnName = columnName;
        this.type = type;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public TpchColumnType getType() {
        return this.type;
    }

    @Override
    public double getDouble(Customer customer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getIdentifier(Customer customer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInteger(Customer customer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(Customer customer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDate(Customer entity) {
        throw new UnsupportedOperationException();
    }
}

