/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.spark.connector.tpch;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.kyuubi.shade.io.trino.tpch.GenerateUtils;
import org.apache.kyuubi.shade.io.trino.tpch.TpchColumn;
import org.apache.kyuubi.shade.io.trino.tpch.TpchColumnType;
import org.apache.kyuubi.shade.io.trino.tpch.TpchEntity;
import org.apache.kyuubi.shade.io.trino.tpch.TpchTable;
import org.apache.kyuubi.spark.connector.tpch.TPCHSchemaUtils$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001\u0002\u000b\u0016\u0001\tB\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0015\"Aa\n\u0001B\u0001B\u0003%q\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003P\u0011!\u0019\u0006A!A!\u0002\u0013!\u0006\"\u0002.\u0001\t\u0003Y\u0006bB2\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007g\u0002\u0001\u000b\u0011B3\t\u000fm\u0004!\u0019!C\u0005y\"9\u0011Q\u0002\u0001!\u0002\u0013i\bBCA\b\u0001!\u0015\r\u0011\"\u0003\u0002\u0012!I\u00111\u0005\u0001C\u0002\u0013%\u0011Q\u0005\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u0002(!Y\u0011Q\b\u0001A\u0002\u0003\u0007I\u0011BA \u0011-\t\t\u0005\u0001a\u0001\u0002\u0004%I!a\u0011\t\u0015\u0005=\u0003\u00011A\u0001B\u0003&Q\u0007C\u0004\u0002R\u0001!\t%a\u0015\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^!9\u0011q\f\u0001\u0005B\u0005\u0005$a\u0005+Q\u0007\"\u0003\u0016M\u001d;ji&|gNU3bI\u0016\u0014(B\u0001\f\u0018\u0003\u0011!\bo\u00195\u000b\u0005aI\u0012!C2p]:,7\r^8s\u0015\tQ2$A\u0003ta\u0006\u00148N\u0003\u0002\u001d;\u000511._;vE&T!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sO\u000e\u00011c\u0001\u0001$WA\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0005Y\u0006twMC\u0001)\u0003\u0011Q\u0017M^1\n\u0005)*#AB(cU\u0016\u001cG\u000fE\u0002-gUj\u0011!\f\u0006\u0003]=\nAA]3bI*\u0011\u0001\u0004\r\u0006\u0003cI\n1a]9m\u0015\tQR$\u0003\u00025[\ty\u0001+\u0019:uSRLwN\u001c*fC\u0012,'\u000f\u0005\u00027s5\tqG\u0003\u00029a\u0005A1-\u0019;bYf\u001cH/\u0003\u0002;o\tY\u0011J\u001c;fe:\fGNU8x\u0003\u0015!\u0018M\u00197f!\tidI\u0004\u0002?\tB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011)I\u0001\u0007yI|w\u000e\u001e \u000b\u0003\r\u000bQa]2bY\u0006L!!\u0012\"\u0002\rA\u0013X\rZ3g\u0013\t9\u0005J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000b\n\u000bQa]2bY\u0016\u0004\"a\u0013'\u000e\u0003\tK!!\u0014\"\u0003\r\u0011{WO\u00197f\u0003-\u0001\u0018M]1mY\u0016d\u0017n]7\u0011\u0005-\u0003\u0016BA)C\u0005\rIe\u000e^\u0001\u0006S:$W\r_\u0001\u0007g\u000eDW-\\1\u0011\u0005UCV\"\u0001,\u000b\u0005]\u0003\u0014!\u0002;za\u0016\u001c\u0018BA-W\u0005)\u0019FO];diRK\b/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\rqsv\fY1c!\ti\u0006!D\u0001\u0016\u0011\u0015Yd\u00011\u0001=\u0011\u0015Ie\u00011\u0001K\u0011\u0015qe\u00011\u0001P\u0011\u0015\u0011f\u00011\u0001P\u0011\u0015\u0019f\u00011\u0001U\u0003%!\bo\u00195UC\ndW-F\u0001fa\t1\u0017\u000fE\u0002h[>l\u0011\u0001\u001b\u0006\u0003-%T!A[6\u0002\u000bQ\u0014\u0018N\\8\u000b\u00031\f!![8\n\u00059D'!\u0003+qG\"$\u0016M\u00197f!\t\u0001\u0018\u000f\u0004\u0001\u0005\u0013ID\u0011\u0011!A\u0001\u0006\u0003!(AA 1\u0003)!\bo\u00195UC\ndW\rI\t\u0003kb\u0004\"a\u0013<\n\u0005]\u0014%a\u0002(pi\"Lgn\u001a\t\u0003OfL!A\u001f5\u0003\u0015Q\u00038\r[#oi&$\u00180A\u0004d_2,XN\\:\u0016\u0003u\u0004RA`A\u0002\u0003\u000fi\u0011a \u0006\u0004\u0003\u00039\u0013\u0001B;uS2L1!!\u0002\u0000\u0005\u0011a\u0015n\u001d;\u0011\t\u001d\fI\u0001_\u0005\u0004\u0003\u0017A'A\u0003+qG\"\u001cu\u000e\\;n]\u0006A1m\u001c7v[:\u001c\b%A\u0004eCR,g)\u001c;\u0016\u0005\u0005M\u0001\u0003BA\u000b\u0003?i!!a\u0006\u000b\t\u0005e\u00111D\u0001\u0007M>\u0014X.\u0019;\u000b\u0007\u0005uq%\u0001\u0003uS6,\u0017\u0002BA\u0011\u0003/\u0011\u0011\u0003R1uKRKW.\u001a$pe6\fG\u000f^3s\u0003!IG/\u001a:bi>\u0014XCAA\u0014a\u0019\tI#!\r\u0002<A)a0a\u000b\u00020%\u0019\u0011QF@\u0003\u0011%#XM]1u_J\u00042\u0001]A\u0019\t-\t\u0019$DA\u0001\u0002\u0003\u0015\t!a\u000e\u0003\u0005}\u000b\u0014!C5uKJ\fGo\u001c:!#\r\tI\u0004\u001f\t\u0004a\u0006mB!\u0003:\t\u0003\u0003\u0005\tQ!\u0001u\u0003)\u0019WO\u001d:f]R\u0014vn^\u000b\u0002k\u0005q1-\u001e:sK:$(k\\<`I\u0015\fH\u0003BA#\u0003\u0017\u00022aSA$\u0013\r\tIE\u0011\u0002\u0005+:LG\u000f\u0003\u0005\u0002N=\t\t\u00111\u00016\u0003\rAH%M\u0001\fGV\u0014(/\u001a8u%><\b%\u0001\u0003oKb$HCAA+!\rY\u0015qK\u0005\u0004\u00033\u0012%a\u0002\"p_2,\u0017M\\\u0001\u0004O\u0016$H#A\u001b\u0002\u000b\rdwn]3\u0015\u0005\u0005\u0015\u0003")
public class TPCHPartitionReader
implements PartitionReader<InternalRow> {
    private DateTimeFormatter dateFmt;
    private final StructType schema;
    private final TpchTable<? extends TpchEntity> tpchTable;
    private final List<TpchColumn<TpchEntity>> columns;
    private final Iterator<? extends TpchEntity> iterator;
    private InternalRow currentRow;
    private volatile boolean bitmap$0;

    public CustomTaskMetric[] currentMetricsValues() {
        return super.currentMetricsValues();
    }

    private TpchTable<? extends TpchEntity> tpchTable() {
        return this.tpchTable;
    }

    private List<TpchColumn<TpchEntity>> columns() {
        return this.columns;
    }

    private DateTimeFormatter dateFmt$lzycompute() {
        TPCHPartitionReader tPCHPartitionReader = this;
        synchronized (tPCHPartitionReader) {
            if (!this.bitmap$0) {
                this.dateFmt = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                this.bitmap$0 = true;
            }
        }
        return this.dateFmt;
    }

    private DateTimeFormatter dateFmt() {
        if (!this.bitmap$0) {
            return this.dateFmt$lzycompute();
        }
        return this.dateFmt;
    }

    private Iterator<? extends TpchEntity> iterator() {
        return this.iterator;
    }

    private InternalRow currentRow() {
        return this.currentRow;
    }

    private void currentRow_$eq(InternalRow x$1) {
        this.currentRow = x$1;
    }

    public boolean next() {
        boolean hasNext;
        block0: {
            hasNext = this.iterator().hasNext();
            if (!hasNext) break block0;
            TpchEntity row = this.iterator().next();
            ArrayBuffer rowValue = new ArrayBuffer();
            this.columns().stream().forEach(column -> {
                TpchColumnType.Base baseType = column.getType().getBase();
                String value = "";
                TpchColumnType.Base base = baseType;
                if (((Object)((Object)TpchColumnType.Base.IDENTIFIER)).equals((Object)base)) {
                    value = new StringBuilder(0).append(value).append(column.getIdentifier(row)).toString();
                } else if (((Object)((Object)TpchColumnType.Base.INTEGER)).equals((Object)base)) {
                    value = new StringBuilder(0).append(value).append(column.getInteger(row)).toString();
                } else if (((Object)((Object)TpchColumnType.Base.DATE)).equals((Object)base)) {
                    value = new StringBuilder(0).append(value).append(column.getDate(row)).toString();
                } else if (((Object)((Object)TpchColumnType.Base.DOUBLE)).equals((Object)base)) {
                    value = new StringBuilder(0).append(value).append(column.getDouble(row)).toString();
                } else if (((Object)((Object)TpchColumnType.Base.VARCHAR)).equals((Object)base)) {
                    value = new StringBuilder(0).append(value).append(column.getString(row)).toString();
                } else {
                    throw new MatchError((Object)base);
                }
                rowValue.$plus$eq((Object)value);
            });
            ArrayBuffer rowAny = new ArrayBuffer();
            ((TraversableLike)rowValue.zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String string;
                    String string2;
                    int i;
                    String value = (String)tuple2._1();
                    Tuple2 tuple22 = new Tuple2((Object)value, (Object)$this.schema.apply(i = tuple2._2$mcI$sp()).dataType());
                    if (tuple22 != null && (string2 = (String)tuple22._1()) == null) {
                        return null;
                    }
                    if (tuple22 != null && "".equals(string = (String)tuple22._1())) {
                        return null;
                    }
                    if (tuple22 != null) {
                        String value2 = (String)tuple22._1();
                        DataType dataType = (DataType)tuple22._2();
                        if (IntegerType$.MODULE$.equals(dataType)) {
                            return rowAny.$plus$eq((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(value2)).toInt()));
                        }
                    }
                    if (tuple22 != null) {
                        String value3 = (String)tuple22._1();
                        DataType dataType = (DataType)tuple22._2();
                        if (LongType$.MODULE$.equals(dataType)) {
                            return rowAny.$plus$eq((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(value3)).toLong()));
                        }
                    }
                    if (tuple22 != null) {
                        String value4 = (String)tuple22._1();
                        DataType dataType = (DataType)tuple22._2();
                        if (DoubleType$.MODULE$.equals(dataType)) {
                            return rowAny.$plus$eq((Object)BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(value4)).toDouble()));
                        }
                    }
                    if (tuple22 != null) {
                        String value5 = (String)tuple22._1();
                        DataType dataType = (DataType)tuple22._2();
                        if (DateType$.MODULE$.equals(dataType)) {
                            return rowAny.$plus$eq((Object)BoxesRunTime.boxToInteger((int)((int)LocalDate.parse(GenerateUtils.formatDate(new StringOps(Predef$.MODULE$.augmentString(value5)).toInt()), this.dateFmt()).toEpochDay())));
                        }
                    }
                    if (tuple22 != null) {
                        String value6 = (String)tuple22._1();
                        DataType dataType = (DataType)tuple22._2();
                        if (StringType$.MODULE$.equals(dataType)) {
                            return rowAny.$plus$eq((Object)UTF8String.fromString((String)value6));
                        }
                    }
                    if (tuple22 != null) {
                        String value7 = (String)tuple22._1();
                        DataType dataType = (DataType)tuple22._2();
                        if (dataType instanceof CharType) {
                            return rowAny.$plus$eq((Object)UTF8String.fromString((String)value7));
                        }
                    }
                    if (tuple22 != null) {
                        String value8 = (String)tuple22._1();
                        DataType dataType = (DataType)tuple22._2();
                        if (dataType instanceof VarcharType) {
                            return rowAny.$plus$eq((Object)UTF8String.fromString((String)value8));
                        }
                    }
                    if (tuple22 != null) {
                        String value9 = (String)tuple22._1();
                        DataType dataType = (DataType)tuple22._2();
                        if (DecimalType$.MODULE$.unapply(dataType)) {
                            return rowAny.$plus$eq((Object)Decimal$.MODULE$.apply(value9));
                        }
                    }
                    if (tuple22 != null) {
                        String value10 = (String)tuple22._1();
                        DataType dt = (DataType)tuple22._2();
                        throw new IllegalArgumentException(new StringBuilder(15).append("value: ").append(value10).append(", type: ").append(dt).toString());
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError((Object)tuple2);
            }, ArrayBuffer$.MODULE$.canBuildFrom());
            this.currentRow_$eq(InternalRow$.MODULE$.fromSeq((Seq)rowAny));
        }
        return hasNext;
    }

    public InternalRow get() {
        return this.currentRow();
    }

    public void close() {
    }

    public TPCHPartitionReader(String table, double scale, int parallelism, int index, StructType schema) {
        this.schema = schema;
        this.tpchTable = TpchTable.getTable(table);
        this.columns = this.tpchTable().getColumns();
        this.iterator = TPCHSchemaUtils$.MODULE$.normalize(scale).equals("0") ? new Iterator<TpchEntity>(null){

            public void remove() {
                Iterator.super.remove();
            }

            public void forEachRemaining(Consumer<? super TpchEntity> x$1) {
                Iterator.super.forEachRemaining(x$1);
            }

            public boolean hasNext() {
                return false;
            }

            public TpchEntity next() {
                throw new NoSuchElementException("next on empty iterator");
            }
        } : this.tpchTable().createGenerator(scale, index, parallelism).iterator();
    }
}

