/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.spark.connector.common;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.network.util.ByteUnit;

public class JavaUtils {
    private static final Map<String, TimeUnit> timeSuffixes = new HashMap<String, TimeUnit>();
    private static final Map<String, ByteUnit> byteSuffixes;

    public static long timeStringAs(String str, TimeUnit unit) {
        String lower = str.toLowerCase(Locale.ROOT).trim();
        try {
            Matcher m = Pattern.compile("(-?[0-9]+)([a-z]+)?").matcher(lower);
            if (!m.matches()) {
                throw new NumberFormatException("Failed to parse time string: " + str);
            }
            long val = Long.parseLong(m.group(1));
            String suffix = m.group(2);
            if (suffix != null && !timeSuffixes.containsKey(suffix)) {
                throw new NumberFormatException("Invalid suffix: \"" + suffix + "\"");
            }
            return unit.convert(val, suffix != null ? timeSuffixes.get(suffix) : unit);
        }
        catch (NumberFormatException e) {
            String timeError = "Time must be specified as seconds (s), milliseconds (ms), microseconds (us), minutes (m or min), hour (h), or day (d). E.g. 50s, 100ms, or 250us.";
            throw new NumberFormatException(timeError + "\n" + e.getMessage());
        }
    }

    public static long timeStringAsMs(String str) {
        return JavaUtils.timeStringAs(str, TimeUnit.MILLISECONDS);
    }

    public static long timeStringAsSec(String str) {
        return JavaUtils.timeStringAs(str, TimeUnit.SECONDS);
    }

    public static long byteStringAs(String str, ByteUnit unit) {
        String lower = str.toLowerCase(Locale.ROOT).trim();
        try {
            Matcher m = Pattern.compile("([0-9]+)([a-z]+)?").matcher(lower);
            Matcher fractionMatcher = Pattern.compile("([0-9]+\\.[0-9]+)([a-z]+)?").matcher(lower);
            if (m.matches()) {
                long val = Long.parseLong(m.group(1));
                String suffix = m.group(2);
                if (suffix != null && !byteSuffixes.containsKey(suffix)) {
                    throw new NumberFormatException("Invalid suffix: \"" + suffix + "\"");
                }
                return unit.convertFrom(val, suffix != null ? byteSuffixes.get(suffix) : unit);
            }
            if (fractionMatcher.matches()) {
                throw new NumberFormatException("Fractional values are not supported. Input was: " + fractionMatcher.group(1));
            }
            throw new NumberFormatException("Failed to parse byte string: " + str);
        }
        catch (NumberFormatException e) {
            String byteError = "Size must be specified as bytes (b), kibibytes (k), mebibytes (m), gibibytes (g), tebibytes (t), or pebibytes(p). E.g. 50b, 100k, or 250m.";
            throw new NumberFormatException(byteError + "\n" + e.getMessage());
        }
    }

    public static long byteStringAsBytes(String str) {
        return JavaUtils.byteStringAs(str, ByteUnit.BYTE);
    }

    public static long byteStringAsKb(String str) {
        return JavaUtils.byteStringAs(str, ByteUnit.KiB);
    }

    public static long byteStringAsMb(String str) {
        return JavaUtils.byteStringAs(str, ByteUnit.MiB);
    }

    public static long byteStringAsGb(String str) {
        return JavaUtils.byteStringAs(str, ByteUnit.GiB);
    }

    static {
        timeSuffixes.put("us", TimeUnit.MICROSECONDS);
        timeSuffixes.put("ms", TimeUnit.MILLISECONDS);
        timeSuffixes.put("s", TimeUnit.SECONDS);
        timeSuffixes.put("m", TimeUnit.MINUTES);
        timeSuffixes.put("min", TimeUnit.MINUTES);
        timeSuffixes.put("h", TimeUnit.HOURS);
        timeSuffixes.put("d", TimeUnit.DAYS);
        byteSuffixes = new HashMap<String, ByteUnit>();
        byteSuffixes.put("b", ByteUnit.BYTE);
        byteSuffixes.put("k", ByteUnit.KiB);
        byteSuffixes.put("kb", ByteUnit.KiB);
        byteSuffixes.put("m", ByteUnit.MiB);
        byteSuffixes.put("mb", ByteUnit.MiB);
        byteSuffixes.put("g", ByteUnit.GiB);
        byteSuffixes.put("gb", ByteUnit.GiB);
        byteSuffixes.put("t", ByteUnit.TiB);
        byteSuffixes.put("tb", ByteUnit.TiB);
        byteSuffixes.put("p", ByteUnit.PiB);
        byteSuffixes.put("pb", ByteUnit.PiB);
    }
}

