/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.trino.tpch;

import java.util.List;
import java.util.Map;
import org.apache.kyuubi.shade.com.google.common.base.Preconditions;
import org.apache.kyuubi.shade.com.google.common.collect.ImmutableList;
import org.apache.kyuubi.shade.com.google.common.collect.ImmutableMap;
import org.apache.kyuubi.shade.com.google.common.collect.Maps;
import org.apache.kyuubi.shade.io.trino.tpch.Customer;
import org.apache.kyuubi.shade.io.trino.tpch.CustomerColumn;
import org.apache.kyuubi.shade.io.trino.tpch.CustomerGenerator;
import org.apache.kyuubi.shade.io.trino.tpch.LineItem;
import org.apache.kyuubi.shade.io.trino.tpch.LineItemColumn;
import org.apache.kyuubi.shade.io.trino.tpch.LineItemGenerator;
import org.apache.kyuubi.shade.io.trino.tpch.Nation;
import org.apache.kyuubi.shade.io.trino.tpch.NationColumn;
import org.apache.kyuubi.shade.io.trino.tpch.NationGenerator;
import org.apache.kyuubi.shade.io.trino.tpch.Order;
import org.apache.kyuubi.shade.io.trino.tpch.OrderColumn;
import org.apache.kyuubi.shade.io.trino.tpch.OrderGenerator;
import org.apache.kyuubi.shade.io.trino.tpch.Part;
import org.apache.kyuubi.shade.io.trino.tpch.PartColumn;
import org.apache.kyuubi.shade.io.trino.tpch.PartGenerator;
import org.apache.kyuubi.shade.io.trino.tpch.PartSupplier;
import org.apache.kyuubi.shade.io.trino.tpch.PartSupplierColumn;
import org.apache.kyuubi.shade.io.trino.tpch.PartSupplierGenerator;
import org.apache.kyuubi.shade.io.trino.tpch.Region;
import org.apache.kyuubi.shade.io.trino.tpch.RegionColumn;
import org.apache.kyuubi.shade.io.trino.tpch.RegionGenerator;
import org.apache.kyuubi.shade.io.trino.tpch.Supplier;
import org.apache.kyuubi.shade.io.trino.tpch.SupplierColumn;
import org.apache.kyuubi.shade.io.trino.tpch.SupplierGenerator;
import org.apache.kyuubi.shade.io.trino.tpch.TpchColumn;
import org.apache.kyuubi.shade.io.trino.tpch.TpchEntity;

public abstract class TpchTable<E extends TpchEntity> {
    public static final TpchTable<Customer> CUSTOMER = new TpchTable<Customer>("customer", (TpchColumn[])CustomerColumn.values()){

        @Override
        public Iterable<Customer> createGenerator(double scaleFactor, int part, int partCount) {
            return new CustomerGenerator(scaleFactor, part, partCount);
        }
    };
    public static final TpchTable<Order> ORDERS = new TpchTable<Order>("orders", (TpchColumn[])OrderColumn.values()){

        @Override
        public Iterable<Order> createGenerator(double scaleFactor, int part, int partCount) {
            return new OrderGenerator(scaleFactor, part, partCount);
        }
    };
    public static final TpchTable<LineItem> LINE_ITEM = new TpchTable<LineItem>("lineitem", (TpchColumn[])LineItemColumn.values()){

        @Override
        public Iterable<LineItem> createGenerator(double scaleFactor, int part, int partCount) {
            return new LineItemGenerator(scaleFactor, part, partCount);
        }
    };
    public static final TpchTable<Part> PART = new TpchTable<Part>("part", (TpchColumn[])PartColumn.values()){

        @Override
        public Iterable<Part> createGenerator(double scaleFactor, int part, int partCount) {
            return new PartGenerator(scaleFactor, part, partCount);
        }
    };
    public static final TpchTable<PartSupplier> PART_SUPPLIER = new TpchTable<PartSupplier>("partsupp", (TpchColumn[])PartSupplierColumn.values()){

        @Override
        public Iterable<PartSupplier> createGenerator(double scaleFactor, int part, int partCount) {
            return new PartSupplierGenerator(scaleFactor, part, partCount);
        }
    };
    public static final TpchTable<Supplier> SUPPLIER = new TpchTable<Supplier>("supplier", (TpchColumn[])SupplierColumn.values()){

        @Override
        public Iterable<Supplier> createGenerator(double scaleFactor, int part, int partCount) {
            return new SupplierGenerator(scaleFactor, part, partCount);
        }
    };
    public static final TpchTable<Nation> NATION = new TpchTable<Nation>("nation", (TpchColumn[])NationColumn.values()){

        @Override
        public Iterable<Nation> createGenerator(double scaleFactor, int part, int partCount) {
            if (part != 1) {
                return ImmutableList.of();
            }
            return new NationGenerator();
        }
    };
    public static final TpchTable<Region> REGION = new TpchTable<Region>("region", (TpchColumn[])RegionColumn.values()){

        @Override
        public Iterable<Region> createGenerator(double scaleFactor, int part, int partCount) {
            if (part != 1) {
                return ImmutableList.of();
            }
            return new RegionGenerator();
        }
    };
    private static final List<TpchTable<?>> TABLES = ImmutableList.of(CUSTOMER, ORDERS, LINE_ITEM, PART, PART_SUPPLIER, SUPPLIER, NATION, REGION);
    private static final Map<String, TpchTable<?>> TABLES_BY_NAME = Maps.uniqueIndex(TABLES, TpchTable::getTableName);
    private final String tableName;
    private final List<TpchColumn<E>> columns;
    private final Map<String, TpchColumn<E>> columnsByName;

    public static List<TpchTable<?>> getTables() {
        return TABLES;
    }

    public static TpchTable<?> getTable(String tableName) {
        TpchTable<?> table = TABLES_BY_NAME.get(tableName);
        Preconditions.checkArgument(table != null, "Table %s not found", (Object)tableName);
        return table;
    }

    private TpchTable(String tableName, TpchColumn<E>[] columns) {
        this.tableName = tableName;
        this.columns = ImmutableList.copyOf(columns);
        this.columnsByName = new ImmutableMap.Builder().putAll(Maps.uniqueIndex(this.columns, TpchColumn::getColumnName)).putAll(Maps.uniqueIndex(this.columns, TpchColumn::getSimplifiedColumnName)).build();
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<TpchColumn<E>> getColumns() {
        return this.columns;
    }

    public TpchColumn<E> getColumn(String columnName) {
        TpchColumn<E> column = this.columnsByName.get(columnName);
        Preconditions.checkArgument(column != null, "Table %s does not have a column %s", (Object)this.tableName, (Object)columnName);
        return column;
    }

    public abstract Iterable<E> createGenerator(double var1, int var3, int var4);
}

