/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.trino.tpch;

import org.apache.kyuubi.shade.io.trino.tpch.AbstractRandomInt;
import org.apache.kyuubi.shade.io.trino.tpch.TextPool;

public class RandomText
extends AbstractRandomInt {
    private static final double LOW_LENGTH_MULTIPLIER = 0.4;
    private static final double HIGH_LENGTH_MULTIPLIER = 1.6;
    private final TextPool textPool;
    private final int minLength;
    private final int maxLength;

    public RandomText(long seed, TextPool textPool, double averageTextLength) {
        this(seed, textPool, averageTextLength, 1);
    }

    public RandomText(long seed, TextPool textPool, double averageTextLength, int expectedRowCount) {
        super(seed, expectedRowCount * 2);
        this.textPool = textPool;
        this.minLength = (int)(averageTextLength * 0.4);
        this.maxLength = (int)(averageTextLength * 1.6);
    }

    public String nextValue() {
        int offset = this.nextInt(0, this.textPool.size() - this.maxLength);
        int length = this.nextInt(this.minLength, this.maxLength);
        return this.textPool.getText(offset, offset + length);
    }
}

