/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.trino.tpch;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.kyuubi.shade.com.google.common.base.Joiner;
import org.apache.kyuubi.shade.com.google.common.base.Preconditions;
import org.apache.kyuubi.shade.io.trino.tpch.AbstractRandomInt;
import org.apache.kyuubi.shade.io.trino.tpch.Distribution;

public class RandomStringSequence
extends AbstractRandomInt {
    private final int count;
    private final Distribution distribution;

    public RandomStringSequence(long seed, int count, Distribution distribution) {
        this(seed, count, distribution, 1);
    }

    public RandomStringSequence(long seed, int count, Distribution distribution, int expectedRowCount) {
        super(seed, distribution.size() * expectedRowCount);
        this.count = count;
        this.distribution = distribution;
    }

    public String nextValue() {
        ArrayList<String> values = new ArrayList<String>(this.distribution.getValues());
        Preconditions.checkArgument(this.count < values.size(), "Count must be less tess than distribution size");
        for (int currentPosition = 0; currentPosition < this.count; ++currentPosition) {
            int swapPosition = this.nextInt(currentPosition, values.size() - 1);
            Collections.swap(values, currentPosition, swapPosition);
        }
        String result = Joiner.on(' ').join(values.subList(0, this.count));
        return result;
    }
}

