/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.trino.tpch;

import org.apache.kyuubi.shade.io.trino.tpch.AbstractRandomInt;

public class RandomAlphaNumeric
extends AbstractRandomInt {
    private static final char[] ALPHA_NUMERIC = "0123456789abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ,".toCharArray();
    private static final double LOW_LENGTH_MULTIPLIER = 0.4;
    private static final double HIGH_LENGTH_MULTIPLIER = 1.6;
    private static final int USAGE_PER_ROW = 9;
    private final int minLength;
    private final int maxLength;

    public RandomAlphaNumeric(long seed, int averageLength) {
        this(seed, averageLength, 1);
    }

    public RandomAlphaNumeric(long seed, int averageLength, int expectedRowCount) {
        super(seed, 9 * expectedRowCount);
        this.minLength = (int)((double)averageLength * 0.4);
        this.maxLength = (int)((double)averageLength * 1.6);
    }

    public String nextValue() {
        char[] buffer = new char[this.nextInt(this.minLength, this.maxLength)];
        long charIndex = 0L;
        for (int i = 0; i < buffer.length; ++i) {
            if (i % 5 == 0) {
                charIndex = this.nextInt(0, Integer.MAX_VALUE);
            }
            buffer[i] = ALPHA_NUMERIC[(int)(charIndex & 0x3FL)];
            charIndex >>= 6;
        }
        return new String(buffer);
    }
}

