/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.trino.tpch;

import org.apache.kyuubi.shade.io.trino.tpch.PartSupplier;
import org.apache.kyuubi.shade.io.trino.tpch.TpchColumn;
import org.apache.kyuubi.shade.io.trino.tpch.TpchColumnType;
import org.apache.kyuubi.shade.io.trino.tpch.TpchColumnTypes;

public enum PartSupplierColumn implements TpchColumn<PartSupplier>
{
    PART_KEY("ps_partkey", TpchColumnTypes.IDENTIFIER){

        @Override
        public long getIdentifier(PartSupplier partSupplier) {
            return partSupplier.getPartKey();
        }
    }
    ,
    SUPPLIER_KEY("ps_suppkey", TpchColumnTypes.IDENTIFIER){

        @Override
        public long getIdentifier(PartSupplier partSupplier) {
            return partSupplier.getSupplierKey();
        }
    }
    ,
    AVAILABLE_QUANTITY("ps_availqty", TpchColumnTypes.INTEGER){

        @Override
        public int getInteger(PartSupplier partSupplier) {
            return partSupplier.getAvailableQuantity();
        }
    }
    ,
    SUPPLY_COST("ps_supplycost", TpchColumnTypes.DOUBLE){

        @Override
        public double getDouble(PartSupplier partSupplier) {
            return partSupplier.getSupplyCost();
        }

        @Override
        public long getIdentifier(PartSupplier partSupplier) {
            return partSupplier.getSupplyCostInCents();
        }
    }
    ,
    COMMENT("ps_comment", TpchColumnTypes.varchar(199L)){

        @Override
        public String getString(PartSupplier partSupplier) {
            return partSupplier.getComment();
        }
    };

    private final String columnName;
    private final TpchColumnType type;

    private PartSupplierColumn(String columnName, TpchColumnType type) {
        this.columnName = columnName;
        this.type = type;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public TpchColumnType getType() {
        return this.type;
    }

    @Override
    public double getDouble(PartSupplier partSupplier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getIdentifier(PartSupplier partSupplier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInteger(PartSupplier partSupplier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(PartSupplier partSupplier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDate(PartSupplier entity) {
        throw new UnsupportedOperationException();
    }
}

