/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.trino.tpch;

import java.util.Locale;
import java.util.Objects;
import org.apache.kyuubi.shade.io.trino.tpch.GenerateUtils;
import org.apache.kyuubi.shade.io.trino.tpch.TpchEntity;

public class LineItem
implements TpchEntity {
    private final long rowNumber;
    private final long orderKey;
    private final long partKey;
    private final long supplierKey;
    private final int lineNumber;
    private final long quantity;
    private final long extendedPrice;
    private final long discount;
    private final long tax;
    private final String returnFlag;
    private final String status;
    private final int shipDate;
    private final int commitDate;
    private final int receiptDate;
    private final String shipInstructions;
    private final String shipMode;
    private final String comment;

    public LineItem(long rowNumber, long orderKey, long partKey, long supplierKey, int lineNumber, long quantity, long extendedPrice, long discount, long tax, String returnFlag, String status, int shipDate, int commitDate, int receiptDate, String shipInstructions, String shipMode, String comment) {
        this.rowNumber = rowNumber;
        this.orderKey = orderKey;
        this.partKey = partKey;
        this.supplierKey = supplierKey;
        this.lineNumber = lineNumber;
        this.quantity = quantity;
        this.extendedPrice = extendedPrice;
        this.discount = discount;
        this.tax = tax;
        this.returnFlag = Objects.requireNonNull(returnFlag, "returnFlag is null");
        this.status = Objects.requireNonNull(status, "status is null");
        this.shipDate = shipDate;
        this.commitDate = commitDate;
        this.receiptDate = receiptDate;
        this.shipInstructions = Objects.requireNonNull(shipInstructions, "shipInstructions is null");
        this.shipMode = Objects.requireNonNull(shipMode, "shipMode is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    @Override
    public long getRowNumber() {
        return this.rowNumber;
    }

    public long getOrderKey() {
        return this.orderKey;
    }

    public long getPartKey() {
        return this.partKey;
    }

    public long getSupplierKey() {
        return this.supplierKey;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public long getQuantity() {
        return this.quantity;
    }

    public double getExtendedPrice() {
        return (double)this.extendedPrice / 100.0;
    }

    public long getExtendedPriceInCents() {
        return this.extendedPrice;
    }

    public double getDiscount() {
        return (double)this.discount / 100.0;
    }

    public long getDiscountPercent() {
        return this.discount;
    }

    public double getTax() {
        return (double)this.tax / 100.0;
    }

    public long getTaxPercent() {
        return this.tax;
    }

    public String getReturnFlag() {
        return this.returnFlag;
    }

    public String getStatus() {
        return this.status;
    }

    public int getShipDate() {
        return this.shipDate;
    }

    public int getCommitDate() {
        return this.commitDate;
    }

    public int getReceiptDate() {
        return this.receiptDate;
    }

    public String getShipInstructions() {
        return this.shipInstructions;
    }

    public String getShipMode() {
        return this.shipMode;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public String toLine() {
        return String.format(Locale.ENGLISH, "%d|%d|%d|%d|%d|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|", this.orderKey, this.partKey, this.supplierKey, this.lineNumber, this.quantity, GenerateUtils.formatMoney(this.extendedPrice), GenerateUtils.formatMoney(this.discount), GenerateUtils.formatMoney(this.tax), this.returnFlag, this.status, GenerateUtils.formatDate(this.shipDate), GenerateUtils.formatDate(this.commitDate), GenerateUtils.formatDate(this.receiptDate), this.shipInstructions, this.shipMode, this.comment);
    }
}

