/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.metrics;

import java.time.Duration;
import org.apache.kyuubi.config.ConfigBuilder;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.config.TypedConfigBuilder;
import org.apache.kyuubi.metrics.ReporterType$;
import scala.Function1;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class MetricsConf$ {
    public static MetricsConf$ MODULE$;
    private final ConfigEntry<Object> METRICS_ENABLED;
    private final ConfigEntry<Seq<String>> METRICS_REPORTERS;
    private final ConfigEntry<Object> METRICS_CONSOLE_INTERVAL;
    private final ConfigEntry<String> METRICS_JSON_LOCATION;
    private final ConfigEntry<Object> METRICS_JSON_INTERVAL;
    private final ConfigEntry<Object> METRICS_PROMETHEUS_PORT;
    private final ConfigEntry<String> METRICS_PROMETHEUS_PATH;
    private final ConfigEntry<Object> METRICS_SLF4J_INTERVAL;

    static {
        new MetricsConf$();
    }

    private ConfigBuilder buildConf(String key) {
        return KyuubiConf$.MODULE$.buildConf(key);
    }

    public ConfigEntry<Object> METRICS_ENABLED() {
        return this.METRICS_ENABLED;
    }

    public ConfigEntry<Seq<String>> METRICS_REPORTERS() {
        return this.METRICS_REPORTERS;
    }

    public ConfigEntry<Object> METRICS_CONSOLE_INTERVAL() {
        return this.METRICS_CONSOLE_INTERVAL;
    }

    public ConfigEntry<String> METRICS_JSON_LOCATION() {
        return this.METRICS_JSON_LOCATION;
    }

    public ConfigEntry<Object> METRICS_JSON_INTERVAL() {
        return this.METRICS_JSON_INTERVAL;
    }

    public ConfigEntry<Object> METRICS_PROMETHEUS_PORT() {
        return this.METRICS_PROMETHEUS_PORT;
    }

    public ConfigEntry<String> METRICS_PROMETHEUS_PATH() {
        return this.METRICS_PROMETHEUS_PATH;
    }

    public ConfigEntry<Object> METRICS_SLF4J_INTERVAL() {
        return this.METRICS_SLF4J_INTERVAL;
    }

    private MetricsConf$() {
        MODULE$ = this;
        this.METRICS_ENABLED = this.buildConf("metrics.enabled").doc("Set to true to enable kyuubi metrics system").version("1.2.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
        TypedConfigBuilder qual$1 = this.buildConf("metrics.reporters").doc("A comma separated list for all metrics reporters<ul> <li>CONSOLE - ConsoleReporter which outputs measurements to CONSOLE periodically.</li> <li>JMX - JmxReporter which listens for new metrics and exposes them as MBeans.</li>  <li>JSON - JsonReporter which outputs measurements to json file periodically.</li> <li>PROMETHEUS - PrometheusReporter which exposes metrics in prometheus format.</li> <li>SLF4J - Slf4jReporter which outputs measurements to system log periodically.</li></ul>").version("1.2.0").stringConf().transform((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.toUpperCase());
        String x$12 = qual$1.toSequence$default$1();
        this.METRICS_REPORTERS = qual$1.toSequence(x$12).createWithDefault((Object)new .colon.colon((Object)ReporterType$.MODULE$.JSON().toString(), (List)Nil$.MODULE$));
        this.METRICS_CONSOLE_INTERVAL = this.buildConf("metrics.console.interval").doc("How often should report metrics to console").version("1.2.0").timeConf().createWithDefault((Object)BoxesRunTime.boxToLong((long)Duration.ofSeconds(5L).toMillis()));
        this.METRICS_JSON_LOCATION = this.buildConf("metrics.json.location").doc("Where the json metrics file located").version("1.2.0").stringConf().createWithDefault((Object)"metrics");
        this.METRICS_JSON_INTERVAL = this.buildConf("metrics.json.interval").doc("How often should report metrics to json file").version("1.2.0").timeConf().createWithDefault((Object)BoxesRunTime.boxToLong((long)Duration.ofSeconds(5L).toMillis()));
        this.METRICS_PROMETHEUS_PORT = this.buildConf("metrics.prometheus.port").doc("Prometheus metrics HTTP server port").version("1.2.0").intConf().checkValue((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)p -> p == 0 || p > 1024 && p < 65535, "Invalid Port number").createWithDefault((Object)BoxesRunTime.boxToInteger((int)10019));
        this.METRICS_PROMETHEUS_PATH = this.buildConf("metrics.prometheus.path").doc("URI context path of prometheus metrics HTTP server").version("1.2.0").stringConf().checkValue((Function1 & java.io.Serializable & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)path.startsWith("/")), "Context path must start with '/'").createWithDefault((Object)"/metrics");
        this.METRICS_SLF4J_INTERVAL = this.buildConf("metrics.slf4j.interval").doc("How often should report metrics to SLF4J logger").version("1.2.0").timeConf().createWithDefault((Object)BoxesRunTime.boxToLong((long)Duration.ofSeconds(5L).toMillis()));
    }
}

