/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.hive.jdbc.HiveConnection;
import org.apache.hive.jdbc.HiveDatabaseMetaData;
import org.apache.hive.jdbc.HiveQueryResultSet;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.rpc.thrift.TGetTablesReq;
import org.apache.hive.service.rpc.thrift.TGetTablesResp;
import org.apache.hive.service.rpc.thrift.TSessionHandle;
import org.apache.hive.service.rpc.thrift.TStatus;
import org.apache.hive.service.rpc.thrift.TStatusCode;
import org.apache.kyuubi.jdbc.KyuubiConnection;
import org.apache.thrift.TException;

public class KyuubiDatabaseMetaData
extends HiveDatabaseMetaData {
    private final KyuubiConnection conn;
    private final TCLIService.Iface client;
    private final TSessionHandle sessHandle;

    public KyuubiDatabaseMetaData(KyuubiConnection conn, TCLIService.Iface client, TSessionHandle sessHandle) {
        super((HiveConnection)conn, client, sessHandle);
        this.conn = conn;
        this.client = client;
        this.sessHandle = sessHandle;
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        TGetTablesResp getTableResp;
        TGetTablesReq getTableReq = new TGetTablesReq(this.sessHandle);
        getTableReq.setCatalogName(catalog);
        getTableReq.setSchemaName(schemaPattern == null ? "%" : schemaPattern);
        getTableReq.setTableName(tableNamePattern);
        if (types != null) {
            getTableReq.setTableTypes(Arrays.asList(types));
        }
        try {
            getTableResp = this.client.GetTables(getTableReq);
        }
        catch (TException rethrow) {
            throw new SQLException(rethrow.getMessage(), "08S01", rethrow);
        }
        TStatus tStatus = getTableResp.getStatus();
        if (tStatus.getStatusCode() != TStatusCode.SUCCESS_STATUS) {
            throw new HiveSQLException(tStatus);
        }
        return new HiveQueryResultSet.Builder((Connection)((Object)this.conn)).setClient(this.client).setSessionHandle(this.sessHandle).setStmtHandle(getTableResp.getOperationHandle()).build();
    }
}

