/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc;

import java.lang.reflect.Field;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hive.jdbc.HiveConnection;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.rpc.thrift.TSessionHandle;
import org.apache.kyuubi.jdbc.KyuubiDatabaseMetaData;

public class KyuubiConnection
extends HiveConnection {
    public KyuubiConnection(String url, Properties info) throws SQLException {
        super(url, info);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
        try {
            Field clientField = HiveConnection.class.getDeclaredField("client");
            clientField.setAccessible(true);
            TCLIService.Iface client = (TCLIService.Iface)clientField.get((Object)this);
            Field handleField = HiveConnection.class.getDeclaredField("sessHandle");
            handleField.setAccessible(true);
            TSessionHandle sessionHandle = (TSessionHandle)handleField.get((Object)this);
            return new KyuubiDatabaseMetaData(this, client, sessionHandle);
        }
        catch (IllegalAccessException | NoSuchFieldException rethrow) {
            throw new RuntimeException(rethrow);
        }
    }
}

