/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.jute.compiler;

import org.apache.kyuubi.shaded.jute.compiler.JType;

abstract class JCompType
extends JType {
    JCompType(String cType, String cppType, String csharpType, String javaType, String suffix, String wrapper, String csharpWrapper) {
        super(cType, cppType, csharpType, javaType, suffix, wrapper, csharpWrapper, null);
    }

    @Override
    String genCppGetSet(String fname, int fIdx) {
        String cgetFunc = "  virtual const " + this.getCppType() + "& get" + fname + "() const {\n";
        cgetFunc = cgetFunc + "    return m" + fname + ";\n";
        cgetFunc = cgetFunc + "  }\n";
        String getFunc = "  virtual " + this.getCppType() + "& get" + fname + "() {\n";
        getFunc = getFunc + "    bs_.set(" + fIdx + ");return m" + fname + ";\n";
        getFunc = getFunc + "  }\n";
        return cgetFunc + getFunc;
    }

    @Override
    String genJavaCompareTo(String fname) {
        return "    ret = " + fname + ".compareTo(peer." + fname + ");\n";
    }

    @Override
    String genJavaEquals(String fname, String peer) {
        return "    ret = " + fname + ".equals(" + peer + ");\n";
    }

    @Override
    String genJavaHashCode(String fname) {
        return "    ret = " + fname + ".hashCode();\n";
    }

    @Override
    String genCsharpHashCode(String fname) {
        return "    ret = " + JCompType.capitalize(fname) + ".GetHashCode();\n";
    }

    @Override
    String genCsharpEquals(String name, String peer) {
        String[] peerSplit = peer.split("\\.");
        return "    ret = " + JCompType.capitalize(name) + ".Equals(" + peerSplit[0] + "." + JCompType.capitalize(peerSplit[1]) + ");\n";
    }

    @Override
    String genCsharpCompareTo(String name) {
        return "    ret = " + JCompType.capitalize(name) + ".CompareTo(peer." + JCompType.capitalize(name) + ");\n";
    }
}

