/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.thrift;

import java.util.Collections;
import java.util.Map;
import org.apache.kyuubi.shade.org.apache.thrift.AsyncProcessFunction;
import org.apache.kyuubi.shade.org.apache.thrift.TApplicationException;
import org.apache.kyuubi.shade.org.apache.thrift.TAsyncProcessor;
import org.apache.kyuubi.shade.org.apache.thrift.TBase;
import org.apache.kyuubi.shade.org.apache.thrift.TException;
import org.apache.kyuubi.shade.org.apache.thrift.TProcessor;
import org.apache.kyuubi.shade.org.apache.thrift.protocol.TMessage;
import org.apache.kyuubi.shade.org.apache.thrift.protocol.TProtocol;
import org.apache.kyuubi.shade.org.apache.thrift.protocol.TProtocolException;
import org.apache.kyuubi.shade.org.apache.thrift.protocol.TProtocolUtil;
import org.apache.kyuubi.shade.org.apache.thrift.server.AbstractNonblockingServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TBaseAsyncProcessor<I>
implements TAsyncProcessor,
TProcessor {
    protected final Logger LOGGER = LoggerFactory.getLogger((String)this.getClass().getName());
    final I iface;
    final Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> processMap;

    public TBaseAsyncProcessor(I iface, Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> processMap) {
        this.iface = iface;
        this.processMap = processMap;
    }

    public Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> getProcessMapView() {
        return Collections.unmodifiableMap(this.processMap);
    }

    @Override
    public boolean process(AbstractNonblockingServer.AsyncFrameBuffer fb) throws TException {
        TProtocol in = fb.getInputProtocol();
        TProtocol out = fb.getOutputProtocol();
        TMessage msg = in.readMessageBegin();
        AsyncProcessFunction<I, TBase, ?> fn = this.processMap.get(msg.name);
        if (fn == null) {
            TProtocolUtil.skip(in, (byte)12);
            in.readMessageEnd();
            TApplicationException x = new TApplicationException(1, "Invalid method name: '" + msg.name + "'");
            out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
            x.write(out);
            out.writeMessageEnd();
            out.getTransport().flush();
            fb.responseReady();
            return true;
        }
        TBase args = fn.getEmptyArgsInstance();
        try {
            args.read(in);
        }
        catch (TProtocolException e) {
            in.readMessageEnd();
            TApplicationException x = new TApplicationException(7, e.getMessage());
            out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
            x.write(out);
            out.writeMessageEnd();
            out.getTransport().flush();
            fb.responseReady();
            return true;
        }
        in.readMessageEnd();
        fn.start(this.iface, args, fn.getResultHandler(fb, msg.seqid));
        return true;
    }

    @Override
    public boolean process(TProtocol in, TProtocol out) throws TException {
        return false;
    }
}

