/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.kyuubi.shade.org.apache.thrift.TBase;
import org.apache.kyuubi.shade.org.apache.thrift.TBaseHelper;
import org.apache.kyuubi.shade.org.apache.thrift.TException;
import org.apache.kyuubi.shade.org.apache.thrift.TFieldIdEnum;
import org.apache.kyuubi.shade.org.apache.thrift.meta_data.FieldMetaData;
import org.apache.kyuubi.shade.org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.kyuubi.shade.org.apache.thrift.meta_data.ListMetaData;
import org.apache.kyuubi.shade.org.apache.thrift.protocol.TCompactProtocol;
import org.apache.kyuubi.shade.org.apache.thrift.protocol.TField;
import org.apache.kyuubi.shade.org.apache.thrift.protocol.TList;
import org.apache.kyuubi.shade.org.apache.thrift.protocol.TProtocol;
import org.apache.kyuubi.shade.org.apache.thrift.protocol.TProtocolException;
import org.apache.kyuubi.shade.org.apache.thrift.protocol.TProtocolUtil;
import org.apache.kyuubi.shade.org.apache.thrift.protocol.TStruct;
import org.apache.kyuubi.shade.org.apache.thrift.protocol.TTupleProtocol;
import org.apache.kyuubi.shade.org.apache.thrift.scheme.IScheme;
import org.apache.kyuubi.shade.org.apache.thrift.scheme.SchemeFactory;
import org.apache.kyuubi.shade.org.apache.thrift.scheme.StandardScheme;
import org.apache.kyuubi.shade.org.apache.thrift.scheme.TupleScheme;
import org.apache.kyuubi.shade.org.apache.thrift.transport.TIOStreamTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TI32Column
implements TBase<TI32Column, _Fields>,
Serializable,
Cloneable,
Comparable<TI32Column> {
    private static final TStruct STRUCT_DESC = new TStruct("TI32Column");
    private static final TField VALUES_FIELD_DESC = new TField("values", 15, 1);
    private static final TField NULLS_FIELD_DESC = new TField("nulls", 11, 2);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private List<Integer> values;
    private ByteBuffer nulls;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TI32Column() {
    }

    public TI32Column(List<Integer> values, ByteBuffer nulls) {
        this();
        this.values = values;
        this.nulls = TBaseHelper.copyBinary(nulls);
    }

    public TI32Column(TI32Column other) {
        if (other.isSetValues()) {
            ArrayList<Integer> __this__values = new ArrayList<Integer>(other.values);
            this.values = __this__values;
        }
        if (other.isSetNulls()) {
            this.nulls = TBaseHelper.copyBinary(other.nulls);
        }
    }

    public TI32Column deepCopy() {
        return new TI32Column(this);
    }

    @Override
    public void clear() {
        this.values = null;
        this.nulls = null;
    }

    public int getValuesSize() {
        return this.values == null ? 0 : this.values.size();
    }

    public Iterator<Integer> getValuesIterator() {
        return this.values == null ? null : this.values.iterator();
    }

    public void addToValues(int elem) {
        if (this.values == null) {
            this.values = new ArrayList<Integer>();
        }
        this.values.add(elem);
    }

    public List<Integer> getValues() {
        return this.values;
    }

    public void setValues(List<Integer> values) {
        this.values = values;
    }

    public void unsetValues() {
        this.values = null;
    }

    public boolean isSetValues() {
        return this.values != null;
    }

    public void setValuesIsSet(boolean value) {
        if (!value) {
            this.values = null;
        }
    }

    public byte[] getNulls() {
        this.setNulls(TBaseHelper.rightSize(this.nulls));
        return this.nulls == null ? null : this.nulls.array();
    }

    public ByteBuffer bufferForNulls() {
        return TBaseHelper.copyBinary(this.nulls);
    }

    public void setNulls(byte[] nulls) {
        this.nulls = nulls == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(nulls, nulls.length));
    }

    public void setNulls(ByteBuffer nulls) {
        this.nulls = TBaseHelper.copyBinary(nulls);
    }

    public void unsetNulls() {
        this.nulls = null;
    }

    public boolean isSetNulls() {
        return this.nulls != null;
    }

    public void setNullsIsSet(boolean value) {
        if (!value) {
            this.nulls = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case VALUES: {
                if (value == null) {
                    this.unsetValues();
                    break;
                }
                this.setValues((List)value);
                break;
            }
            case NULLS: {
                if (value == null) {
                    this.unsetNulls();
                    break;
                }
                this.setNulls((ByteBuffer)value);
            }
        }
    }

    @Override
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case VALUES: {
                return this.getValues();
            }
            case NULLS: {
                return this.getNulls();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case VALUES: {
                return this.isSetValues();
            }
            case NULLS: {
                return this.isSetNulls();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TI32Column) {
            return this.equals((TI32Column)that);
        }
        return false;
    }

    public boolean equals(TI32Column that) {
        if (that == null) {
            return false;
        }
        boolean this_present_values = this.isSetValues();
        boolean that_present_values = that.isSetValues();
        if (this_present_values || that_present_values) {
            if (!this_present_values || !that_present_values) {
                return false;
            }
            if (!this.values.equals(that.values)) {
                return false;
            }
        }
        boolean this_present_nulls = this.isSetNulls();
        boolean that_present_nulls = that.isSetNulls();
        if (this_present_nulls || that_present_nulls) {
            if (!this_present_nulls || !that_present_nulls) {
                return false;
            }
            if (!this.nulls.equals(that.nulls)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_values = this.isSetValues();
        list.add(present_values);
        if (present_values) {
            list.add(this.values);
        }
        boolean present_nulls = this.isSetNulls();
        list.add(present_nulls);
        if (present_nulls) {
            list.add(this.nulls);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(TI32Column other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetValues()).compareTo(other.isSetValues());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetValues() && (lastComparison = TBaseHelper.compareTo(this.values, other.values)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNulls()).compareTo(other.isSetNulls());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNulls() && (lastComparison = TBaseHelper.compareTo(this.nulls, other.nulls)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TI32Column)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TI32Column)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TI32Column(");
        boolean first = true;
        sb.append("values:");
        if (this.values == null) {
            sb.append("null");
        } else {
            sb.append(this.values);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("nulls:");
        if (this.nulls == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString(this.nulls, sb);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetValues()) {
            throw new TProtocolException("Required field 'values' is unset! Struct:" + this.toString());
        }
        if (!this.isSetNulls()) {
            throw new TProtocolException("Required field 'nulls' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new TI32ColumnStandardSchemeFactory());
        schemes.put(TupleScheme.class, new TI32ColumnTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.VALUES, new FieldMetaData("values", 1, new ListMetaData(15, new FieldValueMetaData(8))));
        tmpMap.put(_Fields.NULLS, new FieldMetaData("nulls", 1, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TI32Column.class, metaDataMap);
    }

    private static class TI32ColumnTupleScheme
    extends TupleScheme<TI32Column> {
        private TI32ColumnTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, TI32Column struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.values.size());
            Iterator iterator = struct.values.iterator();
            while (iterator.hasNext()) {
                int _iter82 = (Integer)iterator.next();
                oprot.writeI32(_iter82);
            }
            oprot.writeBinary(struct.nulls);
        }

        @Override
        public void read(TProtocol prot, TI32Column struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            TList _list83 = new TList(8, iprot.readI32());
            struct.values = new ArrayList(_list83.size);
            for (int _i85 = 0; _i85 < _list83.size; ++_i85) {
                int _elem84 = iprot.readI32();
                struct.values.add(_elem84);
            }
            struct.setValuesIsSet(true);
            struct.nulls = iprot.readBinary();
            struct.setNullsIsSet(true);
        }
    }

    private static class TI32ColumnTupleSchemeFactory
    implements SchemeFactory {
        private TI32ColumnTupleSchemeFactory() {
        }

        public TI32ColumnTupleScheme getScheme() {
            return new TI32ColumnTupleScheme();
        }
    }

    private static class TI32ColumnStandardScheme
    extends StandardScheme<TI32Column> {
        private TI32ColumnStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, TI32Column struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 15) {
                            TList _list78 = iprot.readListBegin();
                            struct.values = new ArrayList(_list78.size);
                            for (int _i80 = 0; _i80 < _list78.size; ++_i80) {
                                int _elem79 = iprot.readI32();
                                struct.values.add(_elem79);
                            }
                            iprot.readListEnd();
                            struct.setValuesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.nulls = iprot.readBinary();
                            struct.setNullsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, TI32Column struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.values != null) {
                oprot.writeFieldBegin(VALUES_FIELD_DESC);
                oprot.writeListBegin(new TList(8, struct.values.size()));
                Iterator iterator = struct.values.iterator();
                while (iterator.hasNext()) {
                    int _iter81 = (Integer)iterator.next();
                    oprot.writeI32(_iter81);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.nulls != null) {
                oprot.writeFieldBegin(NULLS_FIELD_DESC);
                oprot.writeBinary(struct.nulls);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TI32ColumnStandardSchemeFactory
    implements SchemeFactory {
        private TI32ColumnStandardSchemeFactory() {
        }

        public TI32ColumnStandardScheme getScheme() {
            return new TI32ColumnStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        VALUES(1, "values"),
        NULLS(2, "nulls");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return VALUES;
                }
                case 2: {
                    return NULLS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

