/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.util;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.logging.LogOutputStream;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.helper.MetadataToolHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetadataUtil.class);
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    private static MetadataToolHelper metadataToolHelper = new MetadataToolHelper();

    private MetadataUtil() {
    }

    public static String getMetadataUrl(String rootPath) {
        if (rootPath.startsWith("file://")) {
            rootPath = rootPath.replace("file://", "");
        }
        return StringUtils.appendIfMissing((String)rootPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    public static DataSource getDataSource(KylinConfig kylinConfig) throws Exception {
        return metadataToolHelper.getDataSource(kylinConfig);
    }

    public static void createTableIfNotExist(BasicDataSource dataSource, String tableName, String tableSql, List<String> indexSqlList) throws IOException, SQLException {
        if (JdbcUtil.isTableExists((Connection)dataSource.getConnection(), (String)tableName)) {
            return;
        }
        if (null == indexSqlList) {
            indexSqlList = Lists.newArrayList();
        }
        Properties properties = JdbcUtil.getProperties((BasicDataSource)dataSource);
        String createTableStmt = String.format(Locale.ROOT, properties.getProperty(tableSql), tableName);
        List<String> crateIndexStmtList = indexSqlList.stream().map(indexSql -> String.format(Locale.ROOT, properties.getProperty((String)indexSql), tableName, tableName)).collect(Collectors.toList());
        try (Connection connection = dataSource.getConnection();){
            ScriptRunner sr = new ScriptRunner(connection);
            sr.setLogWriter(new PrintWriter(new OutputStreamWriter((OutputStream)new LogOutputStream(log), DEFAULT_CHARSET)));
            sr.setStopOnError(true);
            sr.runScript((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(createTableStmt.getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET));
            crateIndexStmtList.forEach(crateIndexStmt -> sr.runScript((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(crateIndexStmt.getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET)));
        }
    }

    public static void createTableIfNotExist(BasicDataSource dataSource, String tableName, String createTableStmt) throws SQLException {
        if (JdbcUtil.isTableExists((Connection)dataSource.getConnection(), (String)tableName)) {
            return;
        }
        try (Connection connection = dataSource.getConnection();){
            ScriptRunner sr = new ScriptRunner(connection);
            sr.setLogWriter(new PrintWriter(new OutputStreamWriter((OutputStream)new LogOutputStream(log), DEFAULT_CHARSET)));
            sr.setStopOnError(true);
            sr.runScript((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(createTableStmt.getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET));
        }
    }
}

